/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WebResult;
import org.owasp.encoder.Encode;

@HopServerServlet(id="startExec", name="Start the execution of a pipeline")
public class StartExecutionPipelineServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final Class<?> PKG = StartExecutionPipelineServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/hop/startExec";

    public StartExecutionPipelineServlet() {
    }

    public StartExecutionPipelineServlet(PipelineMap pipelineMap) {
        super(pipelineMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug("Start execution of pipeline requested");
        }
        response.setStatus(200);
        String pipelineName = request.getParameter("name");
        String id = request.getParameter("id");
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        PrintWriter out = response.getWriter();
        if (useXML) {
            response.setContentType("text/xml");
            out.print(XmlHandler.getXmlHeader((String)"UTF-8"));
        } else {
            response.setContentType("text/html;charset=UTF-8");
            out.println("<HTML>");
            out.println("<HEAD>");
            out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"PrepareExecutionPipelineServlet.PipelinePrepareExecution", (String[])new String[0]) + "</TITLE>");
            out.println("<META http-equiv=\"Refresh\" content=\"2;url=" + this.convertContextPath("/hop/status") + "?name=" + URLEncoder.encode(pipelineName, "UTF-8") + "\">");
            out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            out.println("<link rel=\"icon\" type=\"image/svg+xml\" href=\"/static/images/favicon.svg\">");
            out.println("</HEAD>");
            out.println("<BODY>");
        }
        try {
            IPipelineEngine<PipelineMeta> pipeline;
            if (Utils.isEmpty((CharSequence)id)) {
                HopServerObjectEntry entry = this.getPipelineMap().getFirstServerObjectEntry(pipelineName);
                if (entry == null) {
                    pipeline = null;
                } else {
                    id = entry.getId();
                    pipeline = this.getPipelineMap().getPipeline(entry);
                }
            } else {
                HopServerObjectEntry entry = new HopServerObjectEntry(pipelineName, id);
                pipeline = this.getPipelineMap().getPipeline(entry);
            }
            if (pipeline != null) {
                if (pipeline.isReadyToStart()) {
                    this.startThreads(pipeline);
                    if (useXML) {
                        out.println(WebResult.OK.getXml());
                    } else {
                        out.println("<H1>Pipeline " + Encode.forHtml((String)("'" + pipelineName + "'")) + " has been executed.</H1>");
                        out.println("<a href=\"" + this.convertContextPath("/hop/pipelineStatus") + "?name=" + URLEncoder.encode(pipelineName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">Back to the pipeline status page</a><p>");
                    }
                } else {
                    String message = "The specified pipeline [" + pipelineName + "] is not ready to be started. (Was not prepared for execution)";
                    if (useXML) {
                        out.println(new WebResult("ERROR", message));
                    } else {
                        out.println("<H1>" + Encode.forHtml((String)message) + "</H1>");
                        out.println("<a href=\"" + this.convertContextPath("/hop/status") + "\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
                    }
                }
            } else if (useXML) {
                out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Log.CoundNotFindSpecPipeline", (String[])new String[]{pipelineName})));
            } else {
                out.println("<H1>" + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Log.CoundNotFindPipeline", (String[])new String[]{pipelineName})) + "</H1>");
                out.println("<a href=\"" + this.convertContextPath("/hop/status") + "\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", "Unexpected error during pipeline execution preparation:" + Const.CR + Const.getStackTracker((Throwable)ex)));
            }
            out.println("<p>");
            out.println("<pre>");
            out.println(Encode.forHtml((String)Const.getStackTracker((Throwable)ex)));
            out.println("</pre>");
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Start pipeline";
    }

    @Override
    public String getService() {
        return "/hop/startExec (" + this.toString() + ")";
    }

    protected void startThreads(IPipelineEngine<PipelineMeta> pipeline) throws HopException {
        pipeline.startThreads();
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

