/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.common.base.Strings;
import javax.annotation.Nullable;

class ConnectionPreconditions {
    ConnectionPreconditions() {
    }

    static void checkState(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, String.valueOf(errorMessage));
        }
    }

    static void checkArgument(boolean expression, String message) {
        if (!expression) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, message);
        }
    }

    static String checkValidIdentifier(String identifier) {
        ConnectionPreconditions.checkArgument(!Strings.isNullOrEmpty((String)identifier), "Identifier may not be null or empty");
        ConnectionPreconditions.checkArgument(Character.isJavaIdentifierStart(identifier.charAt(0)), "Invalid identifier: " + identifier);
        for (int i = 1; i < identifier.length(); ++i) {
            ConnectionPreconditions.checkArgument(Character.isJavaIdentifierPart(identifier.charAt(i)), "Invalid identifier: " + identifier);
        }
        ConnectionPreconditions.checkArgument(identifier.length() <= 128, "Max identifier length is 128 characters");
        return identifier;
    }
}

