/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.InMemoryStateInternals;
import org.apache.beam.runners.core.InMemoryTimerInternals;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateTags;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.metrics.FlinkMetricContainer;
import org.apache.beam.runners.flink.translation.functions.FlinkExecutableStageContextFactory;
import org.apache.beam.runners.fnexecution.control.BundleCheckpointHandler;
import org.apache.beam.runners.fnexecution.control.BundleCheckpointHandlers;
import org.apache.beam.runners.fnexecution.control.BundleFinalizationHandler;
import org.apache.beam.runners.fnexecution.control.BundleProgressHandler;
import org.apache.beam.runners.fnexecution.control.ExecutableStageContext;
import org.apache.beam.runners.fnexecution.control.OutputReceiverFactory;
import org.apache.beam.runners.fnexecution.control.ProcessBundleDescriptors;
import org.apache.beam.runners.fnexecution.control.RemoteBundle;
import org.apache.beam.runners.fnexecution.control.StageBundleFactory;
import org.apache.beam.runners.fnexecution.control.TimerReceiverFactory;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.fnexecution.state.InMemoryBagUserStateFactory;
import org.apache.beam.runners.fnexecution.state.StateRequestHandler;
import org.apache.beam.runners.fnexecution.state.StateRequestHandlers;
import org.apache.beam.runners.fnexecution.translation.BatchSideInputHandlerFactory;
import org.apache.beam.runners.fnexecution.translation.PipelineTranslatorUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkExecutableStageFunction<@UnknownKeyFor InputT>
extends AbstractRichFunction
implements MapPartitionFunction<WindowedValue<InputT>, RawUnionValue>,
GroupReduceFunction<WindowedValue<InputT>, RawUnionValue> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FlinkExecutableStageFunction.class);
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions pipelineOptions;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload stagePayload;
    private final @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> outputMap;
    private final @UnknownKeyFor @NonNull @Initialized FlinkExecutableStageContextFactory contextFactory;
    private final @UnknownKeyFor @NonNull @Initialized Coder windowCoder;
    private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> inputCoder;
    private final @UnknownKeyFor @NonNull @Initialized String stepName;
    private transient @UnknownKeyFor @NonNull @Initialized RuntimeContext runtimeContext;
    private transient @UnknownKeyFor @NonNull @Initialized FlinkMetricContainer metricContainer;
    private transient @UnknownKeyFor @NonNull @Initialized StateRequestHandler stateRequestHandler;
    private transient @UnknownKeyFor @NonNull @Initialized ExecutableStageContext stageContext;
    private transient @UnknownKeyFor @NonNull @Initialized StageBundleFactory stageBundleFactory;
    private transient @UnknownKeyFor @NonNull @Initialized BundleProgressHandler progressHandler;
    private transient @UnknownKeyFor @NonNull @Initialized BundleFinalizationHandler finalizationHandler;
    private transient @UnknownKeyFor @NonNull @Initialized BundleCheckpointHandler bundleCheckpointHandler;
    private transient @UnknownKeyFor @NonNull @Initialized InMemoryTimerInternals sdfTimerInternals;
    private transient @UnknownKeyFor @NonNull @Initialized StateInternals sdfStateInternals;
    private transient @UnknownKeyFor @NonNull @Initialized InMemoryBagUserStateFactory bagUserStateHandlerFactory;
    private transient @UnknownKeyFor @NonNull @Initialized ExecutableStage executableStage;
    private transient @UnknownKeyFor @NonNull @Initialized Object currentTimerKey;

    public FlinkExecutableStageFunction(@UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload stagePayload, @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> outputMap, @UnknownKeyFor @NonNull @Initialized FlinkExecutableStageContextFactory contextFactory, @UnknownKeyFor @NonNull @Initialized Coder windowCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> inputCoder) {
        this.stepName = stepName;
        this.pipelineOptions = new SerializablePipelineOptions(pipelineOptions);
        this.stagePayload = stagePayload;
        this.jobInfo = jobInfo;
        this.outputMap = outputMap;
        this.contextFactory = contextFactory;
        this.windowCoder = windowCoder;
        this.inputCoder = inputCoder;
    }

    public void open(@UnknownKeyFor @NonNull @Initialized Configuration parameters) {
        FlinkPipelineOptions options = (FlinkPipelineOptions)this.pipelineOptions.get().as(FlinkPipelineOptions.class);
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        this.executableStage = ExecutableStage.fromPayload((RunnerApi.ExecutableStagePayload)this.stagePayload);
        this.runtimeContext = this.getRuntimeContext();
        this.metricContainer = new FlinkMetricContainer(this.runtimeContext);
        this.stageContext = this.contextFactory.get(this.jobInfo);
        this.stageBundleFactory = this.stageContext.getStageBundleFactory(this.executableStage);
        this.stateRequestHandler = this.getStateRequestHandler(this.executableStage, this.stageBundleFactory.getProcessBundleDescriptor(), this.runtimeContext);
        this.progressHandler = new BundleProgressHandler(){

            public void onProgress(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleProgressResponse progress) {
                FlinkExecutableStageFunction.this.metricContainer.updateMetrics(FlinkExecutableStageFunction.this.stepName, progress.getMonitoringInfosList());
            }

            public void onCompleted(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleResponse response) {
                FlinkExecutableStageFunction.this.metricContainer.updateMetrics(FlinkExecutableStageFunction.this.stepName, response.getMonitoringInfosList());
            }
        };
        this.finalizationHandler = bundleId -> {
            throw new UnsupportedOperationException("Portable Flink runner doesn't support bundle finalization in batch mode. For more details, please refer to https://github.com/apache/beam/issues/19526.");
        };
        this.bundleCheckpointHandler = this.getBundleCheckpointHandler(this.executableStage);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean hasSDF(@UnknownKeyFor @NonNull @Initialized ExecutableStage executableStage) {
        return executableStage.getTransforms().stream().anyMatch(pTransformNode -> pTransformNode.getTransform().getSpec().getUrn().equals("beam:transform:sdf_process_sized_element_and_restrictions:v1"));
    }

    private @UnknownKeyFor @NonNull @Initialized BundleCheckpointHandler getBundleCheckpointHandler(@UnknownKeyFor @NonNull @Initialized ExecutableStage executableStage) {
        if (!this.hasSDF(executableStage)) {
            this.sdfStateInternals = null;
            this.sdfStateInternals = null;
            return response -> {
                throw new UnsupportedOperationException("Self-checkpoint is only supported on splittable DoFn.");
            };
        }
        this.sdfTimerInternals = new InMemoryTimerInternals();
        this.sdfStateInternals = InMemoryStateInternals.forKey((Object)"sdf_state");
        return new BundleCheckpointHandlers.StateAndTimerBundleCheckpointHandler(key -> this.sdfTimerInternals, key -> this.sdfStateInternals, this.inputCoder, this.windowCoder);
    }

    private @UnknownKeyFor @NonNull @Initialized StateRequestHandler getStateRequestHandler(@UnknownKeyFor @NonNull @Initialized ExecutableStage executableStage, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized ProcessBundleDescriptors.ExecutableProcessBundleDescriptor processBundleDescriptor, @UnknownKeyFor @NonNull @Initialized RuntimeContext runtimeContext) {
        StateRequestHandler userStateHandler;
        StateRequestHandler sideInputHandler;
        BatchSideInputHandlerFactory sideInputHandlerFactory = BatchSideInputHandlerFactory.forStage((ExecutableStage)executableStage, arg_0 -> ((RuntimeContext)runtimeContext).getBroadcastVariable(arg_0));
        try {
            sideInputHandler = StateRequestHandlers.forSideInputHandlerFactory((Map)ProcessBundleDescriptors.getSideInputs((ExecutableStage)executableStage), (StateRequestHandlers.SideInputHandlerFactory)sideInputHandlerFactory);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to setup state handler", e);
        }
        if (executableStage.getUserStates().size() > 0) {
            this.bagUserStateHandlerFactory = new InMemoryBagUserStateFactory();
            userStateHandler = StateRequestHandlers.forBagUserStateHandlerFactory((ProcessBundleDescriptors.ExecutableProcessBundleDescriptor)processBundleDescriptor, (StateRequestHandlers.BagUserStateHandlerFactory)this.bagUserStateHandlerFactory);
        } else {
            userStateHandler = StateRequestHandler.unsupported();
        }
        EnumMap<BeamFnApi.StateKey.TypeCase, StateRequestHandler> handlerMap = new EnumMap<BeamFnApi.StateKey.TypeCase, StateRequestHandler>(BeamFnApi.StateKey.TypeCase.class);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.ITERABLE_SIDE_INPUT, sideInputHandler);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.MULTIMAP_SIDE_INPUT, sideInputHandler);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.MULTIMAP_KEYS_SIDE_INPUT, sideInputHandler);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.BAG_USER_STATE, userStateHandler);
        return StateRequestHandlers.delegateBasedUponType(handlerMap);
    }

    public void mapPartition(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> iterable, @UnknownKeyFor @NonNull @Initialized Collector<@UnknownKeyFor @NonNull @Initialized RawUnionValue> collector) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ReceiverFactory receiverFactory = new ReceiverFactory(collector, this.outputMap);
        if (this.sdfStateInternals != null) {
            this.sdfTimerInternals.advanceProcessingTime(Instant.now());
            this.sdfTimerInternals.advanceSynchronizedProcessingTime(Instant.now());
        }
        try (RemoteBundle bundle = this.stageBundleFactory.getBundle((OutputReceiverFactory)receiverFactory, this.stateRequestHandler, this.progressHandler, this.finalizationHandler, this.bundleCheckpointHandler);){
            this.processElements(iterable, bundle);
        }
        if (this.sdfTimerInternals != null) {
            this.sdfTimerInternals.advanceProcessingTime(BoundedWindow.TIMESTAMP_MAX_VALUE);
            this.sdfTimerInternals.advanceSynchronizedProcessingTime(BoundedWindow.TIMESTAMP_MAX_VALUE);
            while (this.sdfTimerInternals.hasPendingTimers()) {
                bundle = this.stageBundleFactory.getBundle((OutputReceiverFactory)receiverFactory, this.stateRequestHandler, this.progressHandler, this.finalizationHandler, this.bundleCheckpointHandler);
                var5_5 = null;
                try {
                    TimerInternals.TimerData timer;
                    ArrayList<WindowedValue<InputT>> residuals = new ArrayList<WindowedValue<InputT>>();
                    while ((timer = this.sdfTimerInternals.removeNextProcessingTimer()) != null) {
                        WindowedValue stateValue = (WindowedValue)((ValueState)this.sdfStateInternals.state(timer.getNamespace(), StateTags.value((String)timer.getTimerId(), this.inputCoder))).read();
                        residuals.add(stateValue);
                    }
                    this.processElements(residuals, bundle);
                }
                catch (Throwable throwable) {
                    var5_5 = throwable;
                    throw throwable;
                }
                finally {
                    if (bundle != null) {
                        FlinkExecutableStageFunction.$closeResource(var5_5, (AutoCloseable)bundle);
                    }
                }
            }
        }
    }

    public void reduce(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> iterable, @UnknownKeyFor @NonNull @Initialized Collector<@UnknownKeyFor @NonNull @Initialized RawUnionValue> collector) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.bagUserStateHandlerFactory != null) {
            this.bagUserStateHandlerFactory.resetForNewKey();
        }
        InMemoryTimerInternals timerInternals = new InMemoryTimerInternals();
        timerInternals.advanceProcessingTime(Instant.now());
        timerInternals.advanceSynchronizedProcessingTime(Instant.now());
        ReceiverFactory receiverFactory = new ReceiverFactory(collector, this.outputMap);
        TimerReceiverFactory timerReceiverFactory = new TimerReceiverFactory(this.stageBundleFactory, (timer, timerData) -> {
            this.currentTimerKey = timer.getUserKey();
            if (timer.getClearBit()) {
                timerInternals.deleteTimer(timerData);
            } else {
                timerInternals.setTimer(timerData);
            }
        }, this.windowCoder);
        try (RemoteBundle bundle = this.stageBundleFactory.getBundle((OutputReceiverFactory)receiverFactory, timerReceiverFactory, this.stateRequestHandler, this.progressHandler);){
            this.processElements(iterable, bundle);
        }
        timerInternals.advanceInputWatermark(BoundedWindow.TIMESTAMP_MAX_VALUE);
        timerInternals.advanceProcessingTime(BoundedWindow.TIMESTAMP_MAX_VALUE);
        timerInternals.advanceSynchronizedProcessingTime(BoundedWindow.TIMESTAMP_MAX_VALUE);
        while (timerInternals.hasPendingTimers()) {
            bundle = this.stageBundleFactory.getBundle((OutputReceiverFactory)receiverFactory, timerReceiverFactory, this.stateRequestHandler, this.progressHandler);
            var7_7 = null;
            try {
                PipelineTranslatorUtils.fireEligibleTimers((InMemoryTimerInternals)timerInternals, (Map)bundle.getTimerReceivers(), (Object)this.currentTimerKey);
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            finally {
                if (bundle == null) continue;
                FlinkExecutableStageFunction.$closeResource(var7_7, (AutoCloseable)bundle);
            }
        }
    }

    private void processElements(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> iterable, @UnknownKeyFor @NonNull @Initialized RemoteBundle bundle) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Preconditions.checkArgument((bundle != null ? 1 : 0) != 0, (Object)"RemoteBundle must not be null");
        FnDataReceiver mainReceiver = (FnDataReceiver)Iterables.getOnlyElement(bundle.getInputReceivers().values());
        for (WindowedValue<InputT> input : iterable) {
            mainReceiver.accept(input);
        }
    }

    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.metricContainer.registerMetricsForPipelineResult();
        if (this.stageContext != null) {
            try (StageBundleFactory bundleFactoryCloser = this.stageBundleFactory;){
                ExecutableStageContext closable = this.stageContext;
                Throwable throwable = null;
                if (closable != null) {
                    FlinkExecutableStageFunction.$closeResource(throwable, (AutoCloseable)closable);
                }
            }
            catch (Exception e) {
                LOG.error("Error in close: ", (Throwable)e);
                throw e;
            }
        }
        this.stageContext = null;
    }

    private static class ReceiverFactory
    implements OutputReceiverFactory {
        private final @UnknownKeyFor @NonNull @Initialized Object collectorLock = new Object();
        @GuardedBy(value="collectorLock")
        private final @UnknownKeyFor @NonNull @Initialized Collector<@UnknownKeyFor @NonNull @Initialized RawUnionValue> collector;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> outputMap;

        ReceiverFactory(@UnknownKeyFor @NonNull @Initialized Collector<@UnknownKeyFor @NonNull @Initialized RawUnionValue> collector, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> outputMap) {
            this.collector = collector;
            this.outputMap = outputMap;
        }

        public <OutputT> @UnknownKeyFor @NonNull @Initialized FnDataReceiver<OutputT> create(@UnknownKeyFor @NonNull @Initialized String collectionId) {
            Integer unionTag = this.outputMap.get(collectionId);
            if (unionTag != null) {
                int tagInt = unionTag;
                return receivedElement -> {
                    Object object = this.collectorLock;
                    synchronized (object) {
                        this.collector.collect((Object)new RawUnionValue(tagInt, receivedElement));
                    }
                };
            }
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Unknown PCollectionId %s", collectionId));
        }
    }
}

