/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PTransformReplacements {
    public static <T> @UnknownKeyFor @NonNull @Initialized PCollection<T> getSingletonMainInput(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends T>, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
        return PTransformReplacements.getSingletonMainInput(application.getInputs(), application.getTransform().getAdditionalInputs().keySet());
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized PCollection<T> getSingletonMainInput(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputs, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> ignoredTags) {
        PCollection<?> mainInput = null;
        for (Map.Entry<TupleTag<?>, PCollection<?>> input : inputs.entrySet()) {
            if (ignoredTags.contains(input.getKey())) continue;
            Preconditions.checkArgument((mainInput == null ? 1 : 0) != 0, (String)"Got multiple inputs that are not additional inputs for a singleton main input: %s and %s", mainInput, input.getValue());
            Preconditions.checkArgument((boolean)(input.getValue() instanceof PCollection), (String)"Unexpected input type %s", input.getValue().getClass());
            mainInput = input.getValue();
        }
        Preconditions.checkArgument((mainInput != null ? 1 : 0) != 0, (String)"No main input found in inputs: Inputs %s, Side Input tags %s", inputs, ignoredTags);
        return mainInput;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PCollection<T> getSingletonMainOutput(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized PCollection<T>>> transform) {
        return (PCollection)Iterables.getOnlyElement(transform.getOutputs().values());
    }
}

