/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ListUtilities;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.QueuedMessage;
import com.ibm.as400.access.QueuedMessageEnumeration;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.User;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;

public class MessageQueue
implements Serializable {
    static final long serialVersionUID = 5L;
    public static final String ALL = "*ALL";
    public static final String ANY = "*ANY";
    public static final String BYKEY = "*BYKEY";
    public static final String COMPLETION = "*COMP";
    public static final String COPY = "*COPY";
    public static final String CURRENT = "*CURRENT";
    public static final String DIAGNOSTIC = "*DIAG";
    public static final String FIRST = "*FIRST";
    public static final String INFORMATIONAL = "*INFO";
    public static final String INQUIRY = "*INQ";
    public static final String KEEP_UNANSWERED = "*KEEPUNANS";
    public static final String LAST = "*LAST";
    public static final String MESSAGES_NEED_REPLY = "*MNR";
    public static final String MESSAGES_NO_NEED_REPLY = "*MNNR";
    public static final String NEW = "*NEW";
    public static final byte[] NEWEST = new byte[]{-1, -1, -1, -1};
    public static final String NEXT = "*NEXT";
    public static final String OLD = "*OLD";
    public static final byte[] OLDEST = new byte[4];
    public static final String PREVIOUS = "*PRV";
    public static final String REMOVE = "*REMOVE";
    public static final String REPLY = "*RPY";
    public static final String SAME = "*SAME";
    public static final String SENDERS_COPY_NEED_REPLY = "*SCNR";
    private static final byte[] BLANK_KEY = new byte[]{64, 64, 64, 64};
    private AS400 system_;
    private String path_;
    private String library_ = null;
    private String name_ = null;
    private int length_;
    private int dataLength_;
    private byte[] handle_;
    private boolean closeHandle_ = false;
    private boolean sort_ = false;
    private int helpTextFormatting_ = 0;
    private boolean listDirection_ = true;
    private int severity_ = 0;
    private byte[] userStartingMessageKey_;
    private byte[] workstationStartingMessageKey_;
    private String selection_ = "*ALL";
    private boolean selectMessagesNeedReply_ = true;
    private boolean selectMessagesNoNeedReply_ = true;
    private boolean selectSendersCopyMessagesNeedReply_ = true;
    private transient Converter conv_ = null;
    private transient byte[] qualifiedMessageQueueName_ = null;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;

    public MessageQueue() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing MessageQueue object.");
        }
        this.path_ = CURRENT;
    }

    public MessageQueue(AS400 system) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing MessageQueue object, system: " + system);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = system;
        this.path_ = CURRENT;
    }

    public MessageQueue(AS400 system, String path) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing MessageQueue object, system: " + system + " path: " + path);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (path == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        if (!path.equals(CURRENT)) {
            QSYSObjectPathName ifs = new QSYSObjectPathName(path, "MSGQ");
            this.library_ = ifs.getLibraryName();
            this.name_ = ifs.getObjectName();
        }
        this.path_ = path;
        this.system_ = system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(listener);
        }
    }

    public synchronized void close() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Closing message queue message list, handle: ", this.handle_);
        }
        if (this.handle_ == null) {
            return;
        }
        try {
            ListUtilities.closeList(this.system_, this.handle_);
        }
        finally {
            this.handle_ = null;
            this.closeHandle_ = false;
        }
    }

    protected void finalize() throws Throwable {
        if (Trace.traceOn_) {
            Trace.log(1, "Finalize method for message queue invoked.");
        }
        if (this.handle_ != null) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }

    public int getHelpTextFormatting() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting help text formatting:", this.helpTextFormatting_);
        }
        return this.helpTextFormatting_;
    }

    public int getLength() {
        block5: {
            if (Trace.traceOn_) {
                Trace.log(1, "Getting message queue list length.");
            }
            try {
                if (this.handle_ == null || this.closeHandle_) {
                    this.load();
                }
            }
            catch (Exception e) {
                Trace.log(2, "Exception caught getting length of message queue list:", (Throwable)e);
                if (!(e instanceof ExtendedIllegalStateException)) break block5;
                throw (ExtendedIllegalStateException)e;
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Length:", this.length_);
        }
        return this.length_;
    }

    public boolean getListDirection() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting list direction:", this.listDirection_);
        }
        return this.listDirection_;
    }

    public Enumeration<QueuedMessage> getMessages() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message queue message list.");
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        return new QueuedMessageEnumeration(this, this.length_);
    }

    public QueuedMessage[] getMessages(int listOffset, int number) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message queue message list, list offset: " + listOffset + ", number:", number);
        }
        if (listOffset < -1) {
            throw new ExtendedIllegalArgumentException("listOffset (" + listOffset + ")", 4);
        }
        if (number < 0 && listOffset != -1) {
            throw new ExtendedIllegalArgumentException("number (" + number + ")", 4);
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        if (this.length_ == 0 || number == 0 && listOffset != -1) {
            return new QueuedMessage[0];
        }
        if (listOffset == -1) {
            number = this.length_;
            listOffset = 0;
        } else {
            if (listOffset >= this.length_) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Value of parameter 'listOffset' is beyond end of list:", listOffset + " (list length: " + this.length_ + ")");
                }
                return new QueuedMessage[0];
            }
            if (listOffset + number > this.length_) {
                number = this.length_ - listOffset;
            }
        }
        int lengthOfReceiverVariable = this.dataLength_ / this.length_ * number;
        byte[] data = ListUtilities.retrieveListEntries(this.system_, this.handle_, lengthOfReceiverVariable, number, listOffset, null);
        this.resolveConverter();
        QueuedMessage[] messages = new QueuedMessage[number];
        int offset = 0;
        for (int i = 0; i < messages.length; ++i) {
            int entryOffset = BinaryConverter.byteArrayToInt(data, offset);
            int fieldOffset = BinaryConverter.byteArrayToInt(data, offset + 4);
            int numFields = BinaryConverter.byteArrayToInt(data, offset + 8);
            int messageSeverity = BinaryConverter.byteArrayToInt(data, offset + 12);
            String messageIdentifier = this.conv_.byteArrayToString(data, offset + 16, 7).trim();
            int messageType = (data[offset + 23] & 0xF) * 10 + (data[offset + 24] & 0xF);
            if (messageType == 0) {
                messageType = -1;
            }
            byte[] messageKey = new byte[4];
            System.arraycopy(data, offset + 25, messageKey, 0, 4);
            String messageFileName = this.conv_.byteArrayToString(data, offset + 29, 10).trim();
            String messageFileLibrarySpecified = this.conv_.byteArrayToString(data, offset + 39, 10).trim();
            String messageQueue = this.conv_.byteArrayToString(data, offset + 49, 10).trim();
            String messageQueueLibraryUsed = this.conv_.byteArrayToString(data, offset + 59, 10).trim();
            String dateSent = this.conv_.byteArrayToString(data, offset + 69, 7);
            String timeSent = this.conv_.byteArrayToString(data, offset + 76, 6);
            MessageQueue mq = messageQueueLibraryUsed.length() > 0 && messageQueue.length() > 0 ? new MessageQueue(this.system_, QSYSObjectPathName.toPath(messageQueueLibraryUsed, messageQueue, "MSGQ")) : this;
            messages[i] = new QueuedMessage(mq, messageSeverity, messageIdentifier, messageType, messageKey, messageFileName, messageFileLibrarySpecified, dateSent, timeSent);
            for (int j = 0; j < numFields; ++j) {
                int offsetToNextField = BinaryConverter.byteArrayToInt(data, fieldOffset);
                int fieldID = BinaryConverter.byteArrayToInt(data, fieldOffset + 8);
                byte type = data[fieldOffset + 12];
                int dataLen = BinaryConverter.byteArrayToInt(data, fieldOffset + 28);
                if (type == -61) {
                    messages[i].setValueInternal(fieldID, this.conv_.byteArrayToString(data, fieldOffset + 32, dataLen));
                } else if (type == -62) {
                    if (dataLen > 4) {
                        messages[i].setAsLong(fieldID, BinaryConverter.byteArrayToLong(data, fieldOffset + 32));
                    } else {
                        messages[i].setAsInt(fieldID, BinaryConverter.byteArrayToInt(data, fieldOffset + 32));
                    }
                } else {
                    int numStatements = BinaryConverter.byteArrayToInt(data, fieldOffset + 32);
                    String[] statements = new String[numStatements];
                    for (int k = 0; k < numStatements; ++k) {
                        statements[k] = this.conv_.byteArrayToString(data, fieldOffset + 36 + k * 10, 10);
                    }
                    messages[i].setValueInternal(fieldID, statements);
                }
                fieldOffset = offsetToNextField;
            }
            offset = entryOffset;
        }
        return messages;
    }

    public String getPath() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting path: " + this.path_);
        }
        return this.path_;
    }

    public String getSelection() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting selection: " + this.selection_);
        }
        return this.selection_;
    }

    public int getSeverity() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting severity:", this.severity_);
        }
        return this.severity_;
    }

    public boolean getSort() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting sort:", this.sort_);
        }
        return this.sort_;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public byte[] getUserStartingMessageKey() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting user starting message key:", this.userStartingMessageKey_);
        }
        byte[] msgKey = null;
        if (this.userStartingMessageKey_ != null) {
            msgKey = new byte[this.userStartingMessageKey_.length];
            System.arraycopy(this.userStartingMessageKey_, 0, msgKey, 0, msgKey.length);
        }
        return msgKey;
    }

    public byte[] getWorkstationStartingMessageKey() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting workstation starting message key:", this.workstationStartingMessageKey_);
        }
        byte[] msgKey = null;
        if (this.workstationStartingMessageKey_ != null) {
            msgKey = new byte[this.workstationStartingMessageKey_.length];
            System.arraycopy(this.workstationStartingMessageKey_, 0, msgKey, 0, msgKey.length);
        }
        return msgKey;
    }

    public boolean isSelectMessagesNeedReply() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if messages that need a reply are selected:", this.selectMessagesNeedReply_);
        }
        return this.selectMessagesNeedReply_;
    }

    public boolean isSelectMessagesNoNeedReply() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if messages that do not need a reply are selected:", this.selectMessagesNoNeedReply_);
        }
        return this.selectMessagesNoNeedReply_;
    }

    public boolean isSelectSendersCopyMessagesNeedReply() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if sender's copy messages that need a reply are selected:", this.selectSendersCopyMessagesNeedReply_);
        }
        return this.selectSendersCopyMessagesNeedReply_;
    }

    public synchronized void load() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] userOrQueueInformation;
        boolean selectAll;
        if (Trace.traceOn_) {
            Trace.log(1, "Loading message queue message list.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.closeHandle_) {
            this.close();
        }
        boolean v5r3OrGreater = this.system_.getVRM() >= 328448;
        boolean bl = selectAll = this.selectMessagesNeedReply_ && this.selectMessagesNoNeedReply_ && this.selectSendersCopyMessagesNeedReply_ || !this.selectMessagesNeedReply_ && !this.selectMessagesNoNeedReply_ && !this.selectSendersCopyMessagesNeedReply_;
        int numberOfSelectionCriteria = selectAll ? 1 : (this.selectMessagesNeedReply_ ? 1 : 0) + (this.selectMessagesNoNeedReply_ ? 1 : 0) + (this.selectSendersCopyMessagesNeedReply_ ? 1 : 0);
        int numberOfFieldsToReturn = v5r3OrGreater ? 8 : 7;
        byte[] messageSelectionInformation = new byte[52 + 10 * numberOfSelectionCriteria + 4 * numberOfFieldsToReturn];
        if (this.listDirection_) {
            System.arraycopy(new byte[]{92, -43, -59, -25, -29, 64, 64, 64, 64, 64}, 0, messageSelectionInformation, 0, 10);
        } else {
            System.arraycopy(new byte[]{92, -41, -39, -27, 64, 64, 64, 64, 64, 64}, 0, messageSelectionInformation, 0, 10);
        }
        BinaryConverter.intToByteArray(this.severity_, messageSelectionInformation, 12);
        for (int i = 16; i < 24; ++i) {
            messageSelectionInformation[i] = -1;
        }
        BinaryConverter.intToByteArray(44, messageSelectionInformation, 24);
        BinaryConverter.intToByteArray(numberOfSelectionCriteria, messageSelectionInformation, 28);
        int offset = 44 + numberOfSelectionCriteria * 10;
        BinaryConverter.intToByteArray(offset, messageSelectionInformation, 32);
        BinaryConverter.intToByteArray(offset + 8, messageSelectionInformation, 36);
        BinaryConverter.intToByteArray(numberOfFieldsToReturn, messageSelectionInformation, 40);
        if (selectAll) {
            System.arraycopy(new byte[]{92, -63, -45, -45, 64, 64, 64, 64, 64, 64}, 0, messageSelectionInformation, 44, 10);
        } else {
            int selectionCriteriaOffset = 44;
            if (this.selectMessagesNeedReply_) {
                System.arraycopy(new byte[]{92, -44, -43, -39, 64, 64, 64, 64, 64, 64}, 0, messageSelectionInformation, selectionCriteriaOffset, 10);
                selectionCriteriaOffset += 10;
            }
            if (this.selectMessagesNoNeedReply_) {
                System.arraycopy(new byte[]{92, -44, -43, -43, -39, 64, 64, 64, 64, 64}, 0, messageSelectionInformation, selectionCriteriaOffset, 10);
                selectionCriteriaOffset += 10;
            }
            if (this.selectSendersCopyMessagesNeedReply_) {
                System.arraycopy(new byte[]{92, -30, -61, -43, -39, 64, 64, 64, 64, 64}, 0, messageSelectionInformation, selectionCriteriaOffset, 10);
            }
        }
        byte[] userStartingMessageKey = this.userStartingMessageKey_ != null ? this.userStartingMessageKey_ : (this.listDirection_ ? OLDEST : NEWEST);
        System.arraycopy(userStartingMessageKey, 0, messageSelectionInformation, offset, 4);
        byte[] workstationStartingMessageKey = this.workstationStartingMessageKey_ != null ? this.workstationStartingMessageKey_ : userStartingMessageKey;
        System.arraycopy(workstationStartingMessageKey, 0, messageSelectionInformation, offset + 4, 4);
        BinaryConverter.intToByteArray(302, messageSelectionInformation, offset + 8);
        BinaryConverter.intToByteArray(601, messageSelectionInformation, offset + 12);
        BinaryConverter.intToByteArray(603, messageSelectionInformation, offset + 16);
        BinaryConverter.intToByteArray(1001, messageSelectionInformation, offset + 20);
        BinaryConverter.intToByteArray(501, messageSelectionInformation, offset + 24);
        BinaryConverter.intToByteArray(404, messageSelectionInformation, offset + 28);
        BinaryConverter.intToByteArray(101, messageSelectionInformation, offset + 32);
        if (v5r3OrGreater) {
            BinaryConverter.intToByteArray(607, messageSelectionInformation, offset + 36);
        }
        if (this.path_.equals(CURRENT)) {
            userOrQueueInformation = new byte[]{-16, 92, -61, -28, -39, -39, -59, -43, -29, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        } else {
            userOrQueueInformation = new byte[]{-15, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
            this.resolveConverter();
            this.conv_.stringToByteArray(this.name_, userOrQueueInformation, 1);
            this.conv_.stringToByteArray(this.library_, userOrQueueInformation, 11);
        }
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(0), new ProgramParameter(new byte[]{0, 0, 0, 0}), new ProgramParameter(80), new ProgramParameter(new byte[]{-1, -1, -1, -1}), new ProgramParameter(new byte[]{this.sort_ && selectAll ? (byte)-15 : -16}), new ProgramParameter(messageSelectionInformation), new ProgramParameter(BinaryConverter.intToByteArray(messageSelectionInformation.length)), new ProgramParameter(userOrQueueInformation), new ProgramParameter(44), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QGY.LIB/QGYOLMSG.PGM", parameters);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] listInformation = parameters[2].getOutputData();
        this.handle_ = new byte[4];
        System.arraycopy(listInformation, 8, this.handle_, 0, 4);
        listInformation = ListUtilities.waitForListToComplete(this.system_, this.handle_, listInformation);
        this.length_ = BinaryConverter.byteArrayToInt(listInformation, 0);
        this.dataLength_ = BinaryConverter.byteArrayToInt(listInformation, 32);
        if (Trace.traceOn_) {
            Trace.log(1, "Loaded message queue message list, length: " + this.length_ + ", data length: " + this.dataLength_ + ", handle: ", this.handle_);
        }
    }

    public QueuedMessage receive(byte[] messageKey) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving from message queue, message key:", messageKey);
        }
        return this.receive(messageKey, 0, REMOVE, ANY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueuedMessage receive(byte[] messageKey, int waitTime, String messageAction, String messageType) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] messageTypeBytes;
        byte[] messageActionBytes;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving from message queue, waitTime: " + waitTime + ", messageAction: " + messageAction + ", messageType: " + messageType + ", message key:", messageKey);
        }
        if (messageAction == null) {
            Trace.log(2, "Parameter 'messageAction' is null.");
            throw new NullPointerException("messageAction");
        }
        if (messageType == null) {
            Trace.log(2, "Parameter 'messageType' is null.");
            throw new NullPointerException("messageType");
        }
        if (messageAction.equals(OLD)) {
            messageActionBytes = new byte[]{92, -42, -45, -60, 64, 64, 64, 64, 64, 64};
        } else if (messageAction.equals(REMOVE)) {
            messageActionBytes = new byte[]{92, -39, -59, -44, -42, -27, -59, 64, 64, 64};
        } else if (messageAction.equals(SAME)) {
            messageActionBytes = new byte[]{92, -30, -63, -44, -59, 64, 64, 64, 64, 64};
        } else {
            Trace.log(2, "Value of parameter 'messageAction' is not valid: " + messageAction);
            throw new ExtendedIllegalArgumentException("messageAction (" + messageAction + ")", 2);
        }
        if (messageType.equals(ANY)) {
            messageTypeBytes = new byte[]{92, -63, -43, -24, 64, 64, 64, 64, 64, 64};
        } else if (messageType.equals(COMPLETION)) {
            messageTypeBytes = new byte[]{92, -61, -42, -44, -41, 64, 64, 64, 64, 64};
        } else if (messageType.equals(COPY)) {
            messageTypeBytes = new byte[]{92, -61, -42, -41, -24, 64, 64, 64, 64, 64};
        } else if (messageType.equals(DIAGNOSTIC)) {
            messageTypeBytes = new byte[]{92, -60, -55, -63, -57, 64, 64, 64, 64, 64};
        } else if (messageType.equals(FIRST)) {
            messageTypeBytes = new byte[]{92, -58, -55, -39, -30, -29, 64, 64, 64, 64};
        } else if (messageType.equals(INFORMATIONAL)) {
            messageTypeBytes = new byte[]{92, -55, -43, -58, -42, 64, 64, 64, 64, 64};
        } else if (messageType.equals(INQUIRY)) {
            messageTypeBytes = new byte[]{92, -55, -43, -40, 64, 64, 64, 64, 64, 64};
        } else if (messageType.equals(LAST)) {
            messageTypeBytes = new byte[]{92, -45, -63, -30, -29, 64, 64, 64, 64, 64};
        } else if (messageType.equals(NEXT)) {
            messageTypeBytes = new byte[]{92, -43, -59, -25, -29, 64, 64, 64, 64, 64};
        } else if (messageType.equals(PREVIOUS)) {
            messageTypeBytes = new byte[]{92, -41, -39, -27, 64, 64, 64, 64, 64, 64};
        } else if (messageType.equals(REPLY)) {
            messageTypeBytes = new byte[]{92, -39, -41, -24, 64, 64, 64, 64, 64, 64};
        } else {
            Trace.log(2, "Value of parameter 'messageType' is not valid: " + messageType);
            throw new ExtendedIllegalArgumentException("messageType (" + messageType + ")", 2);
        }
        if (messageKey == null && (messageType.equals(COPY) || messageType.equals(NEXT) || messageType.equals(PREVIOUS))) {
            Trace.log(2, "Value of parameter 'messageType' is not valid when messageKey is not specified: " + messageType);
            throw new ExtendedIllegalArgumentException("messageType (" + messageType + ")", 2);
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (messageKey == null) {
            messageKey = BLANK_KEY;
        }
        this.resolveQualifiedMessageQueueName();
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(5120), new ProgramParameter(new byte[]{0, 0, 20, 0}), new ProgramParameter(new byte[]{-39, -61, -27, -44, -16, -14, -16, -16}), new ProgramParameter(this.qualifiedMessageQueueName_), new ProgramParameter(messageTypeBytes), new ProgramParameter(messageKey), new ProgramParameter(BinaryConverter.intToByteArray(waitTime)), new ProgramParameter(messageActionBytes), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QMHRCVM.PGM", parameters);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] data = parameters[0].getOutputData();
        int bytesReturned = BinaryConverter.byteArrayToInt(data, 0);
        int bytesAvailable = BinaryConverter.byteArrayToInt(data, 4);
        if (bytesReturned == 8 && bytesAvailable == 0) {
            return null;
        }
        if (Trace.traceOn_ && bytesReturned < bytesAvailable) {
            Trace.log(4, "Possible truncation receiving from message queue, bytes returned: " + bytesReturned + ", bytesAvailable:", bytesAvailable);
        }
        this.resolveConverter();
        int messageSeverity = BinaryConverter.byteArrayToInt(data, 8);
        String messageIdentifier = this.conv_.byteArrayToString(data, 12, 7).trim();
        int messageTypeReturned = (data[19] & 0xF) * 10 + (data[20] & 0xF);
        byte[] messageKeyReturned = new byte[4];
        System.arraycopy(data, 21, messageKeyReturned, 0, 4);
        String messageFileName = this.conv_.byteArrayToString(data, 25, 10).trim();
        String messageFileLibraryUsed = this.conv_.byteArrayToString(data, 45, 10).trim();
        String sendingJob = this.conv_.byteArrayToString(data, 55, 10).trim();
        String sendingJobsUserProfile = this.conv_.byteArrayToString(data, 65, 10).trim();
        String sendingJobNumber = this.conv_.byteArrayToString(data, 75, 6);
        String sendingProgramName = this.conv_.byteArrayToString(data, 81, 12).trim();
        String dateSent = this.conv_.byteArrayToString(data, 97, 7);
        String timeSent = this.conv_.byteArrayToString(data, 104, 6);
        String alertOption = this.conv_.byteArrayToString(data, 135, 9).trim();
        int lengthDataReturned = BinaryConverter.byteArrayToInt(data, 152);
        int lengthMessageReturned = BinaryConverter.byteArrayToInt(data, 160);
        int lengthHelpReturned = BinaryConverter.byteArrayToInt(data, 168);
        byte[] replacementDataBytes = new byte[lengthDataReturned];
        System.arraycopy(data, 176, replacementDataBytes, 0, lengthDataReturned);
        String messageData = lengthMessageReturned != 0 ? this.conv_.byteArrayToString(data, 176 + lengthDataReturned, lengthMessageReturned) : this.conv_.byteArrayToString(replacementDataBytes, 0, lengthDataReturned, 0);
        String messageHelp = lengthHelpReturned != 0 ? this.conv_.byteArrayToString(data, 176 + lengthDataReturned + lengthMessageReturned, lengthHelpReturned) : null;
        QueuedMessage message = new QueuedMessage(this, messageSeverity, messageIdentifier, messageTypeReturned, messageKeyReturned, messageFileName, messageFileLibraryUsed, sendingJob, sendingJobsUserProfile, sendingJobNumber, sendingProgramName, dateSent, timeSent, replacementDataBytes, messageData, messageHelp, alertOption);
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        return message;
    }

    public void remove() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.removeMessages(new byte[]{92, -63, -45, -45, 64, 64, 64, 64, 64, 64}, BLANK_KEY);
    }

    public void remove(byte[] messageKey) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (messageKey == null) {
            Trace.log(2, "Parameter 'messageKey' is null.");
            throw new NullPointerException("messageKey");
        }
        this.removeMessages(new byte[]{92, -62, -24, -46, -59, -24, 64, 64, 64, 64}, messageKey);
    }

    public void remove(String messageType) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] messageTypeBytes;
        if (messageType == null) {
            Trace.log(2, "Parameter 'messageType' is null.");
            throw new NullPointerException("messageType");
        }
        if (messageType.equals(ALL)) {
            messageTypeBytes = new byte[]{92, -63, -45, -45, 64, 64, 64, 64, 64, 64};
        } else if (messageType.equals(KEEP_UNANSWERED)) {
            messageTypeBytes = new byte[]{92, -46, -59, -59, -41, -28, -43, -63, -43, -30};
        } else if (messageType.equals(NEW)) {
            messageTypeBytes = new byte[]{92, -43, -59, -26, 64, 64, 64, 64, 64, 64};
        } else if (messageType.equals(OLD)) {
            messageTypeBytes = new byte[]{92, -42, -45, -60, 64, 64, 64, 64, 64, 64};
        } else {
            Trace.log(2, "Value of parameter 'messageType' is not valid: " + messageType);
            throw new ExtendedIllegalArgumentException("messageType (" + messageType + ")", 2);
        }
        this.removeMessages(messageTypeBytes, BLANK_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMessages(byte[] messageType, byte[] messageKey) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.resolveQualifiedMessageQueueName();
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(this.qualifiedMessageQueueName_), new ProgramParameter(messageKey), new ProgramParameter(messageType), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QMHRMVM.PGM", parameters);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    private synchronized void resolveConverter() throws IOException {
        if (this.conv_ == null) {
            this.conv_ = new Converter(this.system_.getCcsid(), this.system_);
        }
    }

    private synchronized void resolveQualifiedMessageQueueName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.qualifiedMessageQueueName_ != null) {
            return;
        }
        this.resolveConverter();
        this.qualifiedMessageQueueName_ = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        if (this.path_.equals(CURRENT)) {
            User user = new User(this.system_, this.system_.getUserId());
            user.loadUserInformation();
            QSYSObjectPathName ifs = new QSYSObjectPathName(user.getMessageQueue());
            this.conv_.stringToByteArray(ifs.getObjectName(), this.qualifiedMessageQueueName_, 0);
            this.conv_.stringToByteArray(ifs.getLibraryName(), this.qualifiedMessageQueueName_, 10);
        } else {
            this.conv_.stringToByteArray(this.name_, this.qualifiedMessageQueueName_, 0);
            this.conv_.stringToByteArray(this.library_, this.qualifiedMessageQueueName_, 10);
        }
    }

    public void reply(byte[] messageKey, String replyText) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.reply(messageKey, replyText, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reply(byte[] messageKey, String replyText, boolean remove) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] byArray;
        if (messageKey == null) {
            Trace.log(2, "Parameter 'messageKey' is null.");
            throw new NullPointerException("messageKey");
        }
        if (replyText == null) {
            Trace.log(2, "Parameter 'replyText' is null.");
            throw new NullPointerException("replyText");
        }
        this.resolveConverter();
        byte[] replyBytes = this.conv_.stringToByteArray(replyText);
        if (remove) {
            byte[] byArray2 = new byte[10];
            byArray2[0] = 92;
            byArray2[1] = -24;
            byArray2[2] = -59;
            byArray2[3] = -30;
            byArray2[4] = 64;
            byArray2[5] = 64;
            byArray2[6] = 64;
            byArray2[7] = 64;
            byArray2[8] = 64;
            byArray = byArray2;
            byArray2[9] = 64;
        } else {
            byte[] byArray3 = new byte[10];
            byArray3[0] = 92;
            byArray3[1] = -43;
            byArray3[2] = -42;
            byArray3[3] = 64;
            byArray3[4] = 64;
            byArray3[5] = 64;
            byArray3[6] = 64;
            byArray3[7] = 64;
            byArray3[8] = 64;
            byArray = byArray3;
            byArray3[9] = 64;
        }
        byte[] removeBytes = byArray;
        this.resolveQualifiedMessageQueueName();
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(messageKey), new ProgramParameter(this.qualifiedMessageQueueName_), new ProgramParameter(replyBytes), new ProgramParameter(BinaryConverter.intToByteArray(replyBytes.length)), new ProgramParameter(removeBytes), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QMHSNDRM.PGM", parameters);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] send(String messageID, String messageFile, byte[] data, byte[] messageType, String replyQueue) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramParameter[] parameters;
        ProgramCall pc;
        this.resolveConverter();
        byte[] idBytes = new byte[]{64, 64, 64, 64, 64, 64, 64};
        if (messageID != null) {
            this.conv_.stringToByteArray(messageID, idBytes, 0, 7);
        }
        byte[] messageFileName = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        if (messageFile != null) {
            QSYSObjectPathName ifs = new QSYSObjectPathName(messageFile, "MSGF");
            this.conv_.stringToByteArray(ifs.getObjectName(), messageFileName, 0);
            this.conv_.stringToByteArray(ifs.getLibraryName(), messageFileName, 10);
        }
        if (data == null) {
            data = new byte[]{};
        }
        byte[] messageQueueName = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        if (this.path_.equals(CURRENT)) {
            this.conv_.stringToByteArray(this.system_.getUserId(), messageQueueName, 0);
            System.arraycopy(new byte[]{92, -28, -30, -59, -39}, 0, messageQueueName, 10, 5);
        } else {
            QSYSObjectPathName ifs = new QSYSObjectPathName(this.path_);
            this.conv_.stringToByteArray(ifs.getObjectName(), messageQueueName, 0);
            this.conv_.stringToByteArray(ifs.getLibraryName(), messageQueueName, 10);
        }
        byte[] replyMessageQueueName = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        if (replyQueue != null) {
            QSYSObjectPathName ifs = new QSYSObjectPathName(replyQueue, "MSGQ");
            this.conv_.stringToByteArray(ifs.getObjectName(), replyMessageQueueName, 0);
            this.conv_.stringToByteArray(ifs.getLibraryName(), replyMessageQueueName, 10);
        }
        if (!(pc = new ProgramCall(this.system_, "/QSYS.LIB/QMHSNDM.PGM", parameters = new ProgramParameter[]{new ProgramParameter(idBytes), new ProgramParameter(messageFileName), new ProgramParameter(data), new ProgramParameter(BinaryConverter.intToByteArray(data.length)), new ProgramParameter(messageType), new ProgramParameter(messageQueueName), new ProgramParameter(new byte[]{0, 0, 0, 1}), new ProgramParameter(replyMessageQueueName), new ProgramParameter(4), new ErrorCodeParameter()})).run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        return parameters[8].getOutputData();
    }

    public void sendInformational(String messageID, String messageFile) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (messageID == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        if (messageFile == null) {
            Trace.log(2, "Parameter 'messageFile' is null.");
            throw new NullPointerException("messageFile");
        }
        this.send(messageID, messageFile, null, new byte[]{92, -55, -43, -58, -42, 64, 64, 64, 64, 64}, null);
    }

    public void sendInformational(String messageID, String messageFile, byte[] substitutionData) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (messageID == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        if (messageFile == null) {
            Trace.log(2, "Parameter 'messageFile' is null.");
            throw new NullPointerException("messageFile");
        }
        this.send(messageID, messageFile, substitutionData, new byte[]{92, -55, -43, -58, -42, 64, 64, 64, 64, 64}, null);
    }

    public void sendInformational(String messageText) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (messageText == null) {
            Trace.log(2, "Parameter 'messageText' is null.");
            throw new NullPointerException("messageText");
        }
        this.resolveConverter();
        this.send(null, null, this.conv_.stringToByteArray(messageText), new byte[]{92, -55, -43, -58, -42, 64, 64, 64, 64, 64}, null);
    }

    public byte[] sendInquiry(String messageID, String messageFile, String replyMessageQueue) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (messageID == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        if (messageFile == null) {
            Trace.log(2, "Parameter 'messageFile' is null.");
            throw new NullPointerException("messageFile");
        }
        if (replyMessageQueue == null) {
            Trace.log(2, "Parameter 'replyMessageQueue' is null.");
            throw new NullPointerException("replyMessageQueue");
        }
        return this.send(messageID, messageFile, null, new byte[]{92, -55, -43, -40, 64, 64, 64, 64, 64, 64}, replyMessageQueue);
    }

    public byte[] sendInquiry(String messageID, String messageFile, byte[] substitutionData, String replyMessageQueue) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (messageID == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        if (messageFile == null) {
            Trace.log(2, "Parameter 'messageFile' is null.");
            throw new NullPointerException("messageFile");
        }
        if (replyMessageQueue == null) {
            Trace.log(2, "Parameter 'replyMessageQueue' is null.");
            throw new NullPointerException("replyMessageQueue");
        }
        return this.send(messageID, messageFile, substitutionData, new byte[]{92, -55, -43, -40, 64, 64, 64, 64, 64, 64}, replyMessageQueue);
    }

    public byte[] sendInquiry(String messageText, String replyMessageQueue) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (messageText == null) {
            Trace.log(2, "Parameter 'messageText' is null.");
            throw new NullPointerException("messageText");
        }
        if (replyMessageQueue == null) {
            Trace.log(2, "Parameter 'replyMessageQueue' is null.");
            throw new NullPointerException("replyMessageQueue");
        }
        this.resolveConverter();
        return this.send(null, null, this.conv_.stringToByteArray(messageText), new byte[]{92, -55, -43, -40, 64, 64, 64, 64, 64, 64}, replyMessageQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHelpTextFormatting(int helpTextFormatting) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting help text formatting:", helpTextFormatting);
        }
        if (helpTextFormatting < 0 || helpTextFormatting > 2) {
            Trace.log(2, "Value of parameter 'helpTextFormatting' is not valid: " + helpTextFormatting);
            throw new ExtendedIllegalArgumentException("helpTextFormatting (" + helpTextFormatting + ")", 2);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.helpTextFormatting_ = helpTextFormatting;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListDirection(boolean listDirection) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting list direction:", listDirection);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.listDirection_ = listDirection;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSort(boolean sort) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting sort:", sort);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.sort_ = sort;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(String path) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting path: " + path);
        }
        if (path == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        if (this.handle_ != null) {
            Trace.log(2, "Cannot set property 'path' after connect.");
            throw new ExtendedIllegalStateException("path", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                if (!path.equals(CURRENT)) {
                    QSYSObjectPathName ifs = new QSYSObjectPathName(path, "MSGQ");
                    this.library_ = ifs.getLibraryName();
                    this.name_ = ifs.getObjectName();
                }
                this.path_ = path;
                this.qualifiedMessageQueueName_ = null;
            }
        }
        String oldValue = this.path_;
        String newValue = path;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("path", oldValue, newValue);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (!path.equals(CURRENT)) {
                QSYSObjectPathName ifs = new QSYSObjectPathName(path, "MSGQ");
                this.library_ = ifs.getLibraryName();
                this.name_ = ifs.getObjectName();
            }
            this.path_ = path;
            this.qualifiedMessageQueueName_ = null;
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("path", oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectMessagesNeedReply(boolean selectMessagesNeedReply) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting messages that need a reply are selected:", selectMessagesNeedReply);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.selectMessagesNeedReply_ = selectMessagesNeedReply;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectMessagesNoNeedReply(boolean selectMessagesNoNeedReply) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting messages that do not need a reply are selected:", selectMessagesNoNeedReply);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.selectMessagesNoNeedReply_ = selectMessagesNoNeedReply;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectSendersCopyMessagesNeedReply(boolean selectSendersCopyMessagesNeedReply) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting sender's copy messages that need a reply are selected:", selectSendersCopyMessagesNeedReply);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.selectSendersCopyMessagesNeedReply_ = selectSendersCopyMessagesNeedReply;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(String selection) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting selection: " + selection);
        }
        if (selection == null) {
            Trace.log(2, "Parameter 'selection' is null.");
            throw new NullPointerException("selection");
        }
        if (!(selection.equals(ALL) || selection.equals(MESSAGES_NEED_REPLY) || selection.equals(MESSAGES_NO_NEED_REPLY) || selection.equals(SENDERS_COPY_NEED_REPLY))) {
            Trace.log(2, "Value of parameter 'selection' is not valid: " + selection);
            throw new ExtendedIllegalArgumentException("selection (" + selection + ")", 2);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                this.selection_ = selection;
                boolean all = selection.equals(ALL);
                this.selectMessagesNeedReply_ = all || selection.equals(MESSAGES_NEED_REPLY);
                this.selectMessagesNoNeedReply_ = all || selection.equals(MESSAGES_NO_NEED_REPLY);
                boolean bl = this.selectSendersCopyMessagesNeedReply_ = all || selection.equals(SENDERS_COPY_NEED_REPLY);
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String oldValue = this.selection_;
        String newValue = selection;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("selection", oldValue, newValue);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.selection_ = selection;
            boolean all = selection.equals(ALL);
            this.selectMessagesNeedReply_ = all || selection.equals(MESSAGES_NEED_REPLY);
            this.selectMessagesNoNeedReply_ = all || selection.equals(MESSAGES_NO_NEED_REPLY);
            boolean bl = this.selectSendersCopyMessagesNeedReply_ = all || selection.equals(SENDERS_COPY_NEED_REPLY);
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("selection", oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeverity(int severity) throws PropertyVetoException {
        if (severity < 0 || severity > 99) {
            Trace.log(2, "Value of parameter 'severity' is not valid: " + severity);
            throw new ExtendedIllegalArgumentException("severity (" + severity + ")", 2);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.severity_ = severity;
        } else {
            Integer oldValue = this.severity_;
            Integer newValue = severity;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("severity", oldValue, newValue);
            }
            this.severity_ = severity;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("severity", oldValue, newValue);
            }
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystem(AS400 system) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + system);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.handle_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                this.system_ = system;
                this.conv_ = null;
                this.qualifiedMessageQueueName_ = null;
            }
        }
        AS400 oldValue = this.system_;
        AS400 newValue = system;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("system", oldValue, newValue);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.system_ = system;
            this.conv_ = null;
            this.qualifiedMessageQueueName_ = null;
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("system", oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserStartingMessageKey(byte[] userStartingMessageKey) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting user starting message key:", userStartingMessageKey);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.userStartingMessageKey_ = userStartingMessageKey;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkstationStartingMessageKey(byte[] workstationStartingMessageKey) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting workstation starting message key:", workstationStartingMessageKey);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.workstationStartingMessageKey_ = workstationStartingMessageKey;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }
}

