/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.FormInput;
import com.ibm.as400.util.html.HTMLConstants;
import java.beans.PropertyVetoException;

public class ImageFormInput
extends FormInput
implements HTMLConstants {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 3208810620206338498L;
    private int height_ = 0;
    private int width_ = 0;
    private String align_ = "top";
    private String source_;

    public ImageFormInput() {
    }

    public ImageFormInput(String name) {
        super(name);
    }

    public ImageFormInput(String name, String source) {
        super(name);
        try {
            this.setSource(source);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public String getAlignment() {
        return this.align_;
    }

    private String getAttributeTag() {
        StringBuffer s = new StringBuffer("");
        if (this.source_ != null && this.source_.length() > 0) {
            s.append(" src=\"" + this.source_ + "\"");
        }
        s.append(" align=\"");
        s.append(this.align_);
        s.append("\"");
        if (this.height_ > 0) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using height attribute tag.");
            }
            s.append(" height=\"" + this.height_ + "\"");
        }
        if (this.width_ > 0) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using width attribute tag.");
            }
            s.append(" width=\"" + this.width_ + "\"");
        }
        return s.toString();
    }

    public int getHeight() {
        return this.height_;
    }

    public String getSource() {
        return this.source_;
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An ImageFormInput was here -->";
    }

    @Override
    public String getTag() {
        if (this.getName() == null) {
            Trace.log(2, "Attempting to get tag before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.getSource() == null) {
            Trace.log(2, "Attempting to get tag before setting source.");
            throw new ExtendedIllegalStateException("source", 4);
        }
        StringBuffer s = new StringBuffer("<input type=\"image\"");
        s.append(this.getNameAttributeTag());
        s.append(this.getValueAttributeTag(true));
        s.append(this.getAttributeTag());
        s.append(this.getLanguageAttributeTag());
        s.append(this.getDirectionAttributeTag());
        s.append(this.getAttributeString());
        s.append(" />");
        return s.toString();
    }

    public int getWidth() {
        return this.width_;
    }

    public void setAlignment(String align) throws PropertyVetoException {
        if (align == null) {
            throw new NullPointerException("align");
        }
        if (!(align.equals("baseline") || align.equals("bottom") || align.equals("absbottom") || align.equals("left") || align.equals("right") || align.equals("middle") || align.equals("absmiddle") || align.equals("top") || align.equals("texttop"))) {
            throw new ExtendedIllegalArgumentException("align", 2);
        }
        String old = this.align_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("align", old, align);
        }
        this.align_ = align;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("align", old, align);
        }
    }

    public void setHeight(int height) throws PropertyVetoException {
        if (height < 0) {
            throw new ExtendedIllegalArgumentException("height", 4);
        }
        int old = this.height_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("height", (Object)old, (Object)height);
        }
        this.height_ = height;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("height", (Object)old, (Object)height);
        }
    }

    public void setSource(String source) throws PropertyVetoException {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (source.length() == 0) {
            throw new ExtendedIllegalArgumentException("source", 2);
        }
        String old = this.source_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("source", old, source);
        }
        this.source_ = source;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("source", old, source);
        }
    }

    public void setWidth(int width) throws PropertyVetoException {
        if (width < 0) {
            throw new ExtendedIllegalArgumentException("width", 4);
        }
        int old = this.width_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("width", (Object)old, (Object)width);
        }
        this.width_ = width;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("width", (Object)old, (Object)width);
        }
    }
}

