/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin.httpserver;

import com.amazon.redshift.plugin.httpserver.InvalidHttpRequestHandler;
import com.amazon.redshift.plugin.httpserver.ValidHttpRequestHandler;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.RequestLine;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

public class RequestHandler
implements HttpRequestHandler {
    public static final String REDSHIFT_PATH = "/redshift/";
    private static final String SUPPORTED_METHOD = "POST";
    private final Function<List<NameValuePair>, Object> m_requestProcessLogic;
    private final HttpRequestHandler m_invalidRequestHandler;
    private final HttpRequestHandler m_validRequestHandler;
    private Object m_result;

    public RequestHandler(Function<List<NameValuePair>, Object> requestProcessLogic) {
        this.m_requestProcessLogic = requestProcessLogic;
        this.m_invalidRequestHandler = new InvalidHttpRequestHandler();
        this.m_validRequestHandler = new ValidHttpRequestHandler();
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (this.isRequestValid(request)) {
            this.m_result = this.m_requestProcessLogic.apply(URLEncodedUtils.parse((HttpEntity)((BasicHttpEntityEnclosingRequest)request).getEntity()));
            this.m_validRequestHandler.handle(request, response, context);
        } else {
            this.m_invalidRequestHandler.handle(request, response, context);
        }
    }

    private boolean isRequestValid(HttpRequest request) {
        RequestLine requestLine = request.getRequestLine();
        if (!SUPPORTED_METHOD.equalsIgnoreCase(requestLine.getMethod())) {
            return false;
        }
        return requestLine.getUri().startsWith(REDSHIFT_PATH);
    }

    public Object getResult() {
        return this.m_result;
    }

    public boolean hasResult() {
        return this.m_result != null;
    }
}

