/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.aws.sns;

import com.amazonaws.AmazonClientException;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.aws.sns.SnsNotifyMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SnsNotifyDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static Class<?> PKG = SnsNotifyMeta.class;
    private SnsNotifyMeta meta;
    private CTabFolder tabFolder;
    private CTabItem tbtmSettings;
    private ScrolledComposite scrlSettingsComp;
    private Composite settingsComp;
    private Label lblAWSKey;
    private TextVar tAWSKey;
    private Label lblAWSKeySecret;
    private PasswordTextVar tAWSKeySecret;
    private Label lblAWSRegion;
    private ComboVar tAWSRegion;
    private CTabItem tbtmNotifications;
    private ScrolledComposite scrlNotificationsComp;
    private Composite notificationsComp;
    private Label lblnotifyPoint;
    private Combo tnotifyPoint;
    private Label lblMessageID;
    private TextVar tMessageID;
    private ColumnInfo fieldColumn;
    private TableView tTableNotifyProps;
    private Label lblDevInfo;
    private Label lblAWSCredChain;
    private ComboVar tAWSCredChain;

    public SnsNotifyDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String transformName) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, transformName);
        this.meta = (SnsNotifyMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.meta);
        this.changed = this.meta.hasChanged();
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SnsNotifyDialog.this.meta.setChanged();
            }
        };
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SNSNotify.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.tabFolder = new CTabFolder((Composite)this.shell, 2048);
        FormData fd_tabFolder = new FormData();
        fd_tabFolder.right = new FormAttachment(100, 0);
        fd_tabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fd_tabFolder.left = new FormAttachment(0, 0);
        fd_tabFolder.bottom = new FormAttachment(100, -50);
        this.tabFolder.setLayoutData((Object)fd_tabFolder);
        PropsUi.setLook((Widget)this.tabFolder);
        this.tbtmSettings = new CTabItem(this.tabFolder, 0);
        this.tbtmSettings.setText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.Title", (String[])new String[0]));
        this.scrlSettingsComp = new ScrolledComposite((Composite)this.tabFolder, 768);
        this.scrlSettingsComp.setLayout((Layout)new FillLayout());
        PropsUi.setLook((Widget)this.scrlSettingsComp);
        this.settingsComp = new Composite((Composite)this.scrlSettingsComp, 0);
        PropsUi.setLook((Widget)this.settingsComp);
        FormLayout settingsLayout = new FormLayout();
        settingsLayout.marginWidth = 3;
        settingsLayout.marginHeight = 3;
        this.settingsComp.setLayout((Layout)settingsLayout);
        this.lblAWSCredChain = new Label(this.settingsComp, 131072);
        PropsUi.setLook((Widget)this.lblAWSCredChain);
        FormData fd_lblAWSCredChain = new FormData();
        fd_lblAWSCredChain.left = new FormAttachment(0, 0);
        fd_lblAWSCredChain.top = new FormAttachment(0, margin);
        fd_lblAWSCredChain.right = new FormAttachment(middle, -margin);
        this.lblAWSCredChain.setLayoutData((Object)fd_lblAWSCredChain);
        this.lblAWSCredChain.setText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.AWSCredChain.Label", (String[])new String[0]));
        this.tAWSCredChain = new ComboVar(this.variables, this.settingsComp, 18436);
        PropsUi.setLook((Widget)this.tAWSCredChain);
        FormData fd_tAWSCredChain = new FormData();
        fd_tAWSCredChain.top = new FormAttachment(0, margin);
        fd_tAWSCredChain.left = new FormAttachment(middle, 0);
        fd_tAWSCredChain.right = new FormAttachment(100, 0);
        this.tAWSCredChain.setLayoutData((Object)fd_tAWSCredChain);
        this.tAWSCredChain.setToolTipText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.AWSCredChain.Tooltip", (String[])new String[0]));
        this.tAWSCredChain.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                SnsNotifyDialog.this.changeCredentialChainSelection();
            }
        });
        this.lblAWSKey = new Label(this.settingsComp, 131072);
        PropsUi.setLook((Widget)this.lblAWSKey);
        FormData fd_lblAWSKey = new FormData();
        fd_lblAWSKey.left = new FormAttachment(0, 0);
        fd_lblAWSKey.top = new FormAttachment((Control)this.tAWSCredChain, margin);
        fd_lblAWSKey.right = new FormAttachment(middle, -margin);
        this.lblAWSKey.setLayoutData((Object)fd_lblAWSKey);
        this.lblAWSKey.setText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.AWSKey.Label", (String[])new String[0]));
        this.tAWSKey = new TextVar(this.variables, this.settingsComp, 18436);
        PropsUi.setLook((Widget)this.tAWSKey);
        FormData fd_tAWSKey = new FormData();
        fd_tAWSKey.top = new FormAttachment((Control)this.tAWSCredChain, margin);
        fd_tAWSKey.left = new FormAttachment(middle, 0);
        fd_tAWSKey.right = new FormAttachment(100, 0);
        this.tAWSKey.setLayoutData((Object)fd_tAWSKey);
        this.tAWSKey.setToolTipText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.AWSKey.Tooltip", (String[])new String[0]));
        this.lblAWSKeySecret = new Label(this.settingsComp, 131072);
        PropsUi.setLook((Widget)this.lblAWSKeySecret);
        FormData fd_lblAWSKeySecret = new FormData();
        fd_lblAWSKeySecret.left = new FormAttachment(0, 0);
        fd_lblAWSKeySecret.top = new FormAttachment((Control)this.tAWSKey, margin);
        fd_lblAWSKeySecret.right = new FormAttachment(middle, -margin);
        this.lblAWSKeySecret.setLayoutData((Object)fd_lblAWSKeySecret);
        this.lblAWSKeySecret.setText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.AWSKeySecret.Label", (String[])new String[0]));
        this.tAWSKeySecret = new PasswordTextVar(this.variables, this.settingsComp, 18436);
        PropsUi.setLook((Widget)this.tAWSKeySecret);
        FormData fd_tAWSKeySecret = new FormData();
        fd_tAWSKeySecret.top = new FormAttachment((Control)this.tAWSKey, margin);
        fd_tAWSKeySecret.left = new FormAttachment(middle, 0);
        fd_tAWSKeySecret.right = new FormAttachment(100, 0);
        this.tAWSKeySecret.setLayoutData((Object)fd_tAWSKeySecret);
        this.tAWSKeySecret.setToolTipText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.AWSKeySecret.Tooltip", (String[])new String[0]));
        this.lblAWSRegion = new Label(this.settingsComp, 131072);
        PropsUi.setLook((Widget)this.lblAWSRegion);
        FormData fd_lblAWSRegion = new FormData();
        fd_lblAWSRegion.left = new FormAttachment(0, 0);
        fd_lblAWSRegion.top = new FormAttachment((Control)this.tAWSKeySecret, margin);
        fd_lblAWSRegion.right = new FormAttachment(middle, -margin);
        this.lblAWSRegion.setLayoutData((Object)fd_lblAWSRegion);
        this.lblAWSRegion.setText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.AWSRegion.Label", (String[])new String[0]));
        this.tAWSRegion = new ComboVar(this.variables, this.settingsComp, 18436);
        PropsUi.setLook((Widget)this.tAWSRegion);
        FormData fd_tAWSRegion = new FormData();
        fd_tAWSRegion.top = new FormAttachment((Control)this.tAWSKeySecret, margin);
        fd_tAWSRegion.left = new FormAttachment(middle, 0);
        fd_tAWSRegion.right = new FormAttachment(100, 0);
        this.tAWSRegion.setLayoutData((Object)fd_tAWSRegion);
        this.tAWSRegion.setToolTipText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Settings.AWSRegion.Tooltip", (String[])new String[0]));
        this.populateAWSRegion(this.tAWSRegion);
        Control[] queueTabList = new Control[]{this.tAWSKey, this.tAWSKeySecret, this.tAWSRegion};
        this.settingsComp.setTabList(queueTabList);
        this.settingsComp.pack();
        Rectangle settingsBounds = this.settingsComp.getBounds();
        this.scrlSettingsComp.setContent((Control)this.settingsComp);
        this.scrlSettingsComp.setExpandHorizontal(true);
        this.scrlSettingsComp.setExpandVertical(true);
        this.scrlSettingsComp.setMinWidth(settingsBounds.width);
        this.scrlSettingsComp.setMinHeight(settingsBounds.height);
        this.tbtmNotifications = new CTabItem(this.tabFolder, 0);
        this.tbtmNotifications.setText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.Title", (String[])new String[0]));
        this.scrlNotificationsComp = new ScrolledComposite((Composite)this.tabFolder, 768);
        this.scrlNotificationsComp.setLayout((Layout)new FillLayout());
        PropsUi.setLook((Widget)this.scrlNotificationsComp);
        this.notificationsComp = new Composite((Composite)this.scrlNotificationsComp, 0);
        PropsUi.setLook((Widget)this.notificationsComp);
        FormLayout notificationsLayout = new FormLayout();
        notificationsLayout.marginWidth = 3;
        notificationsLayout.marginHeight = 3;
        this.notificationsComp.setLayout((Layout)notificationsLayout);
        this.lblnotifyPoint = new Label(this.notificationsComp, 131072);
        PropsUi.setLook((Widget)this.lblnotifyPoint);
        FormData fd_lblnotifyPoint = new FormData();
        fd_lblnotifyPoint.left = new FormAttachment(0, 0);
        fd_lblnotifyPoint.top = new FormAttachment(0, margin);
        fd_lblnotifyPoint.right = new FormAttachment(middle, -margin);
        this.lblnotifyPoint.setLayoutData((Object)fd_lblnotifyPoint);
        this.lblnotifyPoint.setText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.notifyPoint.Label", (String[])new String[0]));
        this.tnotifyPoint = new Combo(this.notificationsComp, 18444);
        PropsUi.setLook((Widget)this.tnotifyPoint);
        FormData fd_tnotifyPoint = new FormData();
        fd_tnotifyPoint.top = new FormAttachment(0, margin);
        fd_tnotifyPoint.left = new FormAttachment(middle, 0);
        fd_tnotifyPoint.right = new FormAttachment(100, 0);
        this.tnotifyPoint.setLayoutData((Object)fd_tnotifyPoint);
        this.tnotifyPoint.setToolTipText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.notifyPoint.Tooltip", (String[])new String[0]));
        this.tnotifyPoint.setItems(this.meta.getNotifyPointValues());
        this.lblMessageID = new Label(this.notificationsComp, 131072);
        PropsUi.setLook((Widget)this.lblMessageID);
        FormData fd_lblMessageID = new FormData();
        fd_lblMessageID.left = new FormAttachment(0, 0);
        fd_lblMessageID.top = new FormAttachment((Control)this.tnotifyPoint, margin);
        fd_lblMessageID.right = new FormAttachment(middle, -margin);
        this.lblMessageID.setLayoutData((Object)fd_lblMessageID);
        this.lblMessageID.setText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.MessageID.Label", (String[])new String[0]));
        this.tMessageID = new TextVar(this.variables, this.notificationsComp, 18436);
        PropsUi.setLook((Widget)this.tMessageID);
        FormData fd_tMessageID = new FormData();
        fd_tMessageID.top = new FormAttachment((Control)this.tnotifyPoint, margin);
        fd_tMessageID.left = new FormAttachment(middle, 0);
        fd_tMessageID.right = new FormAttachment(100, 0);
        this.tMessageID.setLayoutData((Object)fd_tMessageID);
        this.tMessageID.setToolTipText(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.MessageID.Tooltip", (String[])new String[0]));
        int keyWidgetCols = 4;
        int keyWidgetRows = 3;
        ColumnInfo[] ciNotifyProps = new ColumnInfo[keyWidgetCols];
        ciNotifyProps[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.ValueDef.Property.Label", (String[])new String[0]), 1, false);
        ciNotifyProps[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.ValueDef.InField.Label", (String[])new String[0]), 2, new String[]{"Y", "N"}, false);
        ciNotifyProps[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.ValueDef.Field.Label", (String[])new String[0]), 2, new String[0], false);
        ciNotifyProps[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.ValueDef.Value.Label", (String[])new String[0]), 1, false);
        ciNotifyProps[0].setToolTip(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.ValueDef.Property.Tooltip", (String[])new String[0]));
        ciNotifyProps[0].setReadOnly(true);
        ciNotifyProps[1].setToolTip(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.ValueDef.InField.Tooltip", (String[])new String[0]));
        ciNotifyProps[2].setToolTip(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.ValueDef.Field.Tooltip", (String[])new String[0]));
        ciNotifyProps[3].setToolTip(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.Notifications.ValueDef.Value.Tooltip", (String[])new String[0]));
        ciNotifyProps[3].setUsingVariables(true);
        this.fieldColumn = ciNotifyProps[2];
        this.tTableNotifyProps = new TableView(this.variables, this.notificationsComp, 68354, ciNotifyProps, keyWidgetRows, lsMod, this.props);
        FormData fd_TableNotifyProps = new FormData();
        fd_TableNotifyProps.left = new FormAttachment(0, 0);
        fd_TableNotifyProps.top = new FormAttachment((Control)this.tMessageID, margin);
        fd_TableNotifyProps.right = new FormAttachment(100, 0);
        fd_TableNotifyProps.bottom = new FormAttachment(100, -margin);
        this.tTableNotifyProps.setLayoutData((Object)fd_TableNotifyProps);
        Control[] notificationTabList = new Control[]{this.tnotifyPoint, this.tMessageID, this.tTableNotifyProps};
        this.notificationsComp.setTabList(notificationTabList);
        this.notificationsComp.pack();
        Rectangle NotificationsBounds = this.notificationsComp.getBounds();
        this.scrlNotificationsComp.setContent((Control)this.notificationsComp);
        this.scrlNotificationsComp.setExpandHorizontal(true);
        this.scrlNotificationsComp.setExpandVertical(true);
        this.scrlNotificationsComp.setMinWidth(NotificationsBounds.width);
        this.scrlNotificationsComp.setMinHeight(NotificationsBounds.height);
        this.scrlSettingsComp.layout();
        this.tbtmSettings.setControl((Control)this.scrlSettingsComp);
        this.scrlNotificationsComp.layout();
        this.tbtmNotifications.setControl((Control)this.scrlNotificationsComp);
        this.tabFolder.setSelection(0);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)margin, null);
        this.wOk.addListener(13, c -> this.ok());
        this.wCancel.addListener(13, c -> this.cancel());
        SelectionAdapter lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SnsNotifyDialog.this.ok();
            }
        };
        this.wTransformName.addSelectionListener((SelectionListener)lsDef);
        this.tAWSKey.addSelectionListener(lsDef);
        this.tAWSKeySecret.addSelectionListener(lsDef);
        this.tAWSRegion.addSelectionListener((SelectionListener)lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SnsNotifyDialog.this.cancel();
            }
        });
        this.setSize();
        this.populateYesNoSelection();
        this.populateDialog();
        this.meta.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.transformName;
    }

    protected void changeCredentialChainSelection() {
        if (this.tAWSCredChain.getText().equalsIgnoreCase("Y")) {
            this.lblAWSKey.setEnabled(false);
            this.tAWSKey.setEnabled(false);
            this.lblAWSKeySecret.setEnabled(false);
            this.tAWSKeySecret.setEnabled(false);
            this.lblAWSRegion.setEnabled(false);
            this.tAWSRegion.setEnabled(false);
        } else {
            this.lblAWSKey.setEnabled(true);
            this.tAWSKey.setEnabled(true);
            this.lblAWSKeySecret.setEnabled(true);
            this.tAWSKeySecret.setEnabled(true);
            this.lblAWSRegion.setEnabled(true);
            this.tAWSRegion.setEnabled(true);
        }
        this.meta.setChanged();
    }

    private void populateYesNoSelection() {
        this.tAWSCredChain.removeAll();
        this.tAWSCredChain.add("Y");
        this.tAWSCredChain.add("N");
        this.tAWSCredChain.select(0);
    }

    private void setComboValues() {
        Runnable fieldLoader = new Runnable(){

            @Override
            public void run() {
                RowMeta prevFields;
                try {
                    prevFields = SnsNotifyDialog.this.pipelineMeta.getPrevTransformFields(SnsNotifyDialog.this.variables, SnsNotifyDialog.this.transformName);
                }
                catch (HopException e) {
                    prevFields = new RowMeta();
                    SnsNotifyDialog.this.logError(BaseMessages.getString(PKG, (String)"SNSNotifyTransform.ErrorText.NoPrevFields", (String[])new String[0]));
                }
                Object[] prevTransformFieldNames = prevFields.getFieldNames();
                Arrays.sort(prevTransformFieldNames);
                SnsNotifyDialog.this.fieldColumn.setComboValues((String[])prevTransformFieldNames);
            }
        };
        new Thread(fieldLoader).start();
    }

    private void populateAWSRegion(ComboVar tAWSRegion2) {
        tAWSRegion2.removeAll();
        try {
            List snsRegions = RegionUtils.getRegionsForService((String)"sns");
            for (Region region : snsRegions) {
                tAWSRegion2.add(region.getName());
            }
        }
        catch (AmazonClientException e) {
            this.logError(BaseMessages.getString(PKG, (String)e.getMessage(), (String[])new String[0]));
        }
    }

    private void populateDialog() {
        this.wTransformName.selectAll();
        this.tAWSCredChain.setText(this.meta.getAwsCredChain());
        this.tAWSKey.setText(this.meta.getAwsKey());
        this.tAWSKeySecret.setText(this.meta.getAwsKeySecret());
        this.tAWSRegion.setText(this.meta.getAwsRegion());
        this.tnotifyPoint.setText(this.meta.getNotifyPoint());
        this.tMessageID.setText(this.meta.getTFldMessageID());
        this.setComboValues();
        this.tTableNotifyProps.setText("topicARN", 1, 0);
        this.tTableNotifyProps.setText(this.meta.getCInputtopicArn(), 2, 0);
        this.tTableNotifyProps.setText(this.meta.getTFldtopicARN(), 3, 0);
        this.tTableNotifyProps.setText(this.meta.getTValuetopicARN(), 4, 0);
        this.tTableNotifyProps.setText("Subject", 1, 1);
        this.tTableNotifyProps.setText(this.meta.getCInputSubject(), 2, 1);
        this.tTableNotifyProps.setText(this.meta.getTFldSubject(), 3, 1);
        this.tTableNotifyProps.setText(this.meta.getTValueSubject(), 4, 1);
        this.tTableNotifyProps.setText("Message", 1, 2);
        this.tTableNotifyProps.setText(this.meta.getCInputMessage(), 2, 2);
        this.tTableNotifyProps.setText(this.meta.getTFldMessage(), 3, 2);
        this.tTableNotifyProps.setText(this.meta.getTValueMessage(), 4, 2);
    }

    private void cancel() {
        this.transformName = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        this.transformName = this.wTransformName.getText();
        this.meta.setAwsCredChain(this.tAWSCredChain.getText());
        this.meta.setAwsKey(this.tAWSKey.getText());
        this.meta.setAwsKeySecret(this.tAWSKeySecret.getText());
        this.meta.setAwsRegion(this.tAWSRegion.getText());
        this.meta.setNotifyPoint(this.tnotifyPoint.getText());
        this.meta.setTFldMessageID(this.tMessageID.getText());
        int nrKeys = this.tTableNotifyProps.nrNonEmpty();
        for (int i = 0; i < nrKeys; ++i) {
            TableItem item = this.tTableNotifyProps.getNonEmpty(i);
            if (item.getText(1).equals("topicARN")) {
                this.meta.setCInputtopicArn(item.getText(2).isEmpty() ? "N" : item.getText(2));
                this.meta.setTFldtopicARN(item.getText(3));
                this.meta.setTValuetopicARN(item.getText(4));
            }
            if (item.getText(1).equals("Subject")) {
                this.meta.setCInputSubject(item.getText(2).isEmpty() ? "N" : item.getText(2));
                this.meta.setTFldSubject(item.getText(3));
                this.meta.setTValueSubject(item.getText(4));
            }
            if (!item.getText(1).equals("Message")) continue;
            this.meta.setCInputMessage(item.getText(2).isEmpty() ? "N" : item.getText(2));
            this.meta.setTFldMessage(item.getText(3));
            this.meta.setTValueMessage(item.getText(4));
        }
        this.dispose();
    }
}

