/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.aws.sqs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import java.util.List;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.aws.sqs.SqsReaderMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SqsReaderDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static Class<?> PKG = SqsReaderMeta.class;
    private SqsReaderMeta meta;
    private CTabFolder tabFolder;
    private CTabItem tbtmSettings;
    private ScrolledComposite scrlSettingsComp;
    private Composite settingsComp;
    private Label lblAWSCredChain;
    private ComboVar tAWSCredChain;
    private Label lblAWSKey;
    private TextVar tAWSKey;
    private Label lblAWSKeySecret;
    private PasswordTextVar tAWSKeySecret;
    private Label lblAWSRegion;
    private ComboVar tAWSRegion;
    private CTabItem tbtmReaderOutput;
    private ScrolledComposite scrlreaderOutputComp;
    private Composite readerOutputComp;
    private Label lblMessageID;
    private TextVar tMessageID;
    private Label lblMessageBody;
    private TextVar tMessageBody;
    private Label lblReceiptHandle;
    private TextVar tReceiptHandle;
    private Label lblBodyMD5;
    private TextVar tBodyMD5;
    private Label lblMessageDelete;
    private ComboVar tMessageDelete;
    private Label lblSQSQueue;
    private TextVar tSQSQueue;
    private Label lblDevInfo;
    private Group grpOutputField;
    private Group grpOutputSettings;
    private Label lblMaxMessages;
    private TextVar tMaxMessages;
    private Label lblSNSMessage;
    private TextVar tSNSMessage;

    public SqsReaderDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.meta = (SqsReaderMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.meta);
        this.changed = this.meta.hasChanged();
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SqsReaderDialog.this.meta.setChanged();
            }
        };
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SQSReader.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.tabFolder = new CTabFolder((Composite)this.shell, 2048);
        FormData fd_tabFolder = new FormData();
        fd_tabFolder.right = new FormAttachment(100, 0);
        fd_tabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fd_tabFolder.left = new FormAttachment(0, 0);
        fd_tabFolder.bottom = new FormAttachment(100, -50);
        this.tabFolder.setLayoutData((Object)fd_tabFolder);
        PropsUi.setLook((Widget)this.tabFolder);
        this.tbtmSettings = new CTabItem(this.tabFolder, 0);
        this.tbtmSettings.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.Title", (String[])new String[0]));
        this.scrlSettingsComp = new ScrolledComposite((Composite)this.tabFolder, 768);
        this.scrlSettingsComp.setLayout((Layout)new FillLayout());
        PropsUi.setLook((Widget)this.scrlSettingsComp);
        this.settingsComp = new Composite((Composite)this.scrlSettingsComp, 0);
        PropsUi.setLook((Widget)this.settingsComp);
        FormLayout settingsLayout = new FormLayout();
        settingsLayout.marginWidth = 3;
        settingsLayout.marginHeight = 3;
        this.settingsComp.setLayout((Layout)settingsLayout);
        this.lblAWSCredChain = new Label(this.settingsComp, 131072);
        PropsUi.setLook((Widget)this.lblAWSCredChain);
        FormData fd_lblAWSCredChain = new FormData();
        fd_lblAWSCredChain.left = new FormAttachment(0, 0);
        fd_lblAWSCredChain.top = new FormAttachment(0, margin);
        fd_lblAWSCredChain.right = new FormAttachment(middle, -margin);
        this.lblAWSCredChain.setLayoutData((Object)fd_lblAWSCredChain);
        this.lblAWSCredChain.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.AWSCredChain.Label", (String[])new String[0]));
        this.tAWSCredChain = new ComboVar(this.variables, this.settingsComp, 18436);
        PropsUi.setLook((Widget)this.tAWSCredChain);
        FormData fd_tAWSCredChain = new FormData();
        fd_tAWSCredChain.top = new FormAttachment(0, margin);
        fd_tAWSCredChain.left = new FormAttachment(middle, 0);
        fd_tAWSCredChain.right = new FormAttachment(100, 0);
        this.tAWSCredChain.setLayoutData((Object)fd_tAWSCredChain);
        this.tAWSCredChain.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.AWSCredChain.Tooltip", (String[])new String[0]));
        this.tAWSCredChain.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                SqsReaderDialog.this.changeCredentialChainSelection();
            }
        });
        this.lblAWSKey = new Label(this.settingsComp, 131072);
        PropsUi.setLook((Widget)this.lblAWSKey);
        FormData fd_lblAWSKey = new FormData();
        fd_lblAWSKey.left = new FormAttachment(0, 0);
        fd_lblAWSKey.top = new FormAttachment((Control)this.tAWSCredChain, margin);
        fd_lblAWSKey.right = new FormAttachment(middle, -margin);
        this.lblAWSKey.setLayoutData((Object)fd_lblAWSKey);
        this.lblAWSKey.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.AWSKey.Label", (String[])new String[0]));
        this.tAWSKey = new TextVar(this.variables, this.settingsComp, 18436);
        PropsUi.setLook((Widget)this.tAWSKey);
        FormData fd_tAWSKey = new FormData();
        fd_tAWSKey.top = new FormAttachment((Control)this.tAWSCredChain, margin);
        fd_tAWSKey.left = new FormAttachment(middle, 0);
        fd_tAWSKey.right = new FormAttachment(100, 0);
        this.tAWSKey.setLayoutData((Object)fd_tAWSKey);
        this.tAWSKey.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.AWSKey.Tooltip", (String[])new String[0]));
        this.lblAWSKeySecret = new Label(this.settingsComp, 131072);
        PropsUi.setLook((Widget)this.lblAWSKeySecret);
        FormData fd_lblAWSKeySecret = new FormData();
        fd_lblAWSKeySecret.left = new FormAttachment(0, 0);
        fd_lblAWSKeySecret.top = new FormAttachment((Control)this.tAWSKey, margin);
        fd_lblAWSKeySecret.right = new FormAttachment(middle, -margin);
        this.lblAWSKeySecret.setLayoutData((Object)fd_lblAWSKeySecret);
        this.lblAWSKeySecret.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.AWSKeySecret.Label", (String[])new String[0]));
        this.tAWSKeySecret = new PasswordTextVar(this.variables, this.settingsComp, 18436);
        PropsUi.setLook((Widget)this.tAWSKeySecret);
        FormData fd_tAWSKeySecret = new FormData();
        fd_tAWSKeySecret.top = new FormAttachment((Control)this.tAWSKey, margin);
        fd_tAWSKeySecret.left = new FormAttachment(middle, 0);
        fd_tAWSKeySecret.right = new FormAttachment(100, 0);
        this.tAWSKeySecret.setLayoutData((Object)fd_tAWSKeySecret);
        this.tAWSKeySecret.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.AWSKeySecret.Tooltip", (String[])new String[0]));
        this.lblAWSRegion = new Label(this.settingsComp, 131072);
        PropsUi.setLook((Widget)this.lblAWSRegion);
        FormData fd_lblAWSRegion = new FormData();
        fd_lblAWSRegion.left = new FormAttachment(0, 0);
        fd_lblAWSRegion.top = new FormAttachment((Control)this.tAWSKeySecret, margin);
        fd_lblAWSRegion.right = new FormAttachment(middle, -margin);
        this.lblAWSRegion.setLayoutData((Object)fd_lblAWSRegion);
        this.lblAWSRegion.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.AWSRegion.Label", (String[])new String[0]));
        this.tAWSRegion = new ComboVar(this.variables, this.settingsComp, 18436);
        PropsUi.setLook((Widget)this.tAWSRegion);
        FormData fd_tAWSRegion = new FormData();
        fd_tAWSRegion.top = new FormAttachment((Control)this.tAWSKeySecret, margin);
        fd_tAWSRegion.left = new FormAttachment(middle, 0);
        fd_tAWSRegion.right = new FormAttachment(100, 0);
        this.tAWSRegion.setLayoutData((Object)fd_tAWSRegion);
        this.tAWSRegion.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.AWSRegion.Tooltip", (String[])new String[0]));
        this.populateAWSRegion(this.tAWSRegion);
        this.lblSQSQueue = new Label(this.settingsComp, 131072);
        PropsUi.setLook((Widget)this.lblSQSQueue);
        FormData fd_lblSQSQueue = new FormData();
        fd_lblSQSQueue.left = new FormAttachment(0, 0);
        fd_lblSQSQueue.top = new FormAttachment((Control)this.tAWSRegion, margin);
        fd_lblSQSQueue.right = new FormAttachment(middle, -margin);
        this.lblSQSQueue.setLayoutData((Object)fd_lblSQSQueue);
        this.lblSQSQueue.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.SQSQueue.Label", (String[])new String[0]));
        this.tSQSQueue = new TextVar(this.variables, this.settingsComp, 18436);
        PropsUi.setLook((Widget)this.tSQSQueue);
        FormData fd_tSQSQueue = new FormData();
        fd_tSQSQueue.top = new FormAttachment((Control)this.tAWSRegion, margin);
        fd_tSQSQueue.left = new FormAttachment(middle, 0);
        fd_tSQSQueue.right = new FormAttachment(100, 0);
        this.tSQSQueue.setLayoutData((Object)fd_tSQSQueue);
        this.tSQSQueue.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.SQSQueue.Tooltip", (String[])new String[0]));
        Control[] queueTabList = new Control[]{this.tAWSCredChain, this.tAWSKey, this.tAWSKeySecret, this.tAWSRegion};
        this.settingsComp.setTabList(queueTabList);
        this.settingsComp.pack();
        Rectangle settingsBounds = this.settingsComp.getBounds();
        this.scrlSettingsComp.setContent((Control)this.settingsComp);
        this.scrlSettingsComp.setExpandHorizontal(true);
        this.scrlSettingsComp.setExpandVertical(true);
        this.scrlSettingsComp.setMinWidth(settingsBounds.width);
        this.scrlSettingsComp.setMinHeight(settingsBounds.height);
        this.tbtmReaderOutput = new CTabItem(this.tabFolder, 0);
        this.tbtmReaderOutput.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.Title", (String[])new String[0]));
        this.scrlreaderOutputComp = new ScrolledComposite((Composite)this.tabFolder, 768);
        this.scrlreaderOutputComp.setLayout((Layout)new FillLayout());
        PropsUi.setLook((Widget)this.scrlreaderOutputComp);
        this.readerOutputComp = new Composite((Composite)this.scrlreaderOutputComp, 0);
        PropsUi.setLook((Widget)this.readerOutputComp);
        FormLayout ReaderOutputLayout = new FormLayout();
        ReaderOutputLayout.marginWidth = 3;
        ReaderOutputLayout.marginHeight = 3;
        this.readerOutputComp.setLayout((Layout)ReaderOutputLayout);
        this.grpOutputSettings = new Group(this.readerOutputComp, 32);
        PropsUi.setLook((Widget)this.grpOutputSettings);
        this.grpOutputSettings.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.OutputSettings.GroupTitle", (String[])new String[0]));
        FormData fd_grpOutputSettings = new FormData();
        fd_grpOutputSettings.top = new FormAttachment(0, margin);
        fd_grpOutputSettings.left = new FormAttachment(0, margin);
        fd_grpOutputSettings.right = new FormAttachment(100, -margin);
        fd_grpOutputSettings.bottom = new FormAttachment(40, -margin);
        this.grpOutputSettings.setLayoutData((Object)fd_grpOutputSettings);
        FormLayout outputSettingsLayout = new FormLayout();
        outputSettingsLayout.marginWidth = 10;
        outputSettingsLayout.marginHeight = 10;
        this.grpOutputSettings.setLayout((Layout)outputSettingsLayout);
        this.lblMessageDelete = new Label((Composite)this.grpOutputSettings, 131072);
        PropsUi.setLook((Widget)this.lblMessageDelete);
        FormData fd_lblMessageDelete = new FormData();
        fd_lblMessageDelete.left = new FormAttachment(0, 0);
        fd_lblMessageDelete.top = new FormAttachment(0, margin);
        fd_lblMessageDelete.right = new FormAttachment(middle, -margin);
        this.lblMessageDelete.setLayoutData((Object)fd_lblMessageDelete);
        this.lblMessageDelete.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.MessageDelete.Label", (String[])new String[0]));
        this.tMessageDelete = new ComboVar(this.variables, (Composite)this.grpOutputSettings, 18436);
        PropsUi.setLook((Widget)this.tMessageDelete);
        FormData fd_tMessageDelete = new FormData();
        fd_tMessageDelete.top = new FormAttachment(0, margin);
        fd_tMessageDelete.left = new FormAttachment(middle, 0);
        fd_tMessageDelete.right = new FormAttachment(100, 0);
        this.tMessageDelete.setLayoutData((Object)fd_tMessageDelete);
        this.tMessageDelete.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.MessageDelete.Tooltip", (String[])new String[0]));
        this.lblMaxMessages = new Label((Composite)this.grpOutputSettings, 131072);
        PropsUi.setLook((Widget)this.lblMaxMessages);
        FormData fd_lblMaxMessages = new FormData();
        fd_lblMaxMessages.left = new FormAttachment(0, 0);
        fd_lblMaxMessages.top = new FormAttachment((Control)this.tMessageDelete, margin);
        fd_lblMaxMessages.right = new FormAttachment(middle, -margin);
        this.lblMaxMessages.setLayoutData((Object)fd_lblMaxMessages);
        this.lblMaxMessages.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.MaxMessages.Label", (String[])new String[0]));
        this.tMaxMessages = new TextVar(this.variables, (Composite)this.grpOutputSettings, 18436);
        PropsUi.setLook((Widget)this.tMaxMessages);
        FormData fd_tMaxMessages = new FormData();
        fd_tMaxMessages.top = new FormAttachment((Control)this.tMessageDelete, margin);
        fd_tMaxMessages.left = new FormAttachment(middle, 0);
        fd_tMaxMessages.right = new FormAttachment(100, 0);
        this.tMaxMessages.setLayoutData((Object)fd_tMaxMessages);
        this.tMaxMessages.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.MaxMessages.Tooltip", (String[])new String[0]));
        Control[] readerSettingsTabList = new Control[]{this.tMessageDelete, this.tMaxMessages};
        this.grpOutputSettings.setTabList(readerSettingsTabList);
        this.grpOutputField = new Group(this.readerOutputComp, 32);
        PropsUi.setLook((Widget)this.grpOutputField);
        this.grpOutputField.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.OutputFields.GroupTitle", (String[])new String[0]));
        FormData fd_grpOutputField = new FormData();
        fd_grpOutputField.top = new FormAttachment(40, margin);
        fd_grpOutputField.left = new FormAttachment(0, margin);
        fd_grpOutputField.right = new FormAttachment(100, -margin);
        fd_grpOutputField.bottom = new FormAttachment(100, -margin);
        this.grpOutputField.setLayoutData((Object)fd_grpOutputField);
        FormLayout outputFieldsLayout = new FormLayout();
        outputFieldsLayout.marginWidth = 10;
        outputFieldsLayout.marginHeight = 10;
        this.grpOutputField.setLayout((Layout)outputFieldsLayout);
        this.lblMessageID = new Label((Composite)this.grpOutputField, 131072);
        PropsUi.setLook((Widget)this.lblMessageID);
        FormData fd_lblMessageID = new FormData();
        fd_lblMessageID.left = new FormAttachment(0, 0);
        fd_lblMessageID.top = new FormAttachment(0, margin);
        fd_lblMessageID.right = new FormAttachment(middle, -margin);
        this.lblMessageID.setLayoutData((Object)fd_lblMessageID);
        this.lblMessageID.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.MessageID.Label", (String[])new String[0]));
        this.tMessageID = new TextVar(this.variables, (Composite)this.grpOutputField, 18436);
        PropsUi.setLook((Widget)this.tMessageID);
        FormData fd_tMessageID = new FormData();
        fd_tMessageID.top = new FormAttachment(0, margin);
        fd_tMessageID.left = new FormAttachment(middle, 0);
        fd_tMessageID.right = new FormAttachment(100, 0);
        this.tMessageID.setLayoutData((Object)fd_tMessageID);
        this.tMessageID.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.MessageID.Tooltip", (String[])new String[0]));
        this.lblMessageBody = new Label((Composite)this.grpOutputField, 131072);
        PropsUi.setLook((Widget)this.lblMessageBody);
        FormData fd_lblMessageBody = new FormData();
        fd_lblMessageBody.left = new FormAttachment(0, 0);
        fd_lblMessageBody.top = new FormAttachment((Control)this.tMessageID, margin);
        fd_lblMessageBody.right = new FormAttachment(middle, -margin);
        this.lblMessageBody.setLayoutData((Object)fd_lblMessageBody);
        this.lblMessageBody.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.MessageBody.Label", (String[])new String[0]));
        this.tMessageBody = new TextVar(this.variables, (Composite)this.grpOutputField, 18436);
        PropsUi.setLook((Widget)this.tMessageBody);
        FormData fd_tMessageBody = new FormData();
        fd_tMessageBody.top = new FormAttachment((Control)this.tMessageID, margin);
        fd_tMessageBody.left = new FormAttachment(middle, 0);
        fd_tMessageBody.right = new FormAttachment(100, 0);
        this.tMessageBody.setLayoutData((Object)fd_tMessageBody);
        this.tMessageBody.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.MessageBody.Tooltip", (String[])new String[0]));
        this.lblReceiptHandle = new Label((Composite)this.grpOutputField, 131072);
        PropsUi.setLook((Widget)this.lblReceiptHandle);
        FormData fd_lblReceiptHandle = new FormData();
        fd_lblReceiptHandle.left = new FormAttachment(0, 0);
        fd_lblReceiptHandle.top = new FormAttachment((Control)this.tMessageBody, margin);
        fd_lblReceiptHandle.right = new FormAttachment(middle, -margin);
        this.lblReceiptHandle.setLayoutData((Object)fd_lblReceiptHandle);
        this.lblReceiptHandle.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.ReceiptHandle.Label", (String[])new String[0]));
        this.tReceiptHandle = new TextVar(this.variables, (Composite)this.grpOutputField, 18436);
        PropsUi.setLook((Widget)this.tReceiptHandle);
        FormData fd_tReceiptHandle = new FormData();
        fd_tReceiptHandle.top = new FormAttachment((Control)this.tMessageBody, margin);
        fd_tReceiptHandle.left = new FormAttachment(middle, 0);
        fd_tReceiptHandle.right = new FormAttachment(100, 0);
        this.tReceiptHandle.setLayoutData((Object)fd_tReceiptHandle);
        this.tReceiptHandle.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.ReceiptHandle.Tooltip", (String[])new String[0]));
        this.lblBodyMD5 = new Label((Composite)this.grpOutputField, 131072);
        PropsUi.setLook((Widget)this.lblBodyMD5);
        FormData fd_lblBodyMD5 = new FormData();
        fd_lblBodyMD5.left = new FormAttachment(0, 0);
        fd_lblBodyMD5.top = new FormAttachment((Control)this.tReceiptHandle, margin);
        fd_lblBodyMD5.right = new FormAttachment(middle, -margin);
        this.lblBodyMD5.setLayoutData((Object)fd_lblBodyMD5);
        this.lblBodyMD5.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.BodyMD5.Label", (String[])new String[0]));
        this.tBodyMD5 = new TextVar(this.variables, (Composite)this.grpOutputField, 18436);
        PropsUi.setLook((Widget)this.tBodyMD5);
        FormData fd_tBodyMD5 = new FormData();
        fd_tBodyMD5.top = new FormAttachment((Control)this.tReceiptHandle, margin);
        fd_tBodyMD5.left = new FormAttachment(middle, 0);
        fd_tBodyMD5.right = new FormAttachment(100, 0);
        this.tBodyMD5.setLayoutData((Object)fd_tBodyMD5);
        this.tBodyMD5.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.BodyMD5.Tooltip", (String[])new String[0]));
        this.lblSNSMessage = new Label((Composite)this.grpOutputField, 131072);
        PropsUi.setLook((Widget)this.lblSNSMessage);
        FormData fd_lblSNSMessage = new FormData();
        fd_lblSNSMessage.left = new FormAttachment(0, 0);
        fd_lblSNSMessage.top = new FormAttachment((Control)this.tBodyMD5, margin);
        fd_lblSNSMessage.right = new FormAttachment(middle, -margin);
        this.lblSNSMessage.setLayoutData((Object)fd_lblSNSMessage);
        this.lblSNSMessage.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.SNSMessage.Label", (String[])new String[0]));
        this.tSNSMessage = new TextVar(this.variables, (Composite)this.grpOutputField, 18436);
        PropsUi.setLook((Widget)this.tSNSMessage);
        FormData fd_tSNSMessage = new FormData();
        fd_tSNSMessage.top = new FormAttachment((Control)this.tBodyMD5, margin);
        fd_tSNSMessage.left = new FormAttachment(middle, 0);
        fd_tSNSMessage.right = new FormAttachment(100, 0);
        this.tSNSMessage.setLayoutData((Object)fd_tSNSMessage);
        this.tSNSMessage.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.SNSMessage.Tooltip", (String[])new String[0]));
        Control[] readerOutputTabList = new Control[]{this.tMessageID, this.tMessageBody, this.tReceiptHandle, this.tBodyMD5, this.tSNSMessage};
        this.grpOutputField.setTabList(readerOutputTabList);
        this.readerOutputComp.pack();
        Rectangle ReaderOutputBounds = this.readerOutputComp.getBounds();
        this.scrlreaderOutputComp.setContent((Control)this.readerOutputComp);
        this.scrlreaderOutputComp.setExpandHorizontal(true);
        this.scrlreaderOutputComp.setExpandVertical(true);
        this.scrlreaderOutputComp.setMinWidth(ReaderOutputBounds.width);
        this.scrlreaderOutputComp.setMinHeight(ReaderOutputBounds.height);
        this.scrlSettingsComp.layout();
        this.tbtmSettings.setControl((Control)this.scrlSettingsComp);
        this.scrlreaderOutputComp.layout();
        this.tbtmReaderOutput.setControl((Control)this.scrlreaderOutputComp);
        this.tabFolder.setSelection(0);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)margin, null);
        this.wOk.addListener(13, c -> this.ok());
        this.wCancel.addListener(13, c -> this.cancel());
        SelectionAdapter lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SqsReaderDialog.this.ok();
            }
        };
        this.wTransformName.addSelectionListener((SelectionListener)lsDef);
        this.tAWSKey.addSelectionListener(lsDef);
        this.tAWSKeySecret.addSelectionListener(lsDef);
        this.tAWSRegion.addSelectionListener((SelectionListener)lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SqsReaderDialog.this.cancel();
            }
        });
        this.setSize();
        this.populateYesNoSelection();
        this.populateDialog();
        this.meta.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.transformName;
    }

    protected void changeCredentialChainSelection() {
        if (this.tAWSCredChain.getText().equalsIgnoreCase("Y")) {
            this.lblAWSKey.setEnabled(false);
            this.tAWSKey.setEnabled(false);
            this.lblAWSKeySecret.setEnabled(false);
            this.tAWSKeySecret.setEnabled(false);
            this.lblAWSRegion.setEnabled(false);
            this.tAWSRegion.setEnabled(false);
        } else {
            this.lblAWSKey.setEnabled(true);
            this.tAWSKey.setEnabled(true);
            this.lblAWSKeySecret.setEnabled(true);
            this.tAWSKeySecret.setEnabled(true);
            this.lblAWSRegion.setEnabled(true);
            this.tAWSRegion.setEnabled(true);
        }
        this.meta.setChanged();
    }

    private void populateYesNoSelection() {
        this.tAWSCredChain.removeAll();
        this.tAWSCredChain.add("Y");
        this.tAWSCredChain.add("N");
        this.tAWSCredChain.select(0);
        this.tMessageDelete.removeAll();
        this.tMessageDelete.add("Y");
        this.tMessageDelete.add("N");
        this.tMessageDelete.select(0);
    }

    private void populateAWSRegion(ComboVar tAWSRegion2) {
        tAWSRegion2.removeAll();
        try {
            List snsRegions = RegionUtils.getRegionsForService((String)"sqs");
            for (Region region : snsRegions) {
                tAWSRegion2.add(region.getName());
            }
        }
        catch (AmazonClientException e) {
            this.logError(BaseMessages.getString(PKG, (String)e.getMessage(), (String[])new String[0]));
        }
    }

    private void populateDialog() {
        this.wTransformName.selectAll();
        this.tAWSCredChain.setText(this.meta.getAwsCredChain());
        this.tAWSKey.setText(this.meta.getAwsKey());
        this.tAWSKeySecret.setText(this.meta.getAwsKeySecret());
        this.tAWSRegion.setText(this.meta.getAwsRegion());
        this.tSQSQueue.setText(this.meta.getSqsQueue());
        this.tMessageDelete.setText(this.meta.getTFldMessageDelete());
        this.tMaxMessages.setText(this.meta.getTFldMaxMessages());
        this.tMessageID.setText(this.meta.getTFldMessageID());
        this.tMessageBody.setText(this.meta.getTFldMessageBody());
        this.tReceiptHandle.setText(this.meta.getTFldReceiptHandle());
        this.tBodyMD5.setText(this.meta.getTFldBodyMD5());
        this.tSNSMessage.setText(this.meta.getTFldSNSMessage());
    }

    private void cancel() {
        this.transformName = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        this.transformName = this.wTransformName.getText();
        this.meta.setAwsCredChain(this.tAWSCredChain.getText());
        this.meta.setAwsKey(this.tAWSKey.getText());
        this.meta.setAwsKeySecret(this.tAWSKeySecret.getText());
        this.meta.setAwsRegion(this.tAWSRegion.getText());
        this.meta.setSqsQueue(this.tSQSQueue.getText());
        this.meta.setTFldMessageDelete(this.tMessageDelete.getText());
        this.meta.setTFldMaxMessages(this.tMaxMessages.getText());
        this.meta.setTFldMessageID(this.tMessageID.getText());
        this.meta.setTFldMessageBody(this.tMessageBody.getText());
        this.meta.setTFldReceiptHandle(this.tReceiptHandle.getText());
        this.meta.setTFldBodyMD5(this.tBodyMD5.getText());
        this.meta.setTFldSNSMessage(this.tSNSMessage.getText());
        this.dispose();
    }
}

