/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.schemas.utils.JsonUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class PubsubWriteSchemaTransformProvider
extends TypedSchemaTransformProvider<PubsubWriteSchemaTransformConfiguration> {
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized PubsubMessage> OUTPUT_TAG = new TupleTag<PubsubMessage>(){};
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> ERROR_TAG = new TupleTag<Row>(){};
    public static final @UnknownKeyFor @NonNull @Initialized String VALID_FORMATS_STR = "AVRO,JSON";
    public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> VALID_DATA_FORMATS = Sets.newHashSet((Object[])"AVRO,JSON".split(","));

    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized PubsubWriteSchemaTransformConfiguration> configurationClass() {
        return PubsubWriteSchemaTransformConfiguration.class;
    }

    public @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized PubsubWriteSchemaTransformConfiguration configuration) {
        if (!VALID_DATA_FORMATS.contains(configuration.getFormat())) {
            throw new IllegalArgumentException(String.format("Format %s not supported. Only supported formats are %s", configuration.getFormat(), VALID_FORMATS_STR));
        }
        return new PubsubWriteSchemaTransform(configuration.getTopic(), configuration.getFormat());
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:pubsub_write:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList("input");
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList("errors");
    }

    private static class PubsubWriteSchemaTransform
    extends SchemaTransform
    implements Serializable {
        final @UnknownKeyFor @NonNull @Initialized String topic;
        final @UnknownKeyFor @NonNull @Initialized String format;

        PubsubWriteSchemaTransform(@UnknownKeyFor @NonNull @Initialized String topic, @UnknownKeyFor @NonNull @Initialized String format) {
            this.topic = topic;
            this.format = format;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Schema errorSchema = Schema.builder().addStringField("error").addNullableRowField("row", input.get("input").getSchema()).build();
            SimpleFunction fn = this.format.equals("AVRO") ? AvroUtils.getRowToAvroBytesFunction((Schema)input.get("input").getSchema()) : JsonUtils.getRowToJsonBytesFunction((Schema)input.get("input").getSchema());
            PCollectionTuple outputTuple = (PCollectionTuple)input.get("input").apply((PTransform)ParDo.of((DoFn)new ErrorFn((SerializableFunction<Row, byte[]>)fn, errorSchema)).withOutputTags(OUTPUT_TAG, TupleTagList.of(ERROR_TAG)));
            outputTuple.get(OUTPUT_TAG).apply(PubsubIO.writeMessages().to(this.topic));
            return PCollectionRowTuple.of((String)"errors", (PCollection)outputTuple.get(ERROR_TAG).setRowSchema(errorSchema));
        }
    }

    public static class ErrorFn
    extends DoFn<Row, PubsubMessage> {
        private @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> valueMapper;
        private @UnknownKeyFor @NonNull @Initialized Schema errorSchema;

        ErrorFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> valueMapper, @UnknownKeyFor @NonNull @Initialized Schema errorSchema) {
            this.valueMapper = valueMapper;
            this.errorSchema = errorSchema;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row row, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver receiver) {
            try {
                receiver.get(OUTPUT_TAG).output((Object)new PubsubMessage((byte[])this.valueMapper.apply((Object)row), null));
            }
            catch (Exception e) {
                receiver.get(ERROR_TAG).output((Object)Row.withSchema((Schema)this.errorSchema).addValues(new Object[]{e.toString(), row}).build());
            }
        }
    }
}

