/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.kafka.ConsumerSpEL;
import org.apache.beam.sdk.io.kafka.DeserializerProvider;
import org.apache.beam.sdk.io.kafka.KafkaCheckpointMark;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.io.kafka.KafkaIOUtils;
import org.apache.beam.sdk.io.kafka.KafkaRecord;
import org.apache.beam.sdk.io.kafka.KafkaUnboundedSource;
import org.apache.beam.sdk.io.kafka.TimestampPolicy;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.metrics.SourceMetrics;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.Closeables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.Deserializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaUnboundedReader<@UnknownKeyFor K, @UnknownKeyFor V>
extends UnboundedSource.UnboundedReader<KafkaRecord<K, V>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(KafkaUnboundedReader.class);
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized String METRIC_NAMESPACE = "KafkaIOReader";
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized String CHECKPOINT_MARK_COMMITS_ENQUEUED_METRIC = "checkpointMarkCommitsEnqueued";
    private static final @UnknownKeyFor @NonNull @Initialized String CHECKPOINT_MARK_COMMITS_SKIPPED_METRIC = "checkpointMarkCommitsSkipped";
    private final @UnknownKeyFor @NonNull @Initialized KafkaUnboundedSource<K, V> source;
    private final @UnknownKeyFor @NonNull @Initialized String name;
    private @Nullable @UnknownKeyFor @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> consumer = null;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PartitionState<K, V>> partitionStates;
    private @Nullable @UnknownKeyFor @Initialized KafkaRecord<K, V> curRecord = null;
    private @Nullable @UnknownKeyFor @Initialized Instant curTimestamp = null;
    private @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized PartitionState<K, V>> curBatch = Collections.emptyIterator();
    private @Nullable @UnknownKeyFor @Initialized Deserializer<K> keyDeserializerInstance = null;
    private @Nullable @UnknownKeyFor @Initialized Deserializer<V> valueDeserializerInstance = null;
    private final @UnknownKeyFor @NonNull @Initialized Counter elementsRead = SourceMetrics.elementsRead();
    private final @UnknownKeyFor @NonNull @Initialized Counter bytesRead = SourceMetrics.bytesRead();
    private final @UnknownKeyFor @NonNull @Initialized Counter elementsReadBySplit;
    private final @UnknownKeyFor @NonNull @Initialized Counter bytesReadBySplit;
    private final @UnknownKeyFor @NonNull @Initialized Gauge backlogBytesOfSplit;
    private final @UnknownKeyFor @NonNull @Initialized Gauge backlogElementsOfSplit;
    private final @UnknownKeyFor @NonNull @Initialized Counter checkpointMarkCommitsEnqueued = Metrics.counter((String)"KafkaIOReader", (String)"checkpointMarkCommitsEnqueued");
    private final @UnknownKeyFor @NonNull @Initialized Counter checkpointMarkCommitsSkipped = Metrics.counter((String)"KafkaIOReader", (String)"checkpointMarkCommitsSkipped");
    private static final @UnknownKeyFor @NonNull @Initialized Duration KAFKA_POLL_TIMEOUT = Duration.millis((long)1000L);
    private static final @UnknownKeyFor @NonNull @Initialized Duration RECORDS_DEQUEUE_POLL_TIMEOUT = Duration.millis((long)10L);
    private static final @UnknownKeyFor @NonNull @Initialized Duration RECORDS_ENQUEUE_POLL_TIMEOUT = Duration.millis((long)100L);
    private final @UnknownKeyFor @NonNull @Initialized ExecutorService consumerPollThread = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("KafkaConsumerPoll-thread").build());
    private @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Exception> consumerPollException = new AtomicReference();
    private final @UnknownKeyFor @NonNull @Initialized SynchronousQueue<@UnknownKeyFor @NonNull @Initialized ConsumerRecords<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> availableRecordsQueue = new SynchronousQueue();
    private @UnknownKeyFor @NonNull @Initialized AtomicReference<@Nullable @UnknownKeyFor @Initialized KafkaCheckpointMark> finalizedCheckpointMark = new AtomicReference();
    private @UnknownKeyFor @NonNull @Initialized AtomicBoolean closed = new AtomicBoolean(false);
    private @Nullable @UnknownKeyFor @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> offsetConsumer = null;
    private final @UnknownKeyFor @NonNull @Initialized ScheduledExecutorService offsetFetcherThread = Executors.newSingleThreadScheduledExecutor();
    private static final @UnknownKeyFor @NonNull @Initialized int OFFSET_UPDATE_INTERVAL_SECONDS = 1;
    private static final @UnknownKeyFor @NonNull @Initialized long UNINITIALIZED_OFFSET = -1L;
    private static @UnknownKeyFor @NonNull @Initialized Instant initialWatermark = BoundedWindow.TIMESTAMP_MIN_VALUE;

    public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
        Consumer consumer;
        KafkaIO.Read<K, V> spec = this.source.getSpec();
        this.consumer = consumer = (Consumer)spec.getConsumerFactoryFn().apply(spec.getConsumerConfig());
        List topicPartitions = (List)Preconditions.checkStateNotNull(spec.getTopicPartitions());
        ConsumerSpEL.evaluateAssign(consumer, topicPartitions);
        this.keyDeserializerInstance = ((DeserializerProvider)Preconditions.checkStateNotNull(spec.getKeyDeserializerProvider())).getDeserializer(spec.getConsumerConfig(), true);
        this.valueDeserializerInstance = ((DeserializerProvider)Preconditions.checkStateNotNull(spec.getValueDeserializerProvider())).getDeserializer(spec.getConsumerConfig(), false);
        for (PartitionState<K, V> pState : this.partitionStates) {
            Future<?> future = this.consumerPollThread.submit(() -> this.setupInitialOffset(pState));
            try {
                Duration timeout = KafkaUnboundedReader.resolveDefaultApiTimeout(spec);
                future.get(timeout.getMillis(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                consumer.wakeup();
                String msg = String.format("%s: Timeout while initializing partition '%s'. Kafka client may not be able to connect to servers.", new Object[]{this, ((PartitionState)pState).topicPartition});
                LOG.error("{}", (Object)msg);
                throw new IOException(msg);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            LOG.info("{}: reading from {} starting at offset {}", new Object[]{this.name, ((PartitionState)pState).topicPartition, ((PartitionState)pState).nextOffset});
        }
        this.consumerPollThread.submit(this::consumerPollLoop);
        Map<String, Object> offsetConsumerConfig = KafkaIOUtils.getOffsetConsumerConfig(this.name, spec.getOffsetConsumerConfig(), spec.getConsumerConfig());
        this.offsetConsumer = (Consumer)spec.getConsumerFactoryFn().apply(offsetConsumerConfig);
        ConsumerSpEL.evaluateAssign(this.offsetConsumer, topicPartitions);
        this.updateLatestOffsets();
        this.offsetFetcherThread.scheduleAtFixedRate(this::updateLatestOffsets, 0L, 1L, TimeUnit.SECONDS);
        return this.advance();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
        while (true) {
            if (this.curBatch.hasNext()) {
                PartitionState<K, V> pState = this.curBatch.next();
                if (!((PartitionState)pState).recordIter.hasNext()) {
                    ((PartitionState)pState).recordIter = Collections.emptyIterator();
                    this.curBatch.remove();
                    continue;
                }
                this.elementsRead.inc();
                this.elementsReadBySplit.inc();
                ConsumerRecord rawRecord = (ConsumerRecord)((PartitionState)pState).recordIter.next();
                long expected = ((PartitionState)pState).nextOffset;
                long offset = rawRecord.offset();
                if (offset < expected) {
                    LOG.warn("{}: ignoring already consumed offset {} for {}", new Object[]{this, offset, ((PartitionState)pState).topicPartition});
                    continue;
                }
                long offsetGap = offset - expected;
                if (this.curRecord == null) {
                    LOG.info("{}: first record offset {}", (Object)this.name, (Object)offset);
                    offsetGap = 0L;
                }
                Deserializer keyDeserializerInstance = (Deserializer)Preconditions.checkStateNotNull(this.keyDeserializerInstance);
                Deserializer valueDeserializerInstance = (Deserializer)Preconditions.checkStateNotNull(this.valueDeserializerInstance);
                KafkaRecord record = new KafkaRecord(rawRecord.topic(), rawRecord.partition(), rawRecord.offset(), ConsumerSpEL.getRecordTimestamp((ConsumerRecord<byte[], byte[]>)rawRecord), ConsumerSpEL.getRecordTimestampType((ConsumerRecord<byte[], byte[]>)rawRecord), ConsumerSpEL.hasHeaders() ? rawRecord.headers() : null, ConsumerSpEL.deserializeKey(keyDeserializerInstance, (ConsumerRecord<byte[], byte[]>)rawRecord), ConsumerSpEL.deserializeValue(valueDeserializerInstance, (ConsumerRecord<byte[], byte[]>)rawRecord));
                this.curTimestamp = ((PartitionState)pState).timestampPolicy.getTimestampForRecord(pState.mkTimestampPolicyContext(), record);
                this.curRecord = record;
                int recordSize = (rawRecord.key() == null ? 0 : ((byte[])rawRecord.key()).length) + (rawRecord.value() == null ? 0 : ((byte[])rawRecord.value()).length);
                pState.recordConsumed(offset, recordSize, offsetGap);
                this.bytesRead.inc((long)recordSize);
                this.bytesReadBySplit.inc((long)recordSize);
                return true;
            }
            this.nextBatch();
            if (!this.curBatch.hasNext()) break;
        }
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
        SerializableFunction<KafkaRecord<K, V>, Instant> watermarkFn = this.source.getSpec().getWatermarkFn();
        if (watermarkFn != null) {
            if (this.curRecord == null) {
                LOG.debug("{}: getWatermark() : no records have been read yet.", (Object)this.name);
                return initialWatermark;
            }
            return (Instant)watermarkFn.apply(this.curRecord);
        }
        return this.partitionStates.stream().map(PartitionState::updateAndGetWatermark).min(Comparator.naturalOrder()).get();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark getCheckpointMark() {
        this.reportBacklog();
        return new KafkaCheckpointMark(this.partitionStates.stream().map(p -> new KafkaCheckpointMark.PartitionMark(((PartitionState)p).topicPartition.topic(), ((PartitionState)p).topicPartition.partition(), ((PartitionState)p).nextOffset, ((PartitionState)p).lastWatermark.getMillis())).collect(Collectors.toList()), this.source.getSpec().isCommitOffsetsInFinalizeEnabled() ? Optional.of(this) : Optional.empty());
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized UnboundedSource<@UnknownKeyFor @NonNull @Initialized KafkaRecord<K, V>, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getCurrentSource() {
        return this.source;
    }

    public @UnknownKeyFor @NonNull @Initialized KafkaRecord<K, V> getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        if (this.curRecord == null) {
            throw new NoSuchElementException();
        }
        return this.curRecord;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        if (this.curTimestamp == null) {
            throw new NoSuchElementException();
        }
        return this.curTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized long getSplitBacklogBytes() {
        long backlogBytes = 0L;
        for (PartitionState<K, V> p : this.partitionStates) {
            long pBacklog = p.approxBacklogInBytes();
            if (pBacklog == -1L) {
                return -1L;
            }
            backlogBytes += pBacklog;
        }
        return backlogBytes;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.name;
    }

    KafkaUnboundedReader(@UnknownKeyFor @NonNull @Initialized KafkaUnboundedSource<K, V> source, @Nullable @UnknownKeyFor @Initialized KafkaCheckpointMark checkpointMark) {
        this.source = source;
        this.name = "Reader-" + source.getId();
        List partitions = (List)Preconditions.checkArgumentNotNull(source.getSpec().getTopicPartitions());
        ArrayList<PartitionState<K, V>> states = new ArrayList<PartitionState<K, V>>(partitions.size());
        if (checkpointMark != null) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((checkpointMark.getPartitions().size() == partitions.size() ? 1 : 0) != 0, (Object)"checkPointMark and assignedPartitions should match");
        }
        for (int i = 0; i < partitions.size(); ++i) {
            TopicPartition tp = (TopicPartition)partitions.get(i);
            long nextOffset = -1L;
            Optional<Instant> prevWatermark = Optional.empty();
            if (checkpointMark != null) {
                KafkaCheckpointMark.PartitionMark ckptMark = checkpointMark.getPartitions().get(i);
                TopicPartition partition = new TopicPartition(ckptMark.getTopic(), ckptMark.getPartition());
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)partition.equals((Object)tp), (String)"checkpointed partition %s and assigned partition %s don't match", (Object)partition, (Object)tp);
                nextOffset = ckptMark.getNextOffset();
                prevWatermark = Optional.of(new Instant(ckptMark.getWatermarkMillis()));
            }
            states.add(new PartitionState<K, V>(tp, nextOffset, source.getSpec().getTimestampPolicyFactory().createTimestampPolicy(tp, prevWatermark)));
        }
        this.partitionStates = ImmutableList.copyOf(states);
        String splitId = String.valueOf(source.getId());
        this.elementsReadBySplit = SourceMetrics.elementsReadBySplit((String)splitId);
        this.bytesReadBySplit = SourceMetrics.bytesReadBySplit((String)splitId);
        this.backlogBytesOfSplit = SourceMetrics.backlogBytesOfSplit((String)splitId);
        this.backlogElementsOfSplit = SourceMetrics.backlogElementsOfSplit((String)splitId);
    }

    private void consumerPollLoop() {
        Consumer consumer = (Consumer)Preconditions.checkStateNotNull(this.consumer);
        try {
            ConsumerRecords records = ConsumerRecords.empty();
            while (!this.closed.get()) {
                try {
                    if (records.isEmpty()) {
                        records = consumer.poll(KAFKA_POLL_TIMEOUT.getMillis());
                    } else if (this.availableRecordsQueue.offer((ConsumerRecords<byte[], byte[]>)records, RECORDS_ENQUEUE_POLL_TIMEOUT.getMillis(), TimeUnit.MILLISECONDS)) {
                        records = ConsumerRecords.empty();
                    }
                    this.commitCheckpointMark();
                }
                catch (InterruptedException e) {
                    LOG.warn("{}: consumer thread is interrupted", (Object)this, (Object)e);
                    break;
                }
                catch (WakeupException e) {
                    // empty catch block
                    break;
                }
            }
            LOG.info("{}: Returning from consumer pool loop", (Object)this);
        }
        catch (Exception e) {
            LOG.error("{}: Exception while reading from Kafka", (Object)this, (Object)e);
            this.consumerPollException.set(e);
            throw e;
        }
    }

    private void commitCheckpointMark() {
        KafkaCheckpointMark checkpointMark = this.finalizedCheckpointMark.getAndSet(null);
        if (checkpointMark != null) {
            LOG.debug("{}: Committing finalized checkpoint {}", (Object)this, (Object)checkpointMark);
            Consumer consumer = (Consumer)Preconditions.checkStateNotNull(this.consumer);
            consumer.commitSync(checkpointMark.getPartitions().stream().filter(p -> p.getNextOffset() != -1L).collect(Collectors.toMap(p -> new TopicPartition(p.getTopic(), p.getPartition()), p -> new OffsetAndMetadata(p.getNextOffset()))));
        }
    }

    void finalizeCheckpointMarkAsync(@UnknownKeyFor @NonNull @Initialized KafkaCheckpointMark checkpointMark) {
        if (this.finalizedCheckpointMark.getAndSet(checkpointMark) != null) {
            this.checkpointMarkCommitsSkipped.inc();
        }
        this.checkpointMarkCommitsEnqueued.inc();
    }

    private void nextBatch() throws @UnknownKeyFor @NonNull @Initialized IOException {
        ConsumerRecords<byte[], byte[]> records;
        this.curBatch = Collections.emptyIterator();
        try {
            records = this.availableRecordsQueue.poll(RECORDS_DEQUEUE_POLL_TIMEOUT.getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("{}: Unexpected", (Object)this, (Object)e);
            return;
        }
        if (records == null) {
            if (this.consumerPollException.get() != null) {
                throw new IOException("Exception while reading from Kafka", this.consumerPollException.get());
            }
            return;
        }
        this.partitionStates.forEach(p -> ((PartitionState)p).recordIter = records.records(((PartitionState)p).topicPartition).iterator());
        this.curBatch = Iterators.cycle(new ArrayList<PartitionState<K, V>>(this.partitionStates));
    }

    private void setupInitialOffset(@UnknownKeyFor @NonNull @Initialized PartitionState<K, V> pState) {
        KafkaIO.Read<K, V> spec = this.source.getSpec();
        Consumer consumer = (Consumer)Preconditions.checkStateNotNull(this.consumer);
        if (((PartitionState)pState).nextOffset != -1L) {
            consumer.seek(((PartitionState)pState).topicPartition, ((PartitionState)pState).nextOffset);
        } else {
            Instant startReadTime = spec.getStartReadTime();
            if (startReadTime != null) {
                ((PartitionState)pState).nextOffset = ConsumerSpEL.offsetForTime(consumer, ((PartitionState)pState).topicPartition, startReadTime);
                consumer.seek(((PartitionState)pState).topicPartition, ((PartitionState)pState).nextOffset);
            } else {
                ((PartitionState)pState).nextOffset = consumer.position(((PartitionState)pState).topicPartition);
            }
        }
    }

    private void updateLatestOffsets() {
        Consumer offsetConsumer = (Consumer)Preconditions.checkStateNotNull(this.offsetConsumer);
        for (PartitionState<K, V> p : this.partitionStates) {
            try {
                Instant fetchTime = Instant.now();
                ConsumerSpEL.evaluateSeek2End(offsetConsumer, ((PartitionState)p).topicPartition);
                long offset = offsetConsumer.position(((PartitionState)p).topicPartition);
                p.setLatestOffset(offset, fetchTime);
            }
            catch (Exception e) {
                if (this.closed.get()) break;
                LOG.warn("{}: exception while fetching latest offset for partition {}. will be retried.", new Object[]{this, ((PartitionState)p).topicPartition, e});
            }
        }
        LOG.debug("{}:  backlog {}", (Object)this, (Object)this.getSplitBacklogBytes());
    }

    private void reportBacklog() {
        long splitBacklogBytes = this.getSplitBacklogBytes();
        if (splitBacklogBytes < 0L) {
            splitBacklogBytes = -1L;
        }
        this.backlogBytesOfSplit.set(splitBacklogBytes);
        long splitBacklogMessages = this.getSplitBacklogMessageCount();
        if (splitBacklogMessages < 0L) {
            splitBacklogMessages = -1L;
        }
        this.backlogElementsOfSplit.set(splitBacklogMessages);
    }

    private @UnknownKeyFor @NonNull @Initialized long getSplitBacklogMessageCount() {
        long backlogCount = 0L;
        for (PartitionState<K, V> p : this.partitionStates) {
            long pBacklog = p.backlogMessageCount();
            if (pBacklog == -1L) {
                return -1L;
            }
            backlogCount += pBacklog;
        }
        return backlogCount;
    }

    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.closed.set(true);
        this.consumerPollThread.shutdown();
        this.offsetFetcherThread.shutdown();
        boolean isShutdown = false;
        while (!isShutdown) {
            if (this.consumer != null) {
                this.consumer.wakeup();
            }
            if (this.offsetConsumer != null) {
                this.offsetConsumer.wakeup();
            }
            this.availableRecordsQueue.poll();
            try {
                isShutdown = this.consumerPollThread.awaitTermination(10L, TimeUnit.SECONDS) && this.offsetFetcherThread.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            if (isShutdown) continue;
            LOG.warn("An internal thread is taking a long time to shutdown. will retry.");
        }
        this.commitCheckpointMark();
        Closeables.close(this.keyDeserializerInstance, (boolean)true);
        Closeables.close(this.valueDeserializerInstance, (boolean)true);
        Closeables.close(this.offsetConsumer, (boolean)true);
        Closeables.close(this.consumer, (boolean)true);
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized Duration resolveDefaultApiTimeout(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @NonNull @Initialized KafkaIO.Read<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> spec) {
        Duration value;
        Duration timeout = KafkaUnboundedReader.tryParseDurationFromMillis(spec.getConsumerConfig().get("default.api.timeout.ms"));
        if (timeout == null && (value = KafkaUnboundedReader.tryParseDurationFromMillis(spec.getConsumerConfig().get("request.timeout.ms"))) != null) {
            timeout = Duration.millis((long)(2L * value.getMillis()));
        }
        return timeout == null ? Duration.standardSeconds((long)60L) : timeout;
    }

    private static @Nullable @UnknownKeyFor @Initialized Duration tryParseDurationFromMillis(@Nullable @UnknownKeyFor @Initialized Object value) {
        if (value == null) {
            return null;
        }
        return value instanceof Integer ? Duration.millis((long)((Integer)value).intValue()) : Duration.millis((long)Integer.parseInt(value.toString()));
    }

    private static class PartitionState<@UnknownKeyFor K, @UnknownKeyFor V> {
        private final @UnknownKeyFor @NonNull @Initialized TopicPartition topicPartition;
        private @UnknownKeyFor @NonNull @Initialized long nextOffset;
        private @UnknownKeyFor @NonNull @Initialized long latestOffset;
        private @UnknownKeyFor @NonNull @Initialized Instant latestOffsetFetchTime;
        private @UnknownKeyFor @NonNull @Initialized Instant lastWatermark;
        private final @UnknownKeyFor @NonNull @Initialized TimestampPolicy<K, V> timestampPolicy;
        private @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized ConsumerRecord<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> recordIter = Collections.emptyIterator();
        private @UnknownKeyFor @NonNull @Initialized KafkaIOUtils.MovingAvg avgRecordSize = new KafkaIOUtils.MovingAvg();
        private @UnknownKeyFor @NonNull @Initialized KafkaIOUtils.MovingAvg avgOffsetGap = new KafkaIOUtils.MovingAvg();

        PartitionState(@UnknownKeyFor @NonNull @Initialized TopicPartition partition, @UnknownKeyFor @NonNull @Initialized long nextOffset, @UnknownKeyFor @NonNull @Initialized TimestampPolicy<K, V> timestampPolicy) {
            this.topicPartition = partition;
            this.nextOffset = nextOffset;
            this.latestOffset = -1L;
            this.latestOffsetFetchTime = BoundedWindow.TIMESTAMP_MIN_VALUE;
            this.lastWatermark = BoundedWindow.TIMESTAMP_MIN_VALUE;
            this.timestampPolicy = timestampPolicy;
        }

        void recordConsumed(@UnknownKeyFor @NonNull @Initialized long offset, @UnknownKeyFor @NonNull @Initialized int size, @UnknownKeyFor @NonNull @Initialized long offsetGap) {
            this.nextOffset = offset + 1L;
            this.avgRecordSize.update(size);
            this.avgOffsetGap.update(offsetGap);
        }

        synchronized void setLatestOffset(@UnknownKeyFor @NonNull @Initialized long latestOffset, @UnknownKeyFor @NonNull @Initialized Instant fetchTime) {
            this.latestOffset = latestOffset;
            this.latestOffsetFetchTime = fetchTime;
            LOG.debug("{}: latest offset update for {} : {} (consumer offset {}, avg record size {})", new Object[]{this, this.topicPartition, latestOffset, this.nextOffset, this.avgRecordSize});
        }

        synchronized @UnknownKeyFor @NonNull @Initialized long approxBacklogInBytes() {
            long backlogMessageCount = this.backlogMessageCount();
            if (backlogMessageCount == -1L) {
                return -1L;
            }
            return (long)((double)backlogMessageCount * this.avgRecordSize.get());
        }

        synchronized @UnknownKeyFor @NonNull @Initialized long backlogMessageCount() {
            if (this.latestOffset < 0L || this.nextOffset < 0L) {
                return -1L;
            }
            double remaining = (double)(this.latestOffset - this.nextOffset) / (1.0 + this.avgOffsetGap.get());
            return Math.max(0L, (long)Math.ceil(remaining));
        }

        synchronized @UnknownKeyFor @NonNull @Initialized TimestampPolicyContext mkTimestampPolicyContext() {
            return new TimestampPolicyContext(this.backlogMessageCount(), this.latestOffsetFetchTime);
        }

        @UnknownKeyFor @NonNull @Initialized Instant updateAndGetWatermark() {
            this.lastWatermark = this.timestampPolicy.getWatermark(this.mkTimestampPolicyContext());
            return this.lastWatermark;
        }
    }

    static class TimestampPolicyContext
    extends TimestampPolicy.PartitionContext {
        private final @UnknownKeyFor @NonNull @Initialized long messageBacklog;
        private final @UnknownKeyFor @NonNull @Initialized Instant backlogCheckTime;

        TimestampPolicyContext(@UnknownKeyFor @NonNull @Initialized long messageBacklog, @UnknownKeyFor @NonNull @Initialized Instant backlogCheckTime) {
            this.messageBacklog = messageBacklog;
            this.backlogCheckTime = backlogCheckTime;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long getMessageBacklog() {
            return this.messageBacklog;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant getBacklogCheckTime() {
            return this.backlogCheckTime;
        }
    }
}

