/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.ShortIdMap;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.SimpleExecutionState;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.SimpleMonitoringInfoBuilder;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SimpleStateRegistry {
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SimpleExecutionState> executionStates = new ArrayList<SimpleExecutionState>();

    public void register(@UnknownKeyFor @NonNull @Initialized SimpleExecutionState state) {
        this.executionStates.add(state);
    }

    public void reset() {
        for (SimpleExecutionState state : this.executionStates) {
            state.reset();
        }
    }

    public @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo> getExecutionTimeMonitoringInfos() {
        ArrayList<MetricsApi.MonitoringInfo> monitoringInfos = new ArrayList<MetricsApi.MonitoringInfo>();
        for (SimpleExecutionState state : this.executionStates) {
            SimpleMonitoringInfoBuilder builder = new SimpleMonitoringInfoBuilder();
            builder.setUrn(state.getUrn());
            for (Map.Entry<String, String> entry : state.getLabels().entrySet()) {
                builder.setLabel(entry.getKey(), entry.getValue());
            }
            builder.setInt64SumValue(state.getTotalMillis());
            monitoringInfos.add(builder.build());
        }
        return monitoringInfos;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ByteString> getExecutionTimeMonitoringData(@UnknownKeyFor @NonNull @Initialized ShortIdMap shortIds) {
        HashMap<String, ByteString> result = new HashMap<String, ByteString>(this.executionStates.size());
        for (SimpleExecutionState state : this.executionStates) {
            if (state.getTotalMillis() == 0L) continue;
            String shortId = state.getTotalMillisShortId(shortIds);
            result.compute(shortId, (k, existing) -> {
                if (existing != null) {
                    return state.mergeTotalMillisPayload((ByteString)existing);
                }
                return state.getTotalMillisPayload();
            });
        }
        return result;
    }
}

