/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WebResult;
import org.owasp.encoder.Encode;

@HopServerServlet(id="startPipeline", name="Prepare and start the execution of a pipeline")
public class StartPipelineServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final Class<?> PKG = StartPipelineServlet.class;
    private static final long serialVersionUID = -5879200987669847357L;
    public static final String CONTEXT_PATH = "/hop/startPipeline";

    public StartPipelineServlet() {
    }

    public StartPipelineServlet(PipelineMap pipelineMap) {
        super(pipelineMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"StartPipelineServlet.Log.PipelineStartRequested", (String[])new String[0]));
        }
        String pipelineName = request.getParameter("name");
        String id = request.getParameter("id");
        if (StringUtils.isEmpty((String)pipelineName)) {
            pipelineName = "";
        }
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        response.setStatus(200);
        PrintWriter out = response.getWriter();
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
            out.print(XmlHandler.getXmlHeader((String)"UTF-8"));
        } else {
            response.setContentType("text/html;charset=UTF-8");
            out.println("<HTML>");
            out.println("<HEAD>");
            out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"StartPipelineServlet.Log.StartOfPipeline", (String[])new String[0]) + "</TITLE>");
            out.println("<META http-equiv=\"Refresh\" content=\"2;url=" + this.convertContextPath("/hop/pipelineStatus") + "?name=" + URLEncoder.encode(pipelineName, StandardCharsets.UTF_8) + "\">");
            out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            out.println("<link rel=\"icon\" type=\"image/svg+xml\" href=\"/static/images/favicon.svg\">");
            out.println("</HEAD>");
            out.println("<BODY>");
        }
        try {
            IPipelineEngine<PipelineMeta> pipeline;
            if (Utils.isEmpty((CharSequence)id)) {
                HopServerObjectEntry entry = this.getPipelineMap().getFirstServerObjectEntry(pipelineName);
                if (entry == null) {
                    pipeline = null;
                } else {
                    id = entry.getId();
                    pipeline = this.getPipelineMap().getPipeline(entry);
                }
            } else {
                HopServerObjectEntry entry = new HopServerObjectEntry(pipelineName, id);
                pipeline = this.getPipelineMap().getPipeline(entry);
            }
            if (pipeline != null) {
                HopLogStore.discardLines((String)pipeline.getLogChannelId(), (boolean)true);
                String serverObjectId = UUID.randomUUID().toString();
                SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.HOP_SERVER, null);
                servletLoggingObject.setContainerObjectId(serverObjectId);
                servletLoggingObject.setLogLevel(pipeline.getLogLevel());
                pipeline.setParent((ILoggingObject)servletLoggingObject);
                this.executePipeline(pipeline);
                String message = BaseMessages.getString(PKG, (String)"StartPipelineServlet.Log.PipelineStarted", (String[])new String[]{pipelineName});
                if (useXML) {
                    out.println(new WebResult("OK", message).getXml());
                } else {
                    out.println("<H1>" + Encode.forHtml((String)message) + "</H1>");
                    out.println("<a href=\"" + this.convertContextPath("/hop/pipelineStatus") + "?name=" + URLEncoder.encode(pipelineName, StandardCharsets.UTF_8) + "&id=" + URLEncoder.encode(id, StandardCharsets.UTF_8) + "\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
                }
            } else {
                String message = BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Log.CoundNotFindSpecPipeline", (String[])new String[]{pipelineName});
                if (useXML) {
                    out.println(new WebResult("ERROR", message, id));
                } else {
                    out.println("<H1>" + Encode.forHtml((String)message) + "</H1>");
                    out.println("<a href=\"" + this.convertContextPath("/hop/status") + "\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
                    response.setStatus(400);
                }
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"StartPipelineServlet.Error.UnexpectedError", (String[])new String[]{Const.CR + Const.getStackTracker((Throwable)ex)})));
            }
            out.println("<p>");
            out.println("<pre>");
            out.println(Encode.forHtml((String)Const.getStackTracker((Throwable)ex)));
            out.println("</pre>");
            response.setStatus(400);
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Start pipeline";
    }

    @Override
    public String getService() {
        return "/hop/startPipeline (" + this.toString() + ")";
    }

    protected void executePipeline(IPipelineEngine<PipelineMeta> pipeline) throws HopException {
        pipeline.execute();
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

