/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.apache.hc.core5.util.Args;

public class InetAddressUtils {
    public static final byte IPV4 = 1;
    public static final byte IPV6 = 4;
    private static final String IPV4_BASIC_PATTERN_STRING = "(([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){1}(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){2}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])";
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){1}(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){2}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    private static final Pattern IPV4_MAPPED_IPV6_PATTERN = Pattern.compile("^::[fF]{4}:(([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){1}(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){2}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){7}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)::(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)$");
    private static final Pattern SCOPE_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9\\-]+$");
    private static final char SCOPE_ID_DELIMITER = '%';
    private static final char COLON_CHAR = ':';
    private static final int MAX_COLON_COUNT = 7;

    private InetAddressUtils() {
    }

    @Deprecated
    public static boolean isIPv4Address(String input) {
        return InetAddressUtils.isIPv4(input);
    }

    public static boolean isIPv4(CharSequence input) {
        return IPV4_PATTERN.matcher(input).matches();
    }

    @Deprecated
    public static boolean isIPv4MappedIPv64Address(String input) {
        return InetAddressUtils.isIPv4MappedIPv6(input);
    }

    public static boolean isIPv4MappedIPv6(CharSequence input) {
        return IPV4_MAPPED_IPV6_PATTERN.matcher(input).matches();
    }

    static boolean hasValidIPv6ColonCount(CharSequence input) {
        int colonCount = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != ':') continue;
            ++colonCount;
        }
        return colonCount >= 2 && colonCount <= 7;
    }

    @Deprecated
    public static boolean isIPv6StdAddress(String input) {
        return InetAddressUtils.isIPv6Std(input);
    }

    public static boolean isIPv6Std(CharSequence input) {
        return InetAddressUtils.hasValidIPv6ColonCount(input) && IPV6_STD_PATTERN.matcher(input).matches();
    }

    @Deprecated
    public static boolean isIPv6HexCompressedAddress(String input) {
        return InetAddressUtils.isIPv6HexCompressed(input);
    }

    public static boolean isIPv6HexCompressed(CharSequence input) {
        return InetAddressUtils.hasValidIPv6ColonCount(input) && IPV6_HEX_COMPRESSED_PATTERN.matcher(input).matches();
    }

    @Deprecated
    public static boolean isIPv6Address(String input) {
        return InetAddressUtils.isIPv6(input);
    }

    public static boolean isIPv6(CharSequence input) {
        int index = -1;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != '%') continue;
            index = i;
            break;
        }
        if (index == -1) {
            return InetAddressUtils.isIPv6Std(input) || InetAddressUtils.isIPv6HexCompressed(input);
        }
        CharSequence address = input.subSequence(0, index);
        if (InetAddressUtils.isIPv6Std(address) || InetAddressUtils.isIPv6HexCompressed(address)) {
            CharSequence scopeId = input.subSequence(index + 1, input.length());
            return scopeId.length() != 0 && SCOPE_ID_PATTERN.matcher(scopeId).matches();
        }
        return false;
    }

    @Deprecated
    public static boolean isIPv6URLBracketedAddress(String input) {
        return InetAddressUtils.isIPv6URLBracketed(input);
    }

    public static boolean isIPv6URLBracketed(CharSequence input) {
        if (input.length() == 0) {
            return false;
        }
        return input.charAt(0) == '[' && input.charAt(input.length() - 1) == ']' && InetAddressUtils.isIPv6(input.subSequence(1, input.length() - 1));
    }

    public static void formatAddress(StringBuilder buffer, SocketAddress socketAddress) {
        Args.notNull(buffer, "buffer");
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress socketaddr = (InetSocketAddress)socketAddress;
            InetAddress inetaddr = socketaddr.getAddress();
            if (inetaddr != null) {
                buffer.append(inetaddr.getHostAddress()).append(':').append(socketaddr.getPort());
            } else {
                buffer.append(socketAddress);
            }
        } else {
            buffer.append(socketAddress);
        }
    }

    public static String getCanonicalLocalHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            return "localhost";
        }
    }
}

