/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc.driver;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.livy.JobContext;
import org.apache.livy.rsc.RSCConf;
import org.apache.livy.rsc.Utils;
import org.apache.livy.rsc.driver.RSCDriver;
import org.apache.livy.rsc.driver.SparkEntries;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.hive.HiveContext;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaStreamingContext;

class JobContextImpl
implements JobContext {
    private final File localTmpDir;
    private volatile JavaStreamingContext streamingctx;
    private final RSCDriver driver;
    private final SparkEntries sparkEntries;
    private final LinkedHashMap<String, Object> sharedVariables;

    public JobContextImpl(SparkEntries sparkEntries, File localTmpDir, RSCDriver driver) {
        this.sparkEntries = sparkEntries;
        this.localTmpDir = localTmpDir;
        this.driver = driver;
        final int retainedVariables = driver.livyConf.getInt(RSCConf.Entry.RETAINED_SHARE_VARIABLES);
        this.sharedVariables = new LinkedHashMap<String, Object>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Object> eldest) {
                return this.size() > retainedVariables;
            }
        };
    }

    public JavaSparkContext sc() {
        return this.sparkEntries.sc();
    }

    public <E> E sparkSession() throws Exception {
        return (E)this.sparkEntries.sparkSession();
    }

    public SQLContext sqlctx() {
        return this.sparkEntries.sqlctx();
    }

    public HiveContext hivectx() {
        return this.sparkEntries.hivectx();
    }

    public synchronized JavaStreamingContext streamingctx() {
        Utils.checkState(this.streamingctx != null, "method createStreamingContext must be called first.", new Object[0]);
        return this.streamingctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E getSharedObject(String name) throws NoSuchElementException {
        Object obj;
        LinkedHashMap<String, Object> linkedHashMap = this.sharedVariables;
        synchronized (linkedHashMap) {
            obj = this.sharedVariables.remove(name);
            if (obj == null) {
                throw new NoSuchElementException("Cannot find shared variable named " + name);
            }
            this.sharedVariables.put(name, obj);
        }
        return (E)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSharedObject(String name, Object object) {
        LinkedHashMap<String, Object> linkedHashMap = this.sharedVariables;
        synchronized (linkedHashMap) {
            this.sharedVariables.put(name, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E removeSharedObject(String name) {
        Object obj;
        LinkedHashMap<String, Object> linkedHashMap = this.sharedVariables;
        synchronized (linkedHashMap) {
            obj = this.sharedVariables.remove(name);
        }
        return (E)obj;
    }

    public synchronized void createStreamingContext(long batchDuration) {
        Utils.checkState(this.streamingctx == null, "Streaming context is not null.", new Object[0]);
        this.streamingctx = new JavaStreamingContext(this.sparkEntries.sc(), new Duration(batchDuration));
    }

    public synchronized void stopStreamingCtx() {
        Utils.checkState(this.streamingctx != null, "Streaming Context is null", new Object[0]);
        this.streamingctx.stop(false);
        this.streamingctx = null;
    }

    public File getLocalTmpDir() {
        return this.localTmpDir;
    }

    public synchronized void stop() {
        if (this.streamingctx != null) {
            this.stopStreamingCtx();
        }
        this.sparkEntries.stop();
    }

    public void addFile(String path) {
        this.driver.addFile(path);
    }

    public void addJarOrPyFile(String path) throws Exception {
        this.driver.addJarOrPyFile(path);
    }
}

