/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Collection;
import java.util.List;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.util.TableScanUtil;

public class BaseCombinedScanTask
implements CombinedScanTask {
    private final FileScanTask[] tasks;
    private volatile transient List<FileScanTask> taskList = null;

    public BaseCombinedScanTask(FileScanTask ... tasks) {
        Preconditions.checkNotNull((Object)tasks, (Object)"tasks cannot be null");
        this.tasks = tasks;
    }

    public BaseCombinedScanTask(List<FileScanTask> tasks) {
        Preconditions.checkNotNull(tasks, (Object)"tasks cannot be null");
        this.tasks = TableScanUtil.mergeTasks(tasks).toArray(new FileScanTask[0]);
    }

    public Collection<FileScanTask> files() {
        if (this.taskList == null) {
            this.taskList = ImmutableList.copyOf((Object[])this.tasks);
        }
        return this.taskList;
    }

    public long sizeBytes() {
        long sizeBytes = 0L;
        for (FileScanTask task : this.tasks) {
            sizeBytes += task.sizeBytes();
        }
        return sizeBytes;
    }

    public long estimatedRowsCount() {
        long estimatedRowsCount = 0L;
        for (FileScanTask task : this.tasks) {
            estimatedRowsCount += task.estimatedRowsCount();
        }
        return estimatedRowsCount;
    }

    public int filesCount() {
        int filesCount = 0;
        for (FileScanTask task : this.tasks) {
            filesCount += task.filesCount();
        }
        return filesCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tasks", (Object)Joiner.on((String)", ").join((Object[])this.tasks)).toString();
    }
}

