/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class FloatFieldMetrics
extends FieldMetrics<Float> {
    private FloatFieldMetrics(int id, long valueCount, long nanValueCount, Float lowerBound, Float upperBound) {
        super(id, valueCount, 0L, nanValueCount, lowerBound, upperBound, (Type)Types.FloatType.get());
    }

    public Builder builderFor(int id) {
        return new Builder(id);
    }

    public static class Builder {
        private final int id;
        private long valueCount = 0L;
        private long nanValueCount = 0L;
        private float lowerBound = Float.POSITIVE_INFINITY;
        private float upperBound = Float.NEGATIVE_INFINITY;

        public Builder(int id) {
            this.id = id;
        }

        public void addValue(float value) {
            ++this.valueCount;
            if (Float.isNaN(value)) {
                ++this.nanValueCount;
            } else {
                if (Float.compare(value, this.lowerBound) < 0) {
                    this.lowerBound = value;
                }
                if (Float.compare(value, this.upperBound) > 0) {
                    this.upperBound = value;
                }
            }
        }

        public FloatFieldMetrics build() {
            boolean hasBound = this.valueCount - this.nanValueCount > 0L;
            return new FloatFieldMetrics(this.id, this.valueCount, this.nanValueCount, hasBound ? Float.valueOf(this.lowerBound) : null, hasBound ? Float.valueOf(this.upperBound) : null);
        }
    }
}

