/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.SystemConfigs;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class ThreadPools {
    @Deprecated
    public static final String WORKER_THREAD_POOL_SIZE_PROP = SystemConfigs.WORKER_THREAD_POOL_SIZE.propertyKey();
    public static final int WORKER_THREAD_POOL_SIZE = SystemConfigs.WORKER_THREAD_POOL_SIZE.value();
    private static final ExecutorService WORKER_POOL = ThreadPools.newExitingWorkerPool("iceberg-worker-pool", WORKER_THREAD_POOL_SIZE);
    public static final int DELETE_WORKER_THREAD_POOL_SIZE = SystemConfigs.DELETE_WORKER_THREAD_POOL_SIZE.value();
    private static final ExecutorService DELETE_WORKER_POOL = ThreadPools.newExitingWorkerPool("iceberg-delete-worker-pool", DELETE_WORKER_THREAD_POOL_SIZE);
    public static final int AUTH_REFRESH_THREAD_POOL_SIZE = SystemConfigs.AUTH_REFRESH_THREAD_POOL_SIZE.value();

    private ThreadPools() {
    }

    public static ExecutorService getWorkerPool() {
        return WORKER_POOL;
    }

    public static ExecutorService getDeleteWorkerPool() {
        return DELETE_WORKER_POOL;
    }

    public static ScheduledExecutorService authRefreshPool() {
        return AuthRefreshPoolHolder.INSTANCE;
    }

    @Deprecated
    public static ExecutorService newWorkerPool(String namePrefix) {
        return ThreadPools.newExitingWorkerPool(namePrefix, WORKER_THREAD_POOL_SIZE);
    }

    @Deprecated
    public static ExecutorService newWorkerPool(String namePrefix, int poolSize) {
        return ThreadPools.newExitingWorkerPool(namePrefix, poolSize);
    }

    public static ExecutorService newExitingWorkerPool(String namePrefix, int poolSize) {
        return MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)ThreadPools.newFixedThreadPool(namePrefix, poolSize)));
    }

    public static ExecutorService newFixedThreadPool(String namePrefix, int poolSize) {
        return Executors.newFixedThreadPool(poolSize, ThreadPools.newDaemonThreadFactory(namePrefix));
    }

    public static ScheduledExecutorService newScheduledPool(String namePrefix, int poolSize) {
        return new ScheduledThreadPoolExecutor(poolSize, ThreadPools.newDaemonThreadFactory(namePrefix));
    }

    public static ScheduledExecutorService newExitingScheduledPool(String namePrefix, int poolSize, Duration terminationTimeout) {
        return MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)((ScheduledThreadPoolExecutor)ThreadPools.newScheduledPool(namePrefix, poolSize)), (long)terminationTimeout.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private static ThreadFactory newDaemonThreadFactory(String namePrefix) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(namePrefix + "-%d").build();
    }

    private static class AuthRefreshPoolHolder {
        private static final ScheduledExecutorService INSTANCE = ThreadPools.newExitingScheduledPool("auth-session-refresh", AUTH_REFRESH_THREAD_POOL_SIZE, Duration.ZERO);

        private AuthRefreshPoolHolder() {
        }
    }
}

