/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class RenameNode
extends DDLStatementNode {
    protected TableName newTableName;
    protected String oldObjectName;
    protected String newObjectName;
    protected TableDescriptor td;
    private long conglomerateNumber;
    protected boolean usedAlterTable;
    protected int renamingWhat;

    RenameNode(Object object, String string, String string2, boolean bl, int n, ContextManager contextManager) throws StandardException {
        super(contextManager);
        this.usedAlterTable = bl;
        this.renamingWhat = n;
        switch (this.renamingWhat) {
            case 1: {
                this.initAndCheck((TableName)object);
                this.newTableName = this.makeTableName(this.getObjectName().getSchemaName(), string2);
                this.oldObjectName = null;
                this.newObjectName = this.newTableName.getTableName();
                break;
            }
            case 2: {
                TableName tableName = object instanceof TableName ? (TableName)object : this.makeTableName(null, (String)object);
                this.initAndCheck(tableName);
                this.oldObjectName = string;
                this.newObjectName = string2;
                break;
            }
            case 3: {
                this.oldObjectName = string;
                this.newObjectName = string2;
                break;
            }
        }
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    String statementToString() {
        if (this.usedAlterTable) {
            return "ALTER TABLE";
        }
        switch (this.renamingWhat) {
            case 1: {
                return "RENAME TABLE";
            }
            case 2: {
                return "RENAME COLUMN";
            }
            case 3: {
                return "RENAME INDEX";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public void bindStatement() throws StandardException {
        UniqueTupleDescriptor uniqueTupleDescriptor;
        SchemaDescriptor schemaDescriptor;
        CompilerContext compilerContext = this.getCompilerContext();
        DataDictionary dataDictionary = this.getDataDictionary();
        if (this.renamingWhat == 3) {
            schemaDescriptor = this.getSchemaDescriptor(null);
            uniqueTupleDescriptor = dataDictionary.getConglomerateDescriptor(this.oldObjectName, schemaDescriptor, false);
            if (uniqueTupleDescriptor == null) {
                throw StandardException.newException((String)"42X65", (Object[])new Object[]{this.oldObjectName});
            }
            this.td = dataDictionary.getTableDescriptor(uniqueTupleDescriptor.getTableID());
            this.initAndCheck(this.makeTableName(this.td.getSchemaName(), this.td.getName()));
        } else {
            schemaDescriptor = this.getSchemaDescriptor();
        }
        this.td = this.getTableDescriptor();
        if (this.td.getTableType() == 3) {
            throw StandardException.newException((String)"42995", (Object[])new Object[0]);
        }
        switch (this.renamingWhat) {
            case 1: {
                uniqueTupleDescriptor = this.getTableDescriptor(this.newObjectName, schemaDescriptor);
                if (uniqueTupleDescriptor != null) {
                    throw this.descriptorExistsException(uniqueTupleDescriptor, schemaDescriptor);
                }
                this.renameTableBind(dataDictionary);
                break;
            }
            case 2: {
                this.renameColumnBind(dataDictionary);
                break;
            }
            case 3: {
                ConglomerateDescriptor conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(this.newObjectName, schemaDescriptor, false);
                if (conglomerateDescriptor == null) break;
                throw this.descriptorExistsException(conglomerateDescriptor, schemaDescriptor);
            }
        }
        this.conglomerateNumber = this.td.getHeapConglomerateId();
        ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(this.conglomerateNumber);
        compilerContext.createDependency(this.td);
        compilerContext.createDependency(conglomerateDescriptor);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        if (RenameNode.isSessionSchema(this.td.getSchemaName())) {
            return true;
        }
        return this.renamingWhat == 1 && this.isSessionSchema(this.getSchemaDescriptor());
    }

    private void renameTableBind(DataDictionary dataDictionary) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(this.td);
        int n = constraintDescriptorList == null ? 0 : constraintDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
            if (constraintDescriptor.getConstraintType() != 4) continue;
            throw StandardException.newException((String)"X0Y25.S", (Object[])new Object[]{"RENAME", this.td.getName(), "CONSTRAINT", constraintDescriptor.getConstraintName()});
        }
    }

    private void renameColumnBind(DataDictionary dataDictionary) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.oldObjectName);
        if (columnDescriptor == null) {
            throw StandardException.newException((String)"42X14", (Object[])new Object[]{this.oldObjectName, this.getFullName()});
        }
        ColumnDescriptor columnDescriptor2 = this.td.getColumnDescriptor(this.newObjectName);
        if (columnDescriptor2 != null) {
            throw this.descriptorExistsException(columnDescriptor2, this.td);
        }
        ColumnDescriptorList columnDescriptorList = this.td.getGeneratedColumns();
        int n = columnDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor3 = columnDescriptorList.elementAt(i);
            for (String string : columnDescriptor3.getDefaultInfo().getReferencedColumnNames()) {
                if (!this.oldObjectName.equals(string)) continue;
                throw StandardException.newException((String)"42XA8", (Object[])new Object[]{this.oldObjectName, columnDescriptor3.getColumnName()});
            }
        }
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(this.td);
        int n2 = constraintDescriptorList == null ? 0 : constraintDescriptorList.size();
        for (int i = 0; i < n2; ++i) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
            if (constraintDescriptor.getConstraintType() != 4) continue;
            ColumnDescriptorList columnDescriptorList2 = constraintDescriptor.getColumnDescriptors();
            int n3 = columnDescriptorList2.size();
            for (int j = 0; j < n3; ++j) {
                if (columnDescriptorList2.elementAt(j) != columnDescriptor) continue;
                throw StandardException.newException((String)"42Z97", (Object[])new Object[]{this.oldObjectName, constraintDescriptor.getConstraintName()});
            }
        }
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getRenameConstantAction(this.getFullName(), this.getRelativeName(), this.oldObjectName, this.newObjectName, this.getSchemaDescriptor(), this.td.getUUID(), this.usedAlterTable, this.renamingWhat);
    }

    private StandardException descriptorExistsException(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) {
        return StandardException.newException((String)"X0Y32.S", (Object[])new Object[]{tupleDescriptor.getDescriptorType(), tupleDescriptor.getDescriptorName(), tupleDescriptor2.getDescriptorType(), tupleDescriptor2.getDescriptorName()});
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.newTableName != null) {
            this.newTableName = (TableName)this.newTableName.accept(visitor);
        }
    }
}

