/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.websocket.internal.jsr;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.json.Json;
import javax.json.JsonReaderFactory;
import javax.json.JsonWriterFactory;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;

@WebListener
public class FactoryLocator
implements ServletContextListener {
    private static final Map<ClassLoader, JsonReaderFactory> READER_FACTORY_BY_LOADER = new ConcurrentHashMap<ClassLoader, JsonReaderFactory>();
    private static final Map<ClassLoader, JsonWriterFactory> WRITER_FACTORY_BY_LOADER = new ConcurrentHashMap<ClassLoader, JsonWriterFactory>();
    private static final String READER_ATTRIBUTE = FactoryLocator.class.getName() + ".readerFactory";
    private static final String WRITER_ATTRIBUTE = FactoryLocator.class.getName() + ".writerFactory";

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ClassLoader classLoader = servletContextEvent.getServletContext().getClassLoader();
        JsonReaderFactory reader = FactoryLocator.newReadFactory();
        READER_FACTORY_BY_LOADER.put(classLoader, reader);
        servletContextEvent.getServletContext().setAttribute(READER_ATTRIBUTE, (Object)reader);
        JsonWriterFactory writer = FactoryLocator.newWriterFactory();
        WRITER_FACTORY_BY_LOADER.put(classLoader, writer);
        servletContextEvent.getServletContext().setAttribute(WRITER_ATTRIBUTE, (Object)reader);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ClassLoader classLoader = servletContextEvent.getServletContext().getClassLoader();
        READER_FACTORY_BY_LOADER.remove(classLoader);
        WRITER_FACTORY_BY_LOADER.remove(classLoader);
    }

    public static JsonReaderFactory readerLocate() {
        JsonReaderFactory factory;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = FactoryLocator.class.getClassLoader();
        }
        if ((factory = READER_FACTORY_BY_LOADER.get(loader)) == null) {
            return FactoryLocator.newReadFactory();
        }
        return factory;
    }

    public static JsonWriterFactory writerLocate() {
        JsonWriterFactory factory;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = FactoryLocator.class.getClassLoader();
        }
        if ((factory = WRITER_FACTORY_BY_LOADER.get(loader)) == null) {
            return FactoryLocator.newWriterFactory();
        }
        return factory;
    }

    private static JsonReaderFactory newReadFactory() {
        return Json.createReaderFactory(Collections.emptyMap());
    }

    private static JsonWriterFactory newWriterFactory() {
        return Json.createWriterFactory(Collections.emptyMap());
    }
}

