/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.annotation.HtmlDoc;

@Deprecated
public class HtmlDocBuilder {
    private final PropertyStoreBuilder builder;
    private static final Pattern INDEXED_LINK_PATTERN = Pattern.compile("(?s)(\\S*)\\[(\\d+)\\]\\:(.*)");

    public HtmlDocBuilder(PropertyStoreBuilder builder) {
        this.builder = builder;
    }

    public void process(HtmlDoc hd) {
        if (hd.header().length > 0) {
            this.header(hd.header());
        }
        if (hd.nav().length > 0) {
            this.nav(hd.nav());
        }
        if (hd.aside().length > 0) {
            this.aside(hd.aside());
        }
        if (hd.footer().length > 0) {
            this.footer(hd.footer());
        }
        if (hd.style().length > 0) {
            this.style(hd.style());
        }
        if (hd.script().length > 0) {
            this.script(hd.script());
        }
        if (hd.navlinks().length > 0) {
            this.navlinks(hd.navlinks());
        }
        if (hd.head().length > 0) {
            this.head(hd.head());
        }
        if (hd.stylesheet().length > 0) {
            this.stylesheet(hd.stylesheet());
        }
        if (!hd.noResultsMessage().isEmpty()) {
            this.noResultsMessage(hd.noResultsMessage());
        }
        if (!hd.nowrap().isEmpty()) {
            this.nowrap(Boolean.valueOf(hd.nowrap()));
        }
        if (hd.template() != HtmlDocTemplate.class) {
            this.template(hd.template());
        }
    }

    public HtmlDocBuilder header(Object ... value) {
        return this.set("HtmlDocSerializer.header.ls", HtmlDocBuilder.resolveList(value, this.getStringArray("HtmlDocSerializer.header.ls")));
    }

    public HtmlDocBuilder navlinks(Object ... value) {
        return this.set("HtmlDocSerializer.navlinks.ls", HtmlDocBuilder.resolveLinks(value, this.getStringArray("HtmlDocSerializer.navlinks.ls")));
    }

    public HtmlDocBuilder nav(Object ... value) {
        return this.set("HtmlDocSerializer.nav.ls", HtmlDocBuilder.resolveList(value, this.getStringArray("HtmlDocSerializer.nav.ls")));
    }

    public HtmlDocBuilder aside(Object ... value) {
        return this.set("HtmlDocSerializer.aside.ls", HtmlDocBuilder.resolveList(value, this.getStringArray("HtmlDocSerializer.aside.ls")));
    }

    public HtmlDocBuilder footer(Object ... value) {
        return this.set("HtmlDocSerializer.footer.ls", HtmlDocBuilder.resolveList(value, this.getStringArray("HtmlDocSerializer.footer.ls")));
    }

    public HtmlDocBuilder style(Object ... value) {
        return this.set("HtmlDocSerializer.style.ls", HtmlDocBuilder.resolveList(value, this.getStringArray("HtmlDocSerializer.style.ls")));
    }

    public HtmlDocBuilder stylesheet(Object ... value) {
        return this.set("HtmlDocSerializer.stylesheet.ls", HtmlDocBuilder.resolveSet(value, this.getStringArray("HtmlDocSerializer.nav.ls")));
    }

    public HtmlDocBuilder script(Object ... value) {
        return this.set("HtmlDocSerializer.script.ls", HtmlDocBuilder.resolveList(value, this.getStringArray("HtmlDocSerializer.script.ls")));
    }

    public HtmlDocBuilder head(Object ... value) {
        return this.set("HtmlDocSerializer.head.ls", HtmlDocBuilder.resolveList(value, this.getStringArray("HtmlDocSerializer.head.ls")));
    }

    public HtmlDocBuilder nowrap(boolean value) {
        return this.set("HtmlDocSerializer.nowrap.b", value);
    }

    public HtmlDocBuilder noResultsMessage(Object value) {
        return this.set("HtmlDocSerializer.noResultsMessage.s", value);
    }

    public HtmlDocBuilder template(Class<? extends HtmlDocTemplate> value) {
        return this.set("HtmlDocSerializer.template.c", value);
    }

    public HtmlDocBuilder template(HtmlDocTemplate value) {
        return this.set("HtmlDocSerializer.template.c", value);
    }

    private static String[] resolveLinks(Object[] value, String[] prev) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object v : value) {
            String s = StringUtils.stringify(v);
            if ("INHERIT".equals(s)) {
                list.addAll(Arrays.asList(prev));
                continue;
            }
            if (s.indexOf(91) != -1 && INDEXED_LINK_PATTERN.matcher(s).matches()) {
                Matcher lm = INDEXED_LINK_PATTERN.matcher(s);
                lm.matches();
                String key = lm.group(1);
                int index = Math.min(list.size(), Integer.parseInt(lm.group(2)));
                String remainder = lm.group(3);
                list.add(index, key.isEmpty() ? remainder : key + ":" + remainder);
                continue;
            }
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    private static String[] resolveSet(Object[] value, String[] prev) {
        HashSet<String> set = new HashSet<String>();
        for (Object v : value) {
            String s = StringUtils.stringify(v);
            if ("INHERIT".equals(s)) {
                if (prev == null) continue;
                set.addAll(Arrays.asList(prev));
                continue;
            }
            if ("NONE".equals(s)) {
                return new String[0];
            }
            set.add(s);
        }
        return set.toArray(new String[set.size()]);
    }

    private static String[] resolveList(Object[] value, String[] prev) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Object v : value) {
            String s = StringUtils.stringify(v);
            if ("INHERIT".equals(s)) {
                if (prev == null) continue;
                set.addAll(Arrays.asList(prev));
                continue;
            }
            if ("NONE".equals(s)) {
                return new String[0];
            }
            set.add(s);
        }
        return set.toArray(new String[set.size()]);
    }

    private HtmlDocBuilder set(String key, Object value) {
        this.builder.set(key, value);
        return this;
    }

    private String[] getStringArray(String name) {
        return this.builder.peek(String[].class, name);
    }
}

