/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.io.IOException;
import java.io.Writer;
import org.apache.juneau.UriResolver;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.uon.UonSerializerSession;
import org.apache.juneau.uon.UonUtils;

public final class UonWriter
extends SerializerWriter {
    private final UonSerializerSession session;
    private final boolean encodeChars;
    private final boolean plainTextParams;
    private static final AsciiSet unencodedChars = AsciiSet.create().ranges("a-z", "A-Z", "0-9").chars(";/?:@-_.!*'$(),~=").build();
    private static final AsciiSet unencodedCharsAttrName = AsciiSet.create().ranges("a-z", "A-Z", "0-9").chars(";/?:@-_.!*'$(),~").build();
    private static final AsciiSet escapedChars = AsciiSet.create("~'");
    private static final AsciiSet noChars = AsciiSet.create("");
    private static char[] hexArray = "0123456789ABCDEF".toCharArray();

    protected UonWriter(UonSerializerSession session, Writer out, boolean useWhitespace, int maxIndent, boolean encodeChars, boolean trimStrings, boolean plainTextParams, UriResolver uriResolver) {
        super(out, useWhitespace, maxIndent, trimStrings, '\'', uriResolver);
        this.session = session;
        this.encodeChars = encodeChars;
        this.plainTextParams = plainTextParams;
    }

    public final UonWriter appendObject(Object o, boolean isTopAttrName) throws IOException {
        AsciiSet esc;
        if (o instanceof Boolean) {
            return this.appendBoolean(o);
        }
        if (o instanceof Number) {
            return this.appendNumber(o);
        }
        if (o == null) {
            return this.append("null");
        }
        String s = this.session.toString(o);
        boolean needsQuotes = !this.plainTextParams && UonUtils.needsQuotes(s);
        AsciiSet unenc = isTopAttrName ? unencodedCharsAttrName : unencodedChars;
        AsciiSet asciiSet = esc = this.plainTextParams ? noChars : escapedChars;
        if (needsQuotes) {
            this.append('\'');
        }
        for (int i = 0; i < s.length(); ++i) {
            int p2;
            int p1;
            char c = s.charAt(i);
            if (esc.contains(c)) {
                this.append('~');
            }
            if (!this.encodeChars || unenc.contains(c)) {
                this.append(c);
                continue;
            }
            if (c == ' ') {
                this.append('+');
                continue;
            }
            int p = s.codePointAt(i);
            if (p < 128) {
                this.appendHex(p);
                continue;
            }
            if (p < 2048) {
                p1 = p >>> 6;
                this.appendHex(p1 + 192).appendHex((p & 0x3F) + 128);
                continue;
            }
            if (p < 65536) {
                p1 = p >>> 6;
                p2 = p1 >>> 6;
                this.appendHex(p2 + 224).appendHex((p1 & 0x3F) + 128).appendHex((p & 0x3F) + 128);
                continue;
            }
            ++i;
            p1 = p >>> 6;
            p2 = p1 >>> 6;
            int p3 = p2 >>> 6;
            this.appendHex(p3 + 240).appendHex((p2 & 0x3F) + 128).appendHex((p1 & 0x3F) + 128).appendHex((p & 0x3F) + 128);
        }
        if (needsQuotes) {
            this.append('\'');
        }
        return this;
    }

    protected UonWriter appendBoolean(Object o) throws IOException {
        this.append(o.toString());
        return this;
    }

    protected UonWriter appendNumber(Object o) throws IOException {
        this.append(o.toString());
        return this;
    }

    private UonWriter appendHex(int b) throws IOException {
        if (b > 255) {
            throw new IOException("Invalid value passed to appendHex.  Must be in the range 0-255.  Value=" + b);
        }
        this.append('%').append(hexArray[b >>> 4]).append(hexArray[b & 0xF]);
        return this;
    }

    @Override
    public SerializerWriter appendUri(Object uri) throws IOException {
        return this.appendObject(this.uriResolver.resolve(uri), false);
    }

    @Override
    public UonWriter cr(int depth) throws IOException {
        super.cr(depth);
        return this;
    }

    @Override
    public UonWriter cre(int depth) throws IOException {
        super.cre(depth);
        return this;
    }

    @Override
    public UonWriter appendln(int indent, String text) throws IOException {
        super.appendln(indent, text);
        return this;
    }

    @Override
    public UonWriter appendln(String text) throws IOException {
        super.appendln(text);
        return this;
    }

    @Override
    public UonWriter append(int indent, String text) throws IOException {
        super.append(indent, text);
        return this;
    }

    @Override
    public UonWriter append(int indent, char c) throws IOException {
        super.append(indent, c);
        return this;
    }

    @Override
    public UonWriter q() throws IOException {
        super.q();
        return this;
    }

    @Override
    public UonWriter i(int indent) throws IOException {
        super.i(indent);
        return this;
    }

    @Override
    public UonWriter nl(int indent) throws IOException {
        super.nl(indent);
        return this;
    }

    @Override
    public UonWriter append(Object text) throws IOException {
        super.append(text);
        return this;
    }

    @Override
    public UonWriter append(String text) throws IOException {
        super.append(text);
        return this;
    }

    @Override
    public UonWriter appendIf(boolean b, String text) throws IOException {
        super.appendIf(b, text);
        return this;
    }

    @Override
    public UonWriter appendIf(boolean b, char c) throws IOException {
        super.appendIf(b, c);
        return this;
    }

    @Override
    public UonWriter append(char c) throws IOException {
        super.append(c);
        return this;
    }
}

