/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.html.HtmlSchemaSerializerBuilder;
import org.apache.juneau.html.HtmlSchemaSerializerSession;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.serializer.SerializerSessionArgs;

@ConfigurableContext
public class HtmlSchemaSerializer
extends HtmlSerializer {
    static final String PREFIX = "HtmlSchemaSerializer";
    public static final HtmlSchemaSerializer DEFAULT = new HtmlSchemaSerializer(PropertyStore.DEFAULT);
    public static final HtmlSchemaSerializer DEFAULT_READABLE = new Readable(PropertyStore.DEFAULT);
    public static final HtmlSchemaSerializer DEFAULT_SIMPLE = new Simple(PropertyStore.DEFAULT);
    public static final HtmlSchemaSerializer DEFAULT_SIMPLE_READABLE = new SimpleReadable(PropertyStore.DEFAULT);
    private final JsonSchemaGenerator generator = JsonSchemaGenerator.create().apply(this.getPropertyStore()).build();

    public HtmlSchemaSerializer(PropertyStore ps) {
        super(ps.builder().set("BeanTraverseContext.detectRecursions.b", true).set("BeanTraverseContext.ignoreRecursions.b", true).build(), "text/html", "text/html+schema");
    }

    @Override
    public HtmlSchemaSerializerBuilder builder() {
        return new HtmlSchemaSerializerBuilder(this.getPropertyStore());
    }

    @Override
    public HtmlSchemaSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public HtmlSchemaSerializerSession createSession(SerializerSessionArgs args) {
        return new HtmlSchemaSerializerSession(this, args);
    }

    JsonSchemaGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap().append("generator", this.generator));
    }

    public static class SimpleReadable
    extends HtmlSchemaSerializer {
        public SimpleReadable(PropertyStore ps) {
            super(ps.builder().set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).set("WriterSerializer.useWhitespace.b", true).build());
        }
    }

    public static class Simple
    extends HtmlSchemaSerializer {
        public Simple(PropertyStore ps) {
            super(ps.builder().set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).build());
        }
    }

    public static class Readable
    extends HtmlSchemaSerializer {
        public Readable(PropertyStore ps) {
            super(ps.builder().set("WriterSerializer.useWhitespace.b", true).build());
        }
    }
}

