/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.msgpack.MsgPackBeanPropertyMeta;
import org.apache.juneau.msgpack.MsgPackClassMeta;
import org.apache.juneau.msgpack.MsgPackCommon;
import org.apache.juneau.msgpack.MsgPackMetaProvider;
import org.apache.juneau.msgpack.MsgPackSerializerBuilder;
import org.apache.juneau.msgpack.MsgPackSerializerSession;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.SerializerSessionArgs;

@ConfigurableContext
public class MsgPackSerializer
extends OutputStreamSerializer
implements MsgPackMetaProvider,
MsgPackCommon {
    static final String PREFIX = "MsgPackSerializer";
    public static final String MSGPACK_addBeanTypes = "MsgPackSerializer.addBeanTypes.b";
    public static final MsgPackSerializer DEFAULT = new MsgPackSerializer(PropertyStore.DEFAULT);
    public static final MsgPackSerializer DEFAULT_SPACED_HEX = new SpacedHex(PropertyStore.DEFAULT);
    public static final MsgPackSerializer DEFAULT_BASE64 = new Base64(PropertyStore.DEFAULT);
    private final boolean addBeanTypes;
    private final Map<ClassMeta<?>, MsgPackClassMeta> msgPackClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, MsgPackBeanPropertyMeta> msgPackBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, MsgPackBeanPropertyMeta>();

    public MsgPackSerializer(PropertyStore ps) {
        super(ps, "octal/msgpack", null);
        this.addBeanTypes = this.getBooleanProperty(MSGPACK_addBeanTypes, this.getBooleanProperty("Serializer.addBeanTypes.b", false));
    }

    @Override
    public MsgPackSerializerBuilder builder() {
        return new MsgPackSerializerBuilder(this.getPropertyStore());
    }

    public static MsgPackSerializerBuilder create() {
        return new MsgPackSerializerBuilder();
    }

    @Override
    public MsgPackSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public MsgPackSerializerSession createSession(SerializerSessionArgs args) {
        return new MsgPackSerializerSession(this, args);
    }

    @Override
    public MsgPackClassMeta getMsgPackClassMeta(ClassMeta<?> cm) {
        MsgPackClassMeta m = this.msgPackClassMetas.get(cm);
        if (m == null) {
            m = new MsgPackClassMeta(cm, this);
            this.msgPackClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public MsgPackBeanPropertyMeta getMsgPackBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return MsgPackBeanPropertyMeta.DEFAULT;
        }
        MsgPackBeanPropertyMeta m = this.msgPackBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new MsgPackBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.msgPackBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    protected final boolean isAddBeanTypes() {
        return this.addBeanTypes;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap().append("addBeanTypes", this.addBeanTypes));
    }

    public static class Base64
    extends MsgPackSerializer {
        public Base64(PropertyStore ps) {
            super(ps.builder().set("OutputStreamSerializer.binaryFormat.s", (Object)BinaryFormat.BASE64).build());
        }
    }

    public static class SpacedHex
    extends MsgPackSerializer {
        public SpacedHex(PropertyStore ps) {
            super(ps.builder().set("OutputStreamSerializer.binaryFormat.s", (Object)BinaryFormat.SPACED_HEX).build());
        }
    }
}

