/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.annotation.Null;
import org.apache.juneau.annotation.Swap;
import org.apache.juneau.reflect.MethodInfo;

public class SwapAnnotation
implements Swap {
    private String on = "";
    private String template = "";
    private Class<?> impl = Null.class;
    private Class<?> value = Null.class;
    private String[] mediaTypes = new String[0];

    public SwapAnnotation(String on) {
        this.on(on);
    }

    public SwapAnnotation(Class<?> on) {
        this.on(on);
    }

    public SwapAnnotation(Method on) {
        this.on(on);
    }

    public SwapAnnotation(Field on) {
        this.on(on);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Swap.class;
    }

    @Override
    public Class<?> impl() {
        return this.impl;
    }

    public SwapAnnotation impl(Class<?> value) {
        this.impl = value;
        return this;
    }

    @Override
    public String[] mediaTypes() {
        return this.mediaTypes;
    }

    public SwapAnnotation mediaTypes(String ... value) {
        this.mediaTypes = value;
        return this;
    }

    @Override
    public String on() {
        return this.on;
    }

    public SwapAnnotation on(String value) {
        this.on = value;
        return this;
    }

    public SwapAnnotation on(Class<?> value) {
        this.on = value.getName();
        return this;
    }

    public SwapAnnotation on(Method value) {
        this.on = MethodInfo.of(value).getFullName();
        return this;
    }

    public SwapAnnotation on(Field value) {
        this.on = value.getName();
        return this;
    }

    @Override
    public String template() {
        return this.template;
    }

    public SwapAnnotation template(String value) {
        this.template = value;
        return this;
    }

    @Override
    public Class<?> value() {
        return this.value;
    }

    public SwapAnnotation value(Class<?> value) {
        this.value = value;
        return this;
    }
}

