/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.swagger.Items;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.marshaller.Json5;

@Bean(properties="in,name,type,description,required,schema,format,allowEmptyValue,items,collectionFormat,default,maximum,exclusiveMaximum,minimum,exclusiveMinimum,maxLength,minLength,pattern,maxItems,minItems,uniqueItems,enum,multipleOf,*")
@FluentSetters
public class ParameterInfo
extends SwaggerElement {
    private static final String[] VALID_IN = new String[]{"query", "header", "path", "formData", "body"};
    private static final String[] VALID_TYPES = new String[]{"string", "number", "integer", "boolean", "array", "file"};
    private static final String[] VALID_COLLECTION_FORMATS = new String[]{"csv", "ssv", "tsv", "pipes", "multi"};
    private String name;
    private String in;
    private String description;
    private String type;
    private String format;
    private String pattern;
    private String collectionFormat;
    private Number maximum;
    private Number minimum;
    private Number multipleOf;
    private Integer maxLength;
    private Integer minLength;
    private Integer maxItems;
    private Integer minItems;
    private Boolean required;
    private Boolean allowEmptyValue;
    private Boolean exclusiveMaximum;
    private Boolean exclusiveMinimum;
    private Boolean uniqueItems;
    private SchemaInfo schema;
    private Items items;
    private Object _default;
    private Set<Object> _enum;
    private Object example;
    private Map<String, String> examples;

    public ParameterInfo() {
    }

    public ParameterInfo(ParameterInfo copyFrom) {
        super(copyFrom);
        this.allowEmptyValue = copyFrom.allowEmptyValue;
        this.collectionFormat = copyFrom.collectionFormat;
        this._default = copyFrom._default;
        this.description = copyFrom.description;
        this._enum = CollectionUtils.copyOf(copyFrom._enum);
        this.example = copyFrom.example;
        this.exclusiveMaximum = copyFrom.exclusiveMaximum;
        this.exclusiveMinimum = copyFrom.exclusiveMinimum;
        this.format = copyFrom.format;
        this.in = copyFrom.in;
        this.items = copyFrom.items == null ? null : copyFrom.items.copy();
        this.maximum = copyFrom.maximum;
        this.maxItems = copyFrom.maxItems;
        this.maxLength = copyFrom.maxLength;
        this.minimum = copyFrom.minimum;
        this.minItems = copyFrom.minItems;
        this.minLength = copyFrom.minLength;
        this.multipleOf = copyFrom.multipleOf;
        this.name = copyFrom.name;
        this.pattern = copyFrom.pattern;
        this.required = copyFrom.required;
        this.schema = copyFrom.schema == null ? null : copyFrom.schema.copy();
        this.type = copyFrom.type;
        this.uniqueItems = copyFrom.uniqueItems;
        this.examples = CollectionUtils.copyOf(copyFrom.examples);
    }

    public ParameterInfo copy() {
        return new ParameterInfo(this);
    }

    @Override
    protected ParameterInfo strict() {
        super.strict();
        return this;
    }

    public ParameterInfo copyFrom(ParameterInfo p) {
        if (p != null) {
            if (p.name != null) {
                this.name = p.name;
            }
            if (p.in != null) {
                this.in = p.in;
            }
            if (p.description != null) {
                this.description = p.description;
            }
            if (p.type != null) {
                this.type = p.type;
            }
            if (p.format != null) {
                this.format = p.format;
            }
            if (p.pattern != null) {
                this.pattern = p.pattern;
            }
            if (p.collectionFormat != null) {
                this.collectionFormat = p.collectionFormat;
            }
            if (p.maximum != null) {
                this.maximum = p.maximum;
            }
            if (p.minimum != null) {
                this.minimum = p.minimum;
            }
            if (p.multipleOf != null) {
                this.multipleOf = p.multipleOf;
            }
            if (p.maxLength != null) {
                this.maxLength = p.maxLength;
            }
            if (p.minLength != null) {
                this.minLength = p.minLength;
            }
            if (p.maxItems != null) {
                this.maxItems = p.maxItems;
            }
            if (p.minItems != null) {
                this.minItems = p.minItems;
            }
            if (p.required != null) {
                this.required = p.required;
            }
            if (p.allowEmptyValue != null) {
                this.allowEmptyValue = p.allowEmptyValue;
            }
            if (p.exclusiveMaximum != null) {
                this.exclusiveMaximum = p.exclusiveMaximum;
            }
            if (p.exclusiveMinimum != null) {
                this.exclusiveMinimum = p.exclusiveMinimum;
            }
            if (p.uniqueItems != null) {
                this.uniqueItems = p.uniqueItems;
            }
            if (p.schema != null) {
                this.schema = p.schema;
            }
            if (p.items != null) {
                this.items = p.items;
            }
            if (p._default != null) {
                this._default = p._default;
            }
            if (p._enum != null) {
                this._enum = p._enum;
            }
            if (p.example != null) {
                this.example = p.example;
            }
            if (p.examples != null) {
                this.examples = p.examples;
            }
        }
        return this;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public ParameterInfo setAllowEmptyValue(Boolean value) {
        this.allowEmptyValue = value;
        return this;
    }

    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    public ParameterInfo setCollectionFormat(String value) {
        if (this.isStrict() && !ArrayUtils.contains(value, VALID_COLLECTION_FORMATS)) {
            throw new BasicRuntimeException("Invalid value passed in to setCollectionFormat(String).  Value=''{0}'', valid values={1}", value, Json5.of(VALID_COLLECTION_FORMATS));
        }
        this.collectionFormat = value;
        return this;
    }

    public Object getDefault() {
        return this._default;
    }

    public ParameterInfo setDefault(Object value) {
        this._default = value;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ParameterInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public Set<Object> getEnum() {
        return this._enum;
    }

    public ParameterInfo setEnum(Collection<Object> value) {
        this._enum = CollectionUtils.setFrom(value);
        return this;
    }

    public ParameterInfo addEnum(Object ... value) {
        this._enum = CollectionUtils.setBuilder(this._enum).sparse().add((Object[])value).build();
        return this;
    }

    public ParameterInfo setEnum(Object ... value) {
        this.setEnum(CollectionUtils.setBuilder(Object.class, new Type[0]).sparse().addAny(value).build());
        return this;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public ParameterInfo setExclusiveMaximum(Boolean value) {
        this.exclusiveMaximum = value;
        return this;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public ParameterInfo setExclusiveMinimum(Boolean value) {
        this.exclusiveMinimum = value;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public ParameterInfo setFormat(String value) {
        this.format = value;
        return this;
    }

    public String getIn() {
        return this.in;
    }

    public ParameterInfo setIn(String value) {
        if (this.isStrict() && !ArrayUtils.contains(value, VALID_IN)) {
            throw new BasicRuntimeException("Invalid value passed in to setIn(String).  Value=''{0}'', valid values={1}", value, Json5.of(VALID_IN));
        }
        this.in = value;
        if ("path".equals(value)) {
            this.required = true;
        }
        return this;
    }

    public Items getItems() {
        return this.items;
    }

    public ParameterInfo setItems(Items value) {
        this.items = value;
        return this;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public ParameterInfo setMaximum(Number value) {
        this.maximum = value;
        return this;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public ParameterInfo setMaxItems(Integer value) {
        this.maxItems = value;
        return this;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public ParameterInfo setMaxLength(Integer value) {
        this.maxLength = value;
        return this;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public ParameterInfo setMinimum(Number value) {
        this.minimum = value;
        return this;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public ParameterInfo setMinItems(Integer value) {
        this.minItems = value;
        return this;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public ParameterInfo setMinLength(Integer value) {
        this.minLength = value;
        return this;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public ParameterInfo setMultipleOf(Number value) {
        this.multipleOf = value;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ParameterInfo setName(String value) {
        if (!"body".equals(this.in)) {
            this.name = value;
        }
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public ParameterInfo setPattern(String value) {
        this.pattern = value;
        return this;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public ParameterInfo setRequired(Boolean value) {
        this.required = value;
        return this;
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    public ParameterInfo setSchema(SchemaInfo value) {
        this.schema = value;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public ParameterInfo setType(String value) {
        if (this.isStrict() && !ArrayUtils.contains(value, VALID_TYPES)) {
            throw new BasicRuntimeException("Invalid value passed in to setType(String).  Value=''{0}'', valid values={1}", value, Json5.of(VALID_TYPES));
        }
        this.type = value;
        return this;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public ParameterInfo setUniqueItems(Boolean value) {
        this.uniqueItems = value;
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "allowEmptyValue": {
                return ConverterUtils.toType(this.getAllowEmptyValue(), type);
            }
            case "collectionFormat": {
                return ConverterUtils.toType(this.getCollectionFormat(), type);
            }
            case "default": {
                return ConverterUtils.toType(this.getDefault(), type);
            }
            case "description": {
                return ConverterUtils.toType(this.getDescription(), type);
            }
            case "enum": {
                return ConverterUtils.toType(this.getEnum(), type);
            }
            case "exclusiveMaximum": {
                return ConverterUtils.toType(this.getExclusiveMaximum(), type);
            }
            case "exclusiveMinimum": {
                return ConverterUtils.toType(this.getExclusiveMinimum(), type);
            }
            case "format": {
                return ConverterUtils.toType(this.getFormat(), type);
            }
            case "in": {
                return ConverterUtils.toType(this.getIn(), type);
            }
            case "items": {
                return ConverterUtils.toType(this.getItems(), type);
            }
            case "maximum": {
                return ConverterUtils.toType(this.getMaximum(), type);
            }
            case "maxItems": {
                return ConverterUtils.toType(this.getMaxItems(), type);
            }
            case "maxLength": {
                return ConverterUtils.toType(this.getMaxLength(), type);
            }
            case "minimum": {
                return ConverterUtils.toType(this.getMinimum(), type);
            }
            case "minItems": {
                return ConverterUtils.toType(this.getMinItems(), type);
            }
            case "minLength": {
                return ConverterUtils.toType(this.getMinLength(), type);
            }
            case "multipleOf": {
                return ConverterUtils.toType(this.getMultipleOf(), type);
            }
            case "name": {
                return ConverterUtils.toType(this.getName(), type);
            }
            case "pattern": {
                return ConverterUtils.toType(this.getPattern(), type);
            }
            case "required": {
                return ConverterUtils.toType(this.getRequired(), type);
            }
            case "schema": {
                return ConverterUtils.toType(this.getSchema(), type);
            }
            case "type": {
                return ConverterUtils.toType(this.getType(), type);
            }
            case "uniqueItems": {
                return ConverterUtils.toType(this.getUniqueItems(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public ParameterInfo set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "allowEmptyValue": {
                return this.setAllowEmptyValue(ConverterUtils.toBoolean(value));
            }
            case "collectionFormat": {
                return this.setCollectionFormat(StringUtils.stringify(value));
            }
            case "default": {
                return this.setDefault(value);
            }
            case "description": {
                return this.setDescription(StringUtils.stringify(value));
            }
            case "enum": {
                return this.setEnum(value);
            }
            case "exclusiveMaximum": {
                return this.setExclusiveMaximum(ConverterUtils.toBoolean(value));
            }
            case "exclusiveMinimum": {
                return this.setExclusiveMinimum(ConverterUtils.toBoolean(value));
            }
            case "format": {
                return this.setFormat(StringUtils.stringify(value));
            }
            case "in": {
                return this.setIn(StringUtils.stringify(value));
            }
            case "items": {
                return this.setItems(ConverterUtils.toType(value, Items.class));
            }
            case "maximum": {
                return this.setMaximum(ConverterUtils.toNumber(value));
            }
            case "maxItems": {
                return this.setMaxItems(ConverterUtils.toInteger(value));
            }
            case "maxLength": {
                return this.setMaxLength(ConverterUtils.toInteger(value));
            }
            case "minimum": {
                return this.setMinimum(ConverterUtils.toNumber(value));
            }
            case "minItems": {
                return this.setMinItems(ConverterUtils.toInteger(value));
            }
            case "minLength": {
                return this.setMinLength(ConverterUtils.toInteger(value));
            }
            case "multipleOf": {
                return this.setMultipleOf(ConverterUtils.toNumber(value));
            }
            case "name": {
                return this.setName(StringUtils.stringify(value));
            }
            case "pattern": {
                return this.setPattern(StringUtils.stringify(value));
            }
            case "required": {
                return this.setRequired(ConverterUtils.toBoolean(value));
            }
            case "schema": {
                return this.setSchema(ConverterUtils.toType(value, SchemaInfo.class));
            }
            case "type": {
                return this.setType(StringUtils.stringify(value));
            }
            case "uniqueItems": {
                return this.setUniqueItems(ConverterUtils.toBoolean(value));
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setBuilder(String.class, new Type[0]).addIf(this.allowEmptyValue != null, "allowEmptyValue").addIf(this.collectionFormat != null, "collectionFormat").addIf(this._default != null, "default").addIf(this.description != null, "description").addIf(this._enum != null, "enum").addIf(this.example != null, "example").addIf(this.examples != null, "examples").addIf(this.exclusiveMaximum != null, "exclusiveMaximum").addIf(this.exclusiveMinimum != null, "exclusiveMinimum").addIf(this.format != null, "format").addIf(this.in != null, "in").addIf(this.items != null, "items").addIf(this.maximum != null, "maximum").addIf(this.maxItems != null, "maxItems").addIf(this.maxLength != null, "maxLength").addIf(this.minimum != null, "minimum").addIf(this.minItems != null, "minItems").addIf(this.minLength != null, "minLength").addIf(this.multipleOf != null, "multipleOf").addIf(this.name != null, "name").addIf(this.pattern != null, "pattern").addIf(this.required != null, "required").addIf(this.schema != null, "schema").addIf(this.type != null, "type").addIf(this.uniqueItems != null, "uniqueItems").build();
        return new MultiSet<String>(s, super.keySet());
    }

    public ParameterInfo resolveRefs(Swagger swagger, Deque<String> refStack, int maxDepth) {
        if (this.schema != null) {
            this.schema = this.schema.resolveRefs(swagger, refStack, maxDepth);
        }
        if (this.items != null) {
            this.items = this.items.resolveRefs(swagger, refStack, maxDepth);
        }
        return this;
    }
}

