/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.juneau.internal.ClassUtils;

public enum Visibility {
    NONE,
    PUBLIC,
    PROTECTED,
    DEFAULT,
    PRIVATE;


    public boolean isVisible(int mod) {
        switch (this) {
            case NONE: {
                return false;
            }
            case PRIVATE: {
                return true;
            }
            case DEFAULT: {
                return !Modifier.isPrivate(mod);
            }
            case PROTECTED: {
                return Modifier.isProtected(mod) || Modifier.isPublic(mod);
            }
        }
        return Modifier.isPublic(mod);
    }

    public boolean isVisible(Class<?> x) {
        return this.isVisible(x.getModifiers());
    }

    public boolean isVisible(Executable x) {
        return this.isVisible(x.getModifiers());
    }

    public boolean isVisible(Field x) {
        return this.isVisible(x.getModifiers());
    }

    public <T> Constructor<T> transform(Constructor<T> x) {
        if (x == null) {
            return null;
        }
        if (this.isVisible(x) && !ClassUtils.setAccessible(x)) {
            return null;
        }
        return x;
    }

    public Method transform(Method x) {
        if (x == null) {
            return null;
        }
        if (this.isVisible(x) && !ClassUtils.setAccessible(x)) {
            return null;
        }
        return x;
    }

    public Field transform(Field x) {
        if (x == null) {
            return null;
        }
        if (this.isVisible(x) && !ClassUtils.setAccessible(x)) {
            return null;
        }
        return x;
    }
}

