/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.swagger;

import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.bean.swagger.Swagger;
import org.apache.juneau.bean.swagger.SwaggerElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.marshaller.Json5;

public class Items
extends SwaggerElement {
    private static final String[] VALID_TYPES = new String[]{"string", "number", "integer", "boolean", "array"};
    private static final String[] VALID_COLLECTION_FORMATS = new String[]{"csv", "ssv", "tsv", "pipes", "multi"};
    private String type;
    private String format;
    private String collectionFormat;
    private String pattern;
    private String ref;
    private Number maximum;
    private Number minimum;
    private Number multipleOf;
    private Integer maxLength;
    private Integer minLength;
    private Integer maxItems;
    private Integer minItems;
    private Boolean exclusiveMaximum;
    private Boolean exclusiveMinimum;
    private Boolean uniqueItems;
    private Items items;
    private Object default_;
    private Set<Object> enum_ = new LinkedHashSet<Object>();

    public Items() {
    }

    public Items(Items copyFrom) {
        super(copyFrom);
        this.collectionFormat = copyFrom.collectionFormat;
        this.default_ = copyFrom.default_;
        if (Utils.nn(copyFrom.enum_)) {
            this.enum_.addAll(CollectionUtils.copyOf(copyFrom.enum_));
        }
        this.exclusiveMaximum = copyFrom.exclusiveMaximum;
        this.exclusiveMinimum = copyFrom.exclusiveMinimum;
        this.format = copyFrom.format;
        this.items = copyFrom.items == null ? null : copyFrom.items.copy();
        this.maximum = copyFrom.maximum;
        this.maxItems = copyFrom.maxItems;
        this.maxLength = copyFrom.maxLength;
        this.minimum = copyFrom.minimum;
        this.minItems = copyFrom.minItems;
        this.minLength = copyFrom.minLength;
        this.multipleOf = copyFrom.multipleOf;
        this.pattern = copyFrom.pattern;
        this.ref = copyFrom.ref;
        this.type = copyFrom.type;
        this.uniqueItems = copyFrom.uniqueItems;
    }

    public Items addEnum(Object ... value) {
        if (Utils.nn(value)) {
            for (Object v : value) {
                if (!Utils.nn(v)) continue;
                this.enum_.add(v);
            }
        }
        return this;
    }

    public Items copy() {
        return new Items(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "collectionFormat" -> ConverterUtils.toType(this.getCollectionFormat(), type);
            case "default" -> ConverterUtils.toType(this.getDefault(), type);
            case "enum" -> ConverterUtils.toType(this.getEnum(), type);
            case "exclusiveMaximum" -> ConverterUtils.toType(this.getExclusiveMaximum(), type);
            case "exclusiveMinimum" -> ConverterUtils.toType(this.getExclusiveMinimum(), type);
            case "format" -> ConverterUtils.toType(this.getFormat(), type);
            case "items" -> ConverterUtils.toType(this.getItems(), type);
            case "maximum" -> ConverterUtils.toType(this.getMaximum(), type);
            case "maxItems" -> ConverterUtils.toType(this.getMaxItems(), type);
            case "maxLength" -> ConverterUtils.toType(this.getMaxLength(), type);
            case "minimum" -> ConverterUtils.toType(this.getMinimum(), type);
            case "minItems" -> ConverterUtils.toType(this.getMinItems(), type);
            case "minLength" -> ConverterUtils.toType(this.getMinLength(), type);
            case "multipleOf" -> ConverterUtils.toType(this.getMultipleOf(), type);
            case "pattern" -> ConverterUtils.toType(this.getPattern(), type);
            case "$ref" -> ConverterUtils.toType(this.getRef(), type);
            case "type" -> ConverterUtils.toType(this.getType(), type);
            case "uniqueItems" -> ConverterUtils.toType(this.getUniqueItems(), type);
            default -> super.get(property, type);
        };
    }

    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    public Object getDefault() {
        return this.default_;
    }

    public Set<Object> getEnum() {
        return Utils.nullIfEmpty(this.enum_);
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public String getFormat() {
        return this.format;
    }

    public Items getItems() {
        return this.items;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Beanp(value="$ref")
    public String getRef() {
        return this.ref;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.ref), "$ref").addIf(Utils.nn(this.collectionFormat), "collectionFormat").addIf(Utils.nn(this.default_), "default").addIf(Utils.ne(this.enum_), "enum").addIf(Utils.nn(this.exclusiveMaximum), "exclusiveMaximum").addIf(Utils.nn(this.exclusiveMinimum), "exclusiveMinimum").addIf(Utils.nn(this.format), "format").addIf(Utils.nn(this.items), "items").addIf(Utils.nn(this.maxItems), "maxItems").addIf(Utils.nn(this.maxLength), "maxLength").addIf(Utils.nn(this.maximum), "maximum").addIf(Utils.nn(this.minItems), "minItems").addIf(Utils.nn(this.minLength), "minLength").addIf(Utils.nn(this.minimum), "minimum").addIf(Utils.nn(this.multipleOf), "multipleOf").addIf(Utils.nn(this.pattern), "pattern").addIf(Utils.nn(this.type), "type").addIf(Utils.nn(this.uniqueItems), "uniqueItems").build();
        return new MultiSet<String>(s, super.keySet());
    }

    public Items resolveRefs(Swagger swagger, Deque<String> refStack, int maxDepth) {
        if (Utils.nn(this.ref)) {
            if (refStack.contains(this.ref) || refStack.size() >= maxDepth) {
                return this;
            }
            refStack.addLast(this.ref);
            Items r = swagger.findRef(this.ref, Items.class).resolveRefs(swagger, refStack, maxDepth);
            refStack.removeLast();
            return r;
        }
        if (Utils.nn(this.items)) {
            this.items = this.items.resolveRefs(swagger, refStack, maxDepth);
        }
        return this;
    }

    @Override
    public Items set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "collectionFormat" -> this.setCollectionFormat(Utils.s(value));
            case "default" -> this.setDefault(value);
            case "enum" -> this.setEnum(CollectionUtils.listb(Object.class).addAny(value).sparse().build());
            case "exclusiveMaximum" -> this.setExclusiveMaximum(ConverterUtils.toBoolean(value));
            case "exclusiveMinimum" -> this.setExclusiveMinimum(ConverterUtils.toBoolean(value));
            case "format" -> this.setFormat(Utils.s(value));
            case "items" -> this.setItems(ConverterUtils.toType(value, Items.class));
            case "maximum" -> this.setMaximum(ConverterUtils.toNumber(value));
            case "maxItems" -> this.setMaxItems(ConverterUtils.toInteger(value));
            case "maxLength" -> this.setMaxLength(ConverterUtils.toInteger(value));
            case "minimum" -> this.setMinimum(ConverterUtils.toNumber(value));
            case "minItems" -> this.setMinItems(ConverterUtils.toInteger(value));
            case "minLength" -> this.setMinLength(ConverterUtils.toInteger(value));
            case "multipleOf" -> this.setMultipleOf(ConverterUtils.toNumber(value));
            case "pattern" -> this.setPattern(Utils.s(value));
            case "$ref" -> this.setRef(Utils.s(value));
            case "type" -> this.setType(Utils.s(value));
            case "uniqueItems" -> this.setUniqueItems(ConverterUtils.toBoolean(value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Items setCollectionFormat(String value) {
        if (this.isStrict() && !CollectionUtils.contains(value, VALID_COLLECTION_FORMATS)) {
            throw ThrowableUtils.rex("Invalid value passed in to setCollectionFormat(String).  Value=''{0}'', valid values={1}", value, Json5.of(VALID_COLLECTION_FORMATS));
        }
        this.collectionFormat = value;
        return this;
    }

    public Items setDefault(Object value) {
        this.default_ = value;
        return this;
    }

    public Items setEnum(Collection<Object> value) {
        this.enum_.clear();
        if (Utils.nn(value)) {
            this.enum_.addAll(value);
        }
        return this;
    }

    public Items setEnum(Object ... value) {
        return this.setEnum(CollectionUtils.l(value));
    }

    public Items setExclusiveMaximum(Boolean value) {
        this.exclusiveMaximum = value;
        return this;
    }

    public Items setExclusiveMinimum(Boolean value) {
        this.exclusiveMinimum = value;
        return this;
    }

    public Items setFormat(String value) {
        this.format = value;
        return this;
    }

    public Items setItems(Items value) {
        this.items = value;
        return this;
    }

    public Items setMaximum(Number value) {
        this.maximum = value;
        return this;
    }

    public Items setMaxItems(Integer value) {
        this.maxItems = value;
        return this;
    }

    public Items setMaxLength(Integer value) {
        this.maxLength = value;
        return this;
    }

    public Items setMinimum(Number value) {
        this.minimum = value;
        return this;
    }

    public Items setMinItems(Integer value) {
        this.minItems = value;
        return this;
    }

    public Items setMinLength(Integer value) {
        this.minLength = value;
        return this;
    }

    public Items setMultipleOf(Number value) {
        this.multipleOf = value;
        return this;
    }

    public Items setPattern(String value) {
        this.pattern = value;
        return this;
    }

    @Beanp(value="$ref")
    public Items setRef(String value) {
        this.ref = value;
        return this;
    }

    public Items setType(String value) {
        if (this.isStrict() && !CollectionUtils.contains(value, VALID_TYPES)) {
            throw ThrowableUtils.rex("Invalid value passed in to setType(String).  Value=''{0}'', valid values={1}", value, Json5.of(VALID_TYPES));
        }
        this.type = value;
        return this;
    }

    public Items setUniqueItems(Boolean value) {
        this.uniqueItems = value;
        return this;
    }

    @Override
    public Items strict() {
        super.strict();
        return this;
    }

    @Override
    public Items strict(Object value) {
        super.strict(value);
        return this;
    }
}

