/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class MultiSet<E>
extends AbstractSet<E> {
    final Collection<E>[] l;

    @SafeVarargs
    public MultiSet(Collection<E> ... c) {
        AssertionUtils.assertArgNotNull("c", c);
        for (Collection<E> cc : c) {
            AssertionUtils.assertArgNotNull("c", cc);
        }
        this.l = c;
    }

    public Enumeration<E> enumerator() {
        return Collections.enumeration(this);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int i = 0;
            Iterator<E> i2;
            {
                this.i2 = MultiSet.this.l.length > 0 ? MultiSet.this.l[this.i++].iterator() : null;
            }

            @Override
            public boolean hasNext() {
                if (this.i2 == null) {
                    return false;
                }
                if (this.i2.hasNext()) {
                    return true;
                }
                for (int j = this.i; j < MultiSet.this.l.length; ++j) {
                    if (MultiSet.this.l[j].size() <= 0) continue;
                    return true;
                }
                return false;
            }

            @Override
            public E next() {
                if (this.i2 == null) {
                    throw new NoSuchElementException();
                }
                while (!this.i2.hasNext()) {
                    if (this.i >= MultiSet.this.l.length) {
                        throw new NoSuchElementException();
                    }
                    this.i2 = MultiSet.this.l[this.i++].iterator();
                }
                return this.i2.next();
            }

            @Override
            public void remove() {
                if (this.i2 == null) {
                    throw new NoSuchElementException();
                }
                this.i2.remove();
            }
        };
    }

    @Override
    public int size() {
        int i = 0;
        for (Collection<E> c : this.l) {
            i += c.size();
        }
        return i;
    }

    @Override
    public String toString() {
        return Arrays.stream(this.l).map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    public boolean equals(Object o) {
        Set o2;
        return o instanceof Set && Utils.eq(this, o2 = (Set)o, (x, y) -> Utils.eq(x.size(), y.size()) && x.containsAll((Collection<?>)y));
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (E e : this) {
            h += e == null ? 0 : e.hashCode();
        }
        return h;
    }
}

