/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.response;

import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.ReasonPhraseCatalog;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.http.BasicStatusLine;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.response.BasicHttpException;

@Response
@StatusCode(value={404})
@Schema(description={"Not Found"})
public class NotFound
extends BasicHttpException {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_CODE = 404;
    public static final String REASON_PHRASE = "Not Found";
    private static final BasicStatusLine STATUS_LINE = BasicStatusLine.create(404, "Not Found");
    public static final NotFound INSTANCE = new NotFound().setUnmodifiable();

    public NotFound() {
        this((Throwable)null, REASON_PHRASE, new Object[0]);
    }

    public NotFound(HttpResponse response) {
        super(response);
        this.assertStatusCode(response);
    }

    public NotFound(String msg, Object ... args) {
        this((Throwable)null, msg, args);
    }

    public NotFound(Throwable cause) {
        this(cause, cause == null ? REASON_PHRASE : cause.getMessage(), new Object[0]);
    }

    public NotFound(Throwable cause, String msg, Object ... args) {
        super(404, cause, msg, args);
        this.setStatusLine(STATUS_LINE.copy());
    }

    protected NotFound(NotFound copyFrom) {
        super(copyFrom);
    }

    public NotFound copy() {
        return new NotFound(this);
    }

    @Override
    public NotFound setContent(HttpEntity value) {
        super.setContent(value);
        return this;
    }

    @Override
    public NotFound setContent(String value) {
        super.setContent(value);
        return this;
    }

    @Override
    public NotFound setHeader2(String name, Object value) {
        super.setHeader2(name, value);
        return this;
    }

    @Override
    public NotFound setHeaders(HeaderList value) {
        super.setHeaders(value);
        return this;
    }

    @Override
    public NotFound setHeaders(List<Header> values) {
        super.setHeaders(values);
        return this;
    }

    @Override
    public NotFound setHeaders2(Header ... values) {
        super.setHeaders2(values);
        return this;
    }

    @Override
    public NotFound setLocale2(Locale value) {
        super.setLocale2(value);
        return this;
    }

    @Override
    public NotFound setMessage(String message, Object ... args) {
        super.setMessage(message, args);
        return this;
    }

    @Override
    public NotFound setProtocolVersion(ProtocolVersion value) {
        super.setProtocolVersion(value);
        return this;
    }

    @Override
    public NotFound setReasonPhrase2(String value) {
        super.setReasonPhrase2(value);
        return this;
    }

    @Override
    public NotFound setReasonPhraseCatalog(ReasonPhraseCatalog value) {
        super.setReasonPhraseCatalog(value);
        return this;
    }

    @Override
    public NotFound setStatusCode2(int code) throws IllegalStateException {
        super.setStatusCode2(code);
        return this;
    }

    @Override
    public NotFound setStatusLine(BasicStatusLine value) {
        super.setStatusLine(value);
        return this;
    }

    @Override
    public NotFound setUnmodifiable() {
        super.setUnmodifiable();
        return this;
    }
}

