/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.UriContext;
import org.apache.juneau.commons.lang.Flag;
import org.apache.juneau.commons.lang.IntegerValue;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.uon.UonSerializerSession;
import org.apache.juneau.uon.UonWriter;
import org.apache.juneau.urlencoding.UrlEncodingClassMeta;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;

public class UrlEncodingSerializerSession
extends UonSerializerSession {
    private final UrlEncodingSerializer ctx;

    public static Builder create(UrlEncodingSerializer ctx) {
        return new Builder(ctx);
    }

    private static Map<Integer, Object> getCollectionMap(Collection<?> c) {
        TreeMap<Integer, Object> m = new TreeMap<Integer, Object>();
        IntegerValue i = IntegerValue.create();
        c.forEach(o -> m.put(i.getAndIncrement(), o));
        return m;
    }

    private static Map<Integer, Object> getCollectionMap(Object array) {
        TreeMap<Integer, Object> m = new TreeMap<Integer, Object>();
        for (int i = 0; i < Array.getLength(array); ++i) {
            m.put(i, Array.get(array, i));
        }
        return m;
    }

    protected UrlEncodingSerializerSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
    }

    private SerializerWriter serializeAnything(UonWriter out, Object o) throws IOException, SerializeException {
        ClassMeta<Object> aType = null;
        ClassMeta<Object> sType = null;
        ClassMeta<?> eType = this.getExpectedRootType(o);
        aType = this.push2("root", o, eType);
        --this.indent;
        if (aType == null) {
            aType = this.object();
        }
        sType = aType;
        String typeName = this.getBeanTypeName(this, eType, aType, null);
        ObjectSwap<Object, ?> swap = aType.getSwap(this);
        if (Utils.nn(swap)) {
            o = this.swap(swap, o);
            sType = swap.getSwapClassMeta(this);
            if (sType.isObject()) {
                sType = this.getClassMetaForObject(o);
            }
        }
        if (sType.isMap()) {
            if (o instanceof BeanMap) {
                BeanMap o2 = (BeanMap)o;
                this.serializeBeanMap(out, o2, typeName);
            } else {
                this.serializeMap(out, (Map)o, sType);
            }
        } else if (sType.isBean()) {
            this.serializeBeanMap(out, this.toBeanMap(o), typeName);
        } else if (sType.isCollection() || sType.isArray()) {
            Map<Integer, Object> m = sType.isCollection() ? UrlEncodingSerializerSession.getCollectionMap((Collection)o) : UrlEncodingSerializerSession.getCollectionMap(o);
            this.serializeCollectionMap(out, m, this.getClassMeta((Type)((Object)Map.class), new Type[]{Integer.class, Object.class}));
        } else if (sType.isReader()) {
            IoUtils.pipe((Reader)((Reader)o), (Writer)out);
        } else if (sType.isInputStream()) {
            IoUtils.pipe((InputStream)((InputStream)o), (Writer)out);
        } else {
            out.append("_value=");
            this.pop();
            super.serializeAnything(out, o, null, null, null);
            return out;
        }
        this.pop();
        return out;
    }

    private SerializerWriter serializeBeanMap(UonWriter out, BeanMap<?> m, String typeName) throws SerializeException {
        Flag addAmp = Flag.create();
        if (Utils.nn((Object)typeName)) {
            BeanPropertyMeta pm = m.getMeta().getTypeProperty();
            out.appendObject(pm.getName(), true).append('=').appendObject(typeName, false);
            addAmp.set();
        }
        Predicate<Object> checkNull = x -> this.isKeepNullProperties() || Utils.nn((Object)x);
        m.forEachValue(checkNull, (pMeta, key, value, thrown) -> {
            ClassMeta<?> cMeta = pMeta.getClassMeta();
            ClassMeta<?> sMeta = cMeta.getSerializedClassMeta(this);
            if (Utils.nn((Object)thrown)) {
                this.onBeanGetterException((BeanPropertyMeta)pMeta, (Throwable)thrown);
            }
            if (this.canIgnoreValue(sMeta, (String)key, value)) {
                return;
            }
            if (Utils.nn((Object)value) && this.shouldUseExpandedParams((BeanPropertyMeta)pMeta)) {
                if (sMeta.isCollection() || value instanceof Collection) {
                    ((Collection)value).forEach(x -> {
                        addAmp.ifSet(() -> out.cr(this.indent).append('&')).set();
                        out.appendObject(key, true).append('=');
                        super.serializeAnything(out, x, cMeta.getElementType(), (String)key, (BeanPropertyMeta)pMeta);
                    });
                } else {
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        addAmp.ifSet(() -> out.cr(this.indent).append('&')).set();
                        out.appendObject(key, true).append('=');
                        super.serializeAnything(out, Array.get(value, i), cMeta.getElementType(), (String)key, (BeanPropertyMeta)pMeta);
                    }
                }
            } else {
                addAmp.ifSet(() -> out.cr(this.indent).append('&')).set();
                out.appendObject(key, true).append('=');
                super.serializeAnything(out, value, cMeta, (String)key, (BeanPropertyMeta)pMeta);
            }
        });
        return out;
    }

    private SerializerWriter serializeCollectionMap(UonWriter out, Map<?, ?> m, ClassMeta<?> type) throws SerializeException {
        ClassMeta<?> valueType = type.getValueType();
        Flag addAmp = Flag.create();
        m.forEach((k, v) -> {
            addAmp.ifSet(() -> out.cr(this.indent).append('&')).set();
            out.append(k).append('=');
            super.serializeAnything(out, v, valueType, null, null);
        });
        return out;
    }

    private SerializerWriter serializeMap(UonWriter out, Map m, ClassMeta<?> type) throws SerializeException {
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        Flag addAmp = Flag.create();
        this.forEachEntry(m, (Map.Entry<K, V> e) -> {
            Object key = this.generalize(e.getKey(), keyType);
            Object value = e.getValue();
            if (this.shouldUseExpandedParams(value)) {
                if (value instanceof Collection) {
                    Collection value2 = (Collection)value;
                    value2.forEach(x -> {
                        addAmp.ifSet(() -> out.cr(this.indent).append('&')).set();
                        out.appendObject(key, true).append('=');
                        super.serializeAnything(out, x, null, Utils.s((Object)key), null);
                    });
                } else {
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        addAmp.ifSet(() -> out.cr(this.indent).append('&')).set();
                        out.appendObject(key, true).append('=');
                        super.serializeAnything(out, Array.get(value, i), null, Utils.s((Object)key), null);
                    }
                }
            } else {
                addAmp.ifSet(() -> out.cr(this.indent).append('&')).set();
                out.appendObject(key, true).append('=');
                super.serializeAnything(out, value, valueType, key == null ? null : key.toString(), null);
            }
        });
        return out;
    }

    private boolean shouldUseExpandedParams(BeanPropertyMeta pMeta) {
        ClassMeta<?> cm = pMeta.getClassMeta().getSerializedClassMeta(this);
        return cm.isCollectionOrArray() && (this.isExpandedParams() || this.getUrlEncodingClassMeta(pMeta.getBeanMeta().getClassMeta()).isExpandedParams());
    }

    private boolean shouldUseExpandedParams(Object value) {
        if (value == null || !this.isExpandedParams()) {
            return false;
        }
        ClassMeta<?> cm = this.getClassMetaForObject(value).getSerializedClassMeta(this);
        return cm.isCollectionOrArray() && this.isExpandedParams();
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws IOException, SerializeException {
        this.serializeAnything(this.getUonWriter(out).i(this.getInitialDepth()), o);
    }

    protected UrlEncodingClassMeta getUrlEncodingClassMeta(ClassMeta<?> cm) {
        return this.ctx.getUrlEncodingClassMeta(cm);
    }

    protected final boolean isExpandedParams() {
        return this.ctx.isExpandedParams();
    }

    public static class Builder
    extends UonSerializerSession.Builder {
        private UrlEncodingSerializer ctx;

        protected Builder(UrlEncodingSerializer ctx) {
            super(ctx);
            this.ctx = ctx;
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public UrlEncodingSerializerSession build() {
            return new UrlEncodingSerializerSession(this);
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder resolver(VarResolverSession value) {
            super.resolver(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder useWhitespace(Boolean value) {
            super.useWhitespace(value);
            return this;
        }
    }
}

