/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.ContextSession;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.lang.IntegerValue;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.BeanRuntimeException;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.swap.ObjectSwap;

public class BeanSession
extends ContextSession {
    private static Logger LOG = Logger.getLogger(Utils.cn(BeanSession.class));
    private final BeanContext ctx;
    private final Locale locale;
    private final MediaType mediaType;
    private final TimeZone timeZone;

    public static Builder create(BeanContext ctx) {
        return new Builder((BeanContext)AssertionUtils.assertArgNotNull((String)"ctx", (Object)ctx));
    }

    public static final String getNamePropertyName() {
        return "_name";
    }

    private static int getMultiplier(String s) {
        if (s.endsWith("G")) {
            return 0x40000000;
        }
        if (s.endsWith("M")) {
            return 0x100000;
        }
        if (s.endsWith("K")) {
            return 1024;
        }
        return 1;
    }

    private static boolean hasMutater(ClassMeta<?> from, ClassMeta<?> to) {
        return to.hasMutaterFrom(from) || from.hasMutaterTo(to);
    }

    private static final boolean isNullOrEmpty(Object o) {
        return o == null || o.toString().isEmpty() || o.toString().equals("null");
    }

    protected BeanSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
        this.locale = Utils.opt((Object)builder.locale).orElse(this.ctx.getLocale());
        this.mediaType = Utils.opt((Object)builder.mediaType).orElse(builder.mediaType);
        this.timeZone = Utils.opt((Object)builder.timeZone).orElse(builder.timeZone);
    }

    @Override
    public void addWarning(String msg, Object ... args) {
        if (this.isDebug()) {
            LOG.log(Level.WARNING, () -> args.length == 0 ? msg : Utils.f((String)msg, (Object[])args));
        }
        super.addWarning(msg, args);
    }

    public final <T> T convertToMemberType(Object outer, Object value, Class<T> type) throws InvalidDataConversionException {
        return this.convertToMemberType(outer, value, this.getClassMeta(type));
    }

    public final <T> T convertToType(Object value, Class<T> type) throws InvalidDataConversionException {
        if (Utils.nn((Object)value) && value.getClass() == type) {
            return (T)value;
        }
        return this.convertToMemberType(null, value, this.getClassMeta(type));
    }

    public final <T> T convertToType(Object value, ClassMeta<T> type) throws InvalidDataConversionException {
        return this.convertToMemberType(null, value, type);
    }

    public final <T> T convertToType(Object value, Type type, Type ... args) throws InvalidDataConversionException {
        return this.convertToMemberType(null, value, this.getClassMeta(type, args));
    }

    public AnnotationProvider getAnnotationProvider() {
        return this.ctx.getAnnotationProvider();
    }

    public final Visibility getBeanClassVisibility() {
        return this.ctx.getBeanClassVisibility();
    }

    public final Visibility getBeanConstructorVisibility() {
        return this.ctx.getBeanConstructorVisibility();
    }

    public final List<ClassInfo> getBeanDictionary() {
        return this.ctx.getBeanDictionary();
    }

    public final Visibility getBeanFieldVisibility() {
        return this.ctx.getBeanFieldVisibility();
    }

    public final <T> BeanMeta<T> getBeanMeta(Class<T> c) {
        if (c == null) {
            return null;
        }
        return this.getClassMeta(c).getBeanMeta();
    }

    public final Visibility getBeanMethodVisibility() {
        return this.ctx.getBeanMethodVisibility();
    }

    public final BeanRegistry getBeanRegistry() {
        return this.ctx.getBeanRegistry();
    }

    public final String getBeanTypePropertyName() {
        return this.ctx.getBeanTypePropertyName();
    }

    public final String getBeanTypePropertyName(ClassMeta cm) {
        if (cm == null) {
            return this.getBeanTypePropertyName();
        }
        BeanMeta beanMeta = cm.getBeanMeta();
        if (beanMeta == null) {
            return this.getBeanTypePropertyName();
        }
        String s = beanMeta.getTypePropertyName();
        return s == null ? this.getBeanTypePropertyName() : s;
    }

    public final <T> ClassMeta<T> getClassMeta(Class<T> c) {
        return this.ctx.getClassMeta(c);
    }

    public final <T> ClassMeta<T> getClassMeta(Type type, Type ... args) {
        return this.ctx.getClassMeta(type, args);
    }

    public final <T> ClassMeta<T> getClassMetaForObject(T o) {
        return this.getClassMetaForObject(o, null);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public final MediaType getMediaType() {
        return this.mediaType;
    }

    public final List<ClassInfo> getNotBeanClasses() {
        return this.ctx.getNotBeanClasses();
    }

    public final Set<String> getNotBeanPackagesNames() {
        return this.ctx.getNotBeanPackagesNames();
    }

    public final PropertyNamer getPropertyNamer() {
        return this.ctx.getPropertyNamer();
    }

    public final List<ObjectSwap<?, ?>> getSwaps() {
        return this.ctx.getSwaps();
    }

    public final TimeZone getTimeZone() {
        return this.timeZone;
    }

    public final ZoneId getTimeZoneId() {
        return this.timeZone == null ? ZoneId.systemDefault() : this.timeZone.toZoneId();
    }

    public final boolean isBean(Class<?> c) {
        return Utils.nn(this.getBeanMeta(c));
    }

    public final boolean isBean(Object o) {
        if (o == null) {
            return false;
        }
        return this.isBean(o.getClass());
    }

    public final boolean isBeanMapPutReturnsOldValue() {
        return this.ctx.isBeanMapPutReturnsOldValue();
    }

    public final boolean isBeansRequireDefaultConstructor() {
        return this.ctx.isBeansRequireDefaultConstructor();
    }

    public final boolean isBeansRequireSerializable() {
        return this.ctx.isBeansRequireSerializable();
    }

    public final boolean isBeansRequireSettersForGetters() {
        return this.ctx.isBeansRequireSettersForGetters();
    }

    public final boolean isBeansRequireSomeProperties() {
        return this.ctx.isBeansRequireSomeProperties();
    }

    public final boolean isFindFluentSetters() {
        return this.ctx.isFindFluentSetters();
    }

    public final boolean isIgnoreInvocationExceptionsOnGetters() {
        return this.ctx.isIgnoreInvocationExceptionsOnGetters();
    }

    public final boolean isIgnoreInvocationExceptionsOnSetters() {
        return this.ctx.isIgnoreInvocationExceptionsOnSetters();
    }

    public final boolean isIgnoreMissingSetters() {
        return this.ctx.isIgnoreMissingSetters();
    }

    public final boolean isIgnoreUnknownBeanProperties() {
        return this.ctx.isIgnoreUnknownBeanProperties();
    }

    public final boolean isIgnoreUnknownNullBeanProperties() {
        return this.ctx.isIgnoreUnknownNullBeanProperties();
    }

    public final boolean isSortProperties() {
        return this.ctx.isSortProperties();
    }

    public final boolean isUseEnumNames() {
        return this.ctx.isUseEnumNames();
    }

    public final boolean isUseInterfaceProxies() {
        return this.ctx.isUseInterfaceProxies();
    }

    public final boolean isUseJavaBeanIntrospector() {
        return this.ctx.isUseJavaBeanIntrospector();
    }

    public final <T> T newBean(Class<T> c) throws BeanRuntimeException {
        return this.newBean(null, c);
    }

    public final <T> T newBean(Object outer, Class<T> c) throws BeanRuntimeException {
        ClassMeta<T> cm = this.getClassMeta(c);
        BeanMeta<T> m = cm.getBeanMeta();
        if (m == null) {
            return null;
        }
        try {
            T o = m.newBean(outer);
            if (o == null) {
                throw ThrowableUtils.bex(c, (String)"Class does not have a no-arg constructor.", (Object[])new Object[0]);
            }
            return o;
        }
        catch (BeanRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ThrowableUtils.bex((Throwable)e);
        }
    }

    public final <T> BeanMap<T> newBeanMap(Class<T> c) {
        return this.newBeanMap(null, c);
    }

    public final <T> BeanMap<T> newBeanMap(Object outer, Class<T> c) {
        BeanMeta<T> m = this.getBeanMeta(c);
        if (m == null) {
            return null;
        }
        Object bean = null;
        if (Utils.e(m.getConstructorArgs())) {
            bean = this.newBean(outer, c);
        }
        return new BeanMap<Object>(this, bean, (BeanMeta<Object>)m);
    }

    public final ClassMeta<Object> object() {
        return this.ctx.object();
    }

    public final ClassMeta<String> string() {
        return this.ctx.string();
    }

    public final <T> BeanMap<T> toBeanMap(T o) {
        if (o instanceof BeanMap) {
            BeanMap o2 = (BeanMap)o;
            return o2;
        }
        return this.toBeanMap(o, o.getClass());
    }

    public final <T> BeanMap<T> toBeanMap(T o, Class<? super T> c) throws BeanRuntimeException {
        AssertionUtils.assertArgNotNull((String)"o", o);
        AssertionUtils.assertArgNotNull((String)"c", c);
        AssertionUtils.assertArg((boolean)c.isInstance(o), (String)"The specified object is not an instance of the specified class.  class=''{0}'', objectClass=''{1}'', object=''{2}''", (Object[])new Object[]{Utils.cn(c), Utils.cn(o), 0});
        ClassMeta<T> cm = this.getClassMeta(c);
        BeanMeta<? super T> m = cm.getBeanMeta();
        if (m == null) {
            throw ThrowableUtils.bex(c, (String)"Class is not a bean.  Reason=''{0}''", (Object[])new Object[]{cm.getNotABeanReason()});
        }
        return new BeanMap<T>(this, o, m);
    }

    public final <T> BeanMap<T> toBeanMap(T o, PropertyNamer propertyNamer) {
        return this.toBeanMap(o, o.getClass());
    }

    /*
     * Exception decompiling
     */
    protected final <T> T convertToMemberType(Object outer, Object value, ClassMeta<T> to) throws InvalidDataConversionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final ClassMeta<Object[]> getArgsClassMeta(Type[] classes) {
        AssertionUtils.assertArgNotNull((String)"classes", (Object)classes);
        return new ClassMeta<Object[]>(Arrays.stream(classes).map(x -> this.getClassMeta((Type)x, new Type[0])).toList());
    }

    protected final ClassMeta<?> getClassMetaForObject(Object o, ClassMeta<?> def) {
        if (o == null) {
            return def;
        }
        return this.getClassMeta(o.getClass());
    }

    protected Map newGenericMap(ClassMeta mapMeta) {
        ClassMeta<?> k = mapMeta.getKeyType();
        return k == null || k.isString() ? new JsonMap(this) : CollectionUtils.map();
    }

    @Override
    protected FluentMap<String, Object> properties() {
        return super.properties().a((Object)"locale", (Object)this.locale).a((Object)"mediaType", (Object)this.mediaType).a((Object)"timeZone", (Object)this.timeZone);
    }

    protected final Object toArray(ClassMeta<?> type, Collection<?> list) {
        if (list == null) {
            return null;
        }
        ClassMeta<Object> componentType = type.isArgs() ? this.object() : type.getElementType();
        Object array = Array.newInstance(componentType.inner(), list.size());
        IntegerValue i = IntegerValue.create();
        list.forEach(x -> {
            Object x2 = x;
            if (!type.isInstance(x)) {
                if (componentType.isArray() && x instanceof Collection) {
                    Collection c = (Collection)x;
                    x2 = this.toArray(componentType, c);
                } else {
                    x2 = x == null && componentType.isPrimitive() ? componentType.getPrimitiveDefault() : this.convertToType(x, componentType);
                }
            }
            Array.set(array, i.getAndIncrement(), x2);
        });
        return array;
    }

    private /* synthetic */ void lambda$convertToMemberType$3(Collection l, ClassMeta elementType, Object x) {
        l.add(elementType.isObject() ? x : this.convertToMemberType((Object)l, x, elementType));
    }

    private /* synthetic */ void lambda$convertToMemberType$2(Collection l, ClassMeta elementType, Object x) {
        l.add(elementType.isObject() ? x : this.convertToMemberType((Object)l, x, elementType));
    }

    private /* synthetic */ void lambda$convertToMemberType$1(ClassMeta keyType, Map m, ClassMeta valueType, Object k, Object v) {
        Object k2 = k;
        if (!keyType.isObject()) {
            k2 = keyType.isString() && k.getClass() != Class.class ? k.toString() : this.convertToMemberType((Object)m, k, keyType);
        }
        Object v2 = v;
        if (!valueType.isObject()) {
            v2 = this.convertToMemberType((Object)m, v, valueType);
        }
        m.put(k2, v2);
    }

    public static class Builder
    extends ContextSession.Builder {
        private BeanContext ctx;
        private Locale locale;
        private MediaType mediaType;
        private TimeZone timeZone;

        protected Builder(BeanContext ctx) {
            super((Context)AssertionUtils.assertArgNotNull((String)"ctx", (Object)ctx));
            this.ctx = ctx;
            this.mediaType = ctx.getMediaType();
            this.timeZone = ctx.getTimeZone();
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply(type, apply);
            return this;
        }

        @Override
        public BeanSession build() {
            return new BeanSession(this);
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        public Builder locale(Locale value) {
            this.locale = value;
            return this;
        }

        public Builder mediaType(MediaType value) {
            this.mediaType = value;
            return this;
        }

        public Builder mediaTypeDefault(MediaType value) {
            if (this.mediaType == null) {
                this.mediaType = value;
            }
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties(value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        public Builder timeZone(TimeZone value) {
            this.timeZone = value;
            return this;
        }

        public Builder timeZoneDefault(TimeZone value) {
            if (this.timeZone == null) {
                this.timeZone = value;
            }
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }
    }
}

