/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.lang.AsciiSet;
import org.apache.juneau.commons.lang.Flag;
import org.apache.juneau.commons.lang.StateEnum;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.svl.Var;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverException;

public class VarResolverSession {
    private static final AsciiSet AS1 = AsciiSet.of((String)"\\{");
    private static final AsciiSet AS2 = AsciiSet.of((String)"\\${}");
    private final VarResolver context;
    private final BeanStore beanStore;

    private static boolean containsVars(Collection<?> c) {
        Flag f = Flag.create();
        c.forEach(x -> {
            if (x instanceof CharSequence && x.toString().contains("$")) {
                f.set();
            }
        });
        return f.isSet();
    }

    private static boolean containsVars(Map<?, ?> m) {
        Flag f = Flag.create();
        m.forEach((k, v) -> {
            if (v instanceof CharSequence && v.toString().contains("$")) {
                f.set();
            }
        });
        return f.isSet();
    }

    private static boolean containsVars(Object array) {
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object o = Array.get(array, i);
            if (!(o instanceof CharSequence) || !o.toString().contains("$")) continue;
            return true;
        }
        return false;
    }

    private static boolean isSimpleVar(String s) {
        int length = s.length();
        StateEnum state = StateEnum.S1;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (state == StateEnum.S1) {
                if (c == '$') {
                    state = StateEnum.S2;
                    continue;
                }
                return false;
            }
            if (state == StateEnum.S2) {
                if (c == '{') {
                    state = StateEnum.S3;
                    continue;
                }
                if (c >= 'A' && c <= 'z' && (c <= 'Z' || c >= 'a')) continue;
                return false;
            }
            if (state == StateEnum.S3) {
                if (c == '}') {
                    state = StateEnum.S4;
                    continue;
                }
                if (c != '{' && c != '$') continue;
                return false;
            }
            if (state != StateEnum.S4) continue;
            return false;
        }
        return state == StateEnum.S4;
    }

    public VarResolverSession(VarResolver context, BeanStore beanStore) {
        this.context = context;
        this.beanStore = BeanStore.of(beanStore);
    }

    public <T> VarResolverSession bean(Class<T> c, T value) {
        this.beanStore.addBean(c, value);
        return this;
    }

    public <T> Optional<T> getBean(Class<T> c) {
        Optional<T> t = this.beanStore.getBean(c);
        if (!t.isPresent()) {
            t = this.context.beanStore.getBean(c);
        }
        return t;
    }

    public String resolve(String s) {
        if (s == null || s.isEmpty() || s.indexOf(36) == -1 && s.indexOf(92) == -1) {
            return s;
        }
        if (VarResolverSession.isSimpleVar(s)) {
            String var = s.substring(1, s.indexOf(123));
            String val = s.substring(s.indexOf(123) + 1, s.length() - 1);
            Var v = this.getVar(var);
            if (Utils.nn((Object)v)) {
                try {
                    if (v.streamed) {
                        StringWriter sw = new StringWriter();
                        v.resolveTo(this, sw, val);
                        return sw.toString();
                    }
                    s = v.doResolve(this, val);
                    if (s == null) {
                        s = "";
                    }
                    return v.allowRecurse() ? this.resolve(s) : s;
                }
                catch (VarResolverException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new VarResolverException(e, "Problem occurred resolving variable ''{0}'' in string ''{1}''", var, s);
                }
            }
            return s;
        }
        try {
            return this.resolveTo(s, new StringWriter()).toString();
        }
        catch (IOException e) {
            throw ThrowableUtils.toRex((Throwable)e);
        }
    }

    public String[] resolve(String[] in) {
        String[] out = new String[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = this.resolve(in[i]);
        }
        return out;
    }

    public <T> T resolve(T o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CharSequence) {
            CharSequence o2 = (CharSequence)o;
            return (T)this.resolve(o2.toString());
        }
        if (Utils.isArray(o)) {
            if (!VarResolverSession.containsVars(o)) {
                return o;
            }
            Object o2 = Array.newInstance(o.getClass().getComponentType(), Array.getLength(o));
            for (int i = 0; i < Array.getLength(o); ++i) {
                Array.set(o2, i, this.resolve(Array.get(o, i)));
            }
            return (T)o2;
        }
        if (o instanceof Set) {
            Set o2 = (Set)o;
            try {
                Set o3;
                if (!VarResolverSession.containsVars(o2)) {
                    return o;
                }
                Set o4 = o3 = ReflectionUtils.info(o).getDeclaredConstructor(x -> x.isPublic() && x.getParameterCount() == 0).map(ci -> (Set)Utils.safe(() -> (Set)ci.inner().newInstance(new Object[0]))).orElseGet(LinkedHashSet::new);
                o2.forEach(x -> o4.add(this.resolve(x)));
                return (T)o3;
            }
            catch (VarResolverException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VarResolverException(e, "Problem occurred resolving set.", new Object[0]);
            }
        }
        if (o instanceof List) {
            List o2 = (List)o;
            try {
                List o3;
                if (!VarResolverSession.containsVars(o2)) {
                    return o;
                }
                List o4 = o3 = ReflectionUtils.info(o).getDeclaredConstructor(x -> x.isPublic() && x.getParameterCount() == 0).map(ci -> (List)Utils.safe(() -> (List)ci.inner().newInstance(new Object[0]))).orElseGet(() -> CollectionUtils.list((Object[])new Object[0]));
                o2.forEach(x -> o4.add(this.resolve(x)));
                return (T)o3;
            }
            catch (VarResolverException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VarResolverException(e, "Problem occurred resolving collection.", new Object[0]);
            }
        }
        if (o instanceof Map) {
            Map o2 = (Map)o;
            try {
                Map o3;
                if (!VarResolverSession.containsVars(o2)) {
                    return o;
                }
                Map o4 = o3 = ReflectionUtils.info(o).getDeclaredConstructor(x -> x.isPublic() && x.getParameterCount() == 0).map(ci -> (Map)Utils.safe(() -> (Map)ci.inner().newInstance(new Object[0]))).orElseGet(LinkedHashMap::new);
                o2.forEach((k, v) -> o4.put(k, this.resolve(v)));
                return (T)o3;
            }
            catch (VarResolverException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VarResolverException(e, "Problem occurred resolving map.", new Object[0]);
            }
        }
        return o;
    }

    public Writer resolveTo(String s, Writer out) throws IOException {
        StateEnum state = StateEnum.S1;
        boolean isInEscape = false;
        boolean hasInternalVar = false;
        boolean hasInnerEscapes = false;
        String varType = null;
        String varVal = null;
        int x = 0;
        int x2 = 0;
        int depth = 0;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (state == StateEnum.S1) {
                if (isInEscape) {
                    if (c == '\\' || c == '$') {
                        out.append(c);
                    } else {
                        out.append('\\').append(c);
                    }
                    isInEscape = false;
                    continue;
                }
                if (c == '\\') {
                    isInEscape = true;
                    continue;
                }
                if (c == '$') {
                    x = i;
                    x2 = i;
                    state = StateEnum.S2;
                    continue;
                }
                out.append(c);
                continue;
            }
            if (state == StateEnum.S2) {
                if (isInEscape) {
                    isInEscape = false;
                    continue;
                }
                if (c == '\\') {
                    hasInnerEscapes = true;
                    isInEscape = true;
                    continue;
                }
                if (c == '{') {
                    varType = s.substring(x + 1, i);
                    x = i;
                    state = StateEnum.S3;
                    continue;
                }
                if (c >= 'A' && c <= 'z' && (c <= 'Z' || c >= 'a')) continue;
                if (hasInnerEscapes) {
                    out.append(StringUtils.unescapeChars((String)s.substring(x, i + 1), (AsciiSet)AS1));
                } else {
                    out.append(s, x, i + 1);
                }
                x = i + 1;
                state = StateEnum.S1;
                hasInnerEscapes = false;
                continue;
            }
            if (state != StateEnum.S3) continue;
            if (isInEscape) {
                isInEscape = false;
                continue;
            }
            if (c == '\\') {
                isInEscape = true;
                hasInnerEscapes = true;
                continue;
            }
            if (c == '{') {
                ++depth;
                hasInternalVar = true;
                continue;
            }
            if (c != '}') continue;
            if (depth > 0) {
                --depth;
                continue;
            }
            varVal = s.substring(x + 1, i);
            Var r = this.getVar(varType);
            if (r == null) {
                if (hasInnerEscapes) {
                    out.append(StringUtils.unescapeChars((String)s.substring(x2, i + 1), (AsciiSet)AS2));
                } else {
                    out.append(s, x2, i + 1);
                }
                x = i + 1;
            } else {
                varVal = hasInternalVar && r.allowNested() ? this.resolve(varVal) : varVal;
                try {
                    if (r.streamed) {
                        r.resolveTo(this, out, varVal);
                    } else {
                        String replacement = r.doResolve(this, varVal);
                        if (replacement == null) {
                            replacement = "";
                        }
                        if (replacement.indexOf(36) != -1 && r.allowRecurse()) {
                            replacement = this.resolve(replacement);
                        }
                        out.append(replacement);
                    }
                }
                catch (VarResolverException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new VarResolverException(e, "Problem occurred resolving variable ''{0}'' in string ''{1}''", varType, s);
                }
                x = i + 1;
            }
            state = StateEnum.S1;
            hasInnerEscapes = false;
        }
        if (isInEscape) {
            out.append('\\');
        } else if (state == StateEnum.S2) {
            out.append('$').append(StringUtils.unescapeChars((String)s.substring(x + 1), (AsciiSet)AS1));
        } else if (state == StateEnum.S3) {
            out.append('$').append(varType).append('{').append(StringUtils.unescapeChars((String)s.substring(x + 1), (AsciiSet)AS2));
        }
        return out;
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a((Object)"context.beanStore", (Object)this.context.beanStore).a((Object)"var", this.context.getVarMap().keySet()).a((Object)"session.beanStore", (Object)this.beanStore);
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    protected Var getVar(String name) {
        Var v = this.context.getVarMap().get(name);
        return Utils.nn((Object)v) && v.canResolve(this) ? v : null;
    }
}

