/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.List;
import java.util.Set;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.ClassUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.swap.BeanInterceptor;

public class BeanFilter {
    private final ClassInfoTyped<?> beanClass;
    private final List<ClassInfo> beanDictionary;
    private final String example;
    private final Set<String> excludeProperties;
    private final boolean fluentSetters;
    private final ClassInfo implClass;
    private final ClassInfo interfaceClass;
    private final BeanInterceptor interceptor;
    private final Set<String> properties;
    private final PropertyNamer propertyNamer;
    private final Set<String> readOnlyProperties;
    private final boolean sortProperties;
    private final ClassInfo stopClass;
    private final String typeName;
    private final Set<String> writeOnlyProperties;

    public static <T> Builder create(ClassInfoTyped<T> beanClass) {
        return new Builder(beanClass);
    }

    BeanFilter(Builder builder) {
        this.beanClass = builder.beanClass;
        this.typeName = builder.typeName;
        this.properties = CollectionUtils.copyOf(builder.properties);
        this.excludeProperties = CollectionUtils.copyOf(builder.excludeProperties);
        this.readOnlyProperties = CollectionUtils.copyOf(builder.readOnlyProperties);
        this.writeOnlyProperties = CollectionUtils.copyOf(builder.writeOnlyProperties);
        this.example = builder.example;
        this.implClass = builder.implClass;
        this.interfaceClass = builder.interfaceClass;
        this.stopClass = builder.stopClass;
        this.sortProperties = builder.sortProperties;
        this.fluentSetters = builder.fluentSetters;
        this.propertyNamer = builder.propertyNamer.orElse(null);
        this.beanDictionary = builder.dictionary == null ? CollectionUtils.list(new ClassInfo[0]) : CollectionUtils.u(CollectionUtils.copyOf(builder.dictionary));
        this.interceptor = builder.interceptor.orElse(BeanInterceptor.DEFAULT);
    }

    public ClassInfoTyped<?> getBeanClass() {
        return this.beanClass;
    }

    public List<ClassInfo> getBeanDictionary() {
        return this.beanDictionary;
    }

    public String getExample() {
        return this.example;
    }

    public Set<String> getExcludeProperties() {
        return this.excludeProperties;
    }

    public ClassInfo getImplClass() {
        return this.implClass;
    }

    public ClassInfo getInterfaceClass() {
        return this.interfaceClass;
    }

    public Set<String> getProperties() {
        return this.properties;
    }

    public PropertyNamer getPropertyNamer() {
        return this.propertyNamer;
    }

    public Set<String> getReadOnlyProperties() {
        return this.readOnlyProperties;
    }

    public ClassInfo getStopClass() {
        return this.stopClass;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Set<String> getWriteOnlyProperties() {
        return this.writeOnlyProperties;
    }

    public boolean isFluentSetters() {
        return this.fluentSetters;
    }

    public boolean isSortProperties() {
        return this.sortProperties;
    }

    public Object readProperty(Object bean, String name, Object value) {
        return this.interceptor.readProperty(bean, name, value);
    }

    public Object writeProperty(Object bean, String name, Object value) {
        return this.interceptor.writeProperty(bean, name, value);
    }

    public static class Builder {
        private ClassInfoTyped<?> beanClass;
        private String typeName;
        private String example;
        private Set<String> properties = CollectionUtils.set(new String[0]);
        private Set<String> excludeProperties = CollectionUtils.set(new String[0]);
        private Set<String> readOnlyProperties = CollectionUtils.set(new String[0]);
        private Set<String> writeOnlyProperties = CollectionUtils.set(new String[0]);
        private ClassInfo implClass;
        private ClassInfo interfaceClass;
        private ClassInfo stopClass;
        private boolean sortProperties;
        private boolean fluentSetters;
        private BeanCreator<PropertyNamer> propertyNamer = BeanCreator.of(PropertyNamer.class);
        private List<ClassInfo> dictionary;
        private BeanCreator<BeanInterceptor> interceptor = BeanCreator.of(BeanInterceptor.class);

        protected Builder(ClassInfoTyped<?> beanClass) {
            this.beanClass = beanClass;
        }

        public Builder applyAnnotations(List<Bean> annotations) {
            annotations.forEach(x -> {
                if (StringUtils.isAnyNotEmpty(x.properties(), x.p())) {
                    this.properties(x.properties(), x.p());
                }
                if (x.sort()) {
                    this.sortProperties(true);
                }
                if (x.findFluentSetters()) {
                    this.findFluentSetters();
                }
                if (StringUtils.isAnyNotEmpty(x.excludeProperties(), x.xp())) {
                    this.excludeProperties(x.excludeProperties(), x.xp());
                }
                if (StringUtils.isAnyNotEmpty(x.readOnlyProperties(), x.ro())) {
                    this.readOnlyProperties(x.readOnlyProperties(), x.ro());
                }
                if (StringUtils.isAnyNotEmpty(x.writeOnlyProperties(), x.wo())) {
                    this.writeOnlyProperties(x.writeOnlyProperties(), x.wo());
                }
                if (Utils.ne(x.typeName())) {
                    this.typeName(x.typeName());
                }
                if (ClassUtils.isNotVoid(x.propertyNamer())) {
                    this.propertyNamer(x.propertyNamer());
                }
                if (ClassUtils.isNotVoid(x.interfaceClass())) {
                    this.interfaceClass(x.interfaceClass());
                }
                if (ClassUtils.isNotVoid(x.stopClass())) {
                    this.stopClass(x.stopClass());
                }
                if (ClassUtils.isNotVoid(x.interceptor())) {
                    this.interceptor(x.interceptor());
                }
                if (ClassUtils.isNotVoid(x.implClass())) {
                    this.implClass(x.implClass());
                }
                if (CollectionUtils.isNotEmptyArray(x.dictionary())) {
                    this.dictionary(x.dictionary());
                }
                if (Utils.ne(x.example())) {
                    this.example(x.example());
                }
            });
            return this;
        }

        public BeanFilter build() {
            return new BeanFilter(this);
        }

        public Builder dictionary(Class<?> ... values) {
            if (this.dictionary == null) {
                this.dictionary = CollectionUtils.list(new ClassInfo[0]);
            }
            for (Class<?> cc : values) {
                this.dictionary.add(ReflectionUtils.info(cc));
            }
            return this;
        }

        public Builder dictionary(ClassInfo ... values) {
            if (this.dictionary == null) {
                this.dictionary = CollectionUtils.list(new ClassInfo[0]);
            }
            for (ClassInfo ci : values) {
                this.dictionary.add(ci);
            }
            return this;
        }

        public Builder example(String value) {
            this.example = value;
            return this;
        }

        public Builder excludeProperties(String ... value) {
            this.excludeProperties = CollectionUtils.set(new String[0]);
            for (String v : value) {
                StringUtils.split(v, x -> this.excludeProperties.add((String)x));
            }
            return this;
        }

        public Builder findFluentSetters() {
            this.fluentSetters = true;
            return this;
        }

        public Builder implClass(Class<?> value) {
            this.implClass = value == null ? null : ReflectionUtils.info(value);
            return this;
        }

        public Builder implClass(ClassInfo value) {
            this.implClass = value;
            return this;
        }

        public Builder interceptor(Class<?> value) {
            this.interceptor.type(value);
            return this;
        }

        public Builder interceptor(ClassInfo value) {
            this.interceptor.type(value);
            return this;
        }

        public Builder interfaceClass(Class<?> value) {
            this.interfaceClass = value == null ? null : ReflectionUtils.info(value);
            return this;
        }

        public Builder interfaceClass(ClassInfo value) {
            this.interfaceClass = value;
            return this;
        }

        public Builder properties(String ... value) {
            this.properties = CollectionUtils.set(new String[0]);
            for (String v : value) {
                StringUtils.split(v, x -> this.properties.add((String)x));
            }
            return this;
        }

        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            this.propertyNamer.type(value);
            return this;
        }

        public Builder propertyNamer(ClassInfoTyped<? extends PropertyNamer> value) {
            this.propertyNamer.type(value);
            return this;
        }

        public Builder readOnlyProperties(String ... value) {
            this.readOnlyProperties = CollectionUtils.set(new String[0]);
            for (String v : value) {
                StringUtils.split(v, x -> this.readOnlyProperties.add((String)x));
            }
            return this;
        }

        public Builder sortProperties() {
            this.sortProperties = true;
            return this;
        }

        public Builder sortProperties(boolean value) {
            this.sortProperties = value;
            return this;
        }

        public Builder stopClass(Class<?> value) {
            this.stopClass = value == null ? null : ReflectionUtils.info(value);
            return this;
        }

        public Builder stopClass(ClassInfo value) {
            this.stopClass = value;
            return this;
        }

        public Builder typeName(String value) {
            this.typeName = value;
            return this;
        }

        public Builder writeOnlyProperties(String ... value) {
            this.writeOnlyProperties = CollectionUtils.set(new String[0]);
            for (String v : value) {
                StringUtils.split(v, x -> this.writeOnlyProperties.add((String)x));
            }
            return this;
        }
    }
}

