/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.impl.jline;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import jline.Terminal;
import org.fusesource.jansi.AnsiConsole;

final class StreamWrapUtil {
    private StreamWrapUtil() {
    }

    private static Object invokePrivateMethod(Object o, String methodName, Object[] params) throws Exception {
        Method[] methods = o.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            methods[i].setAccessible(true);
            return methods[i].invoke(o, params);
        }
        return o;
    }

    private static <T> T unwrapBIS(T stream) {
        try {
            return (T)StreamWrapUtil.invokePrivateMethod(stream, "getInIfOpen", null);
        }
        catch (Throwable t) {
            return stream;
        }
    }

    private static PrintStream wrap(PrintStream stream) {
        OutputStream o = AnsiConsole.wrapOutputStream((OutputStream)stream);
        if (o instanceof PrintStream) {
            return (PrintStream)o;
        }
        return new PrintStream(o);
    }

    private static <T> T unwrap(T stream) {
        try {
            Method mth = stream.getClass().getMethod("getRoot", new Class[0]);
            return (T)mth.invoke(stream, new Object[0]);
        }
        catch (Throwable t) {
            return stream;
        }
    }

    static InputStream reWrapIn(Terminal terminal, InputStream stream) {
        try {
            return terminal.wrapInIfNeeded(StreamWrapUtil.unwrapBIS(StreamWrapUtil.unwrap(stream)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static PrintStream reWrap(PrintStream stream) {
        return StreamWrapUtil.wrap(StreamWrapUtil.unwrap(stream));
    }
}

