/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.core.queries.CoreAttributeItem;
import org.eclipse.persistence.core.sessions.CoreSession;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.Context;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.XMLRelationshipMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.oxm.mappings.AnyObjectMapping;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.XMLRecord;
import org.eclipse.persistence.internal.oxm.record.deferred.AnyMappingContentHandler;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLAnyObjectMappingNodeValue
extends XMLRelationshipMappingNodeValue {
    private AnyObjectMapping xmlAnyObjectMapping;

    public XMLAnyObjectMappingNodeValue(AnyObjectMapping xmlAnyObjectMapping) {
        this.xmlAnyObjectMapping = xmlAnyObjectMapping;
    }

    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        return xPathFragment == null;
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        return this.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (this.xmlAnyObjectMapping.isReadOnly()) {
            return false;
        }
        Object objectValue = marshalContext.getAttributeValue(object, this.xmlAnyObjectMapping);
        return this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, marshalContext);
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object objectValue, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        XPathFragment rootFragment = null;
        Object marshaller = marshalRecord.getMarshaller();
        if ((objectValue = this.xmlAnyObjectMapping.convertObjectValueToDataValue(objectValue, session, marshalRecord.getMarshaller())) == null) {
            return false;
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        boolean wasXMLRoot = false;
        XPathFragment xmlRootFragment = null;
        Object originalValue = objectValue;
        if (this.xmlAnyObjectMapping.usesXMLRoot() && objectValue instanceof Root) {
            xmlRootFragment = new XPathFragment();
            xmlRootFragment.setNamespaceAware(marshalRecord.isNamespaceAware());
            wasXMLRoot = true;
            objectValue = ((Root)objectValue).getObject();
            if (objectValue == null) {
                this.setupFragment((Root)originalValue, xmlRootFragment, marshalRecord);
                marshalRecord.nilComplex(xmlRootFragment, namespaceResolver);
                return true;
            }
        }
        if (objectValue instanceof String) {
            this.marshalSimpleValue(xmlRootFragment, marshalRecord, originalValue, object, objectValue, session, namespaceResolver);
        } else {
            CoreSession childSession = null;
            try {
                childSession = (CoreSession)((Context)((Marshaller)marshaller).getContext()).getSession(objectValue);
            }
            catch (XMLMarshalException e) {
                this.marshalSimpleValue(xmlRootFragment, marshalRecord, originalValue, object, objectValue, session, namespaceResolver);
                return true;
            }
            Descriptor descriptor = (Descriptor)childSession.getDescriptor(objectValue);
            CoreAttributeGroup group = marshalRecord.getCurrentAttributeGroup();
            Object item = group.getItem(this.getMapping().getAttributeName());
            CoreAttributeGroup nestedGroup = XMLRecord.DEFAULT_ATTRIBUTE_GROUP;
            if (item != null) {
                if (((CoreAttributeItem)item).getGroups() != null) {
                    nestedGroup = ((CoreAttributeItem)item).getGroup(descriptor.getJavaClass());
                }
                if (nestedGroup == null) {
                    nestedGroup = ((CoreAttributeItem)item).getGroup() == null ? XMLRecord.DEFAULT_ATTRIBUTE_GROUP : ((CoreAttributeItem)item).getGroup();
                }
            }
            marshalRecord.pushAttributeGroup(nestedGroup);
            ObjectBuilder objectBuilder = (ObjectBuilder)descriptor.getObjectBuilder();
            List extraNamespaces = objectBuilder.addExtraNamespacesToNamespaceResolver(descriptor, marshalRecord, session, true, true);
            if (wasXMLRoot) {
                this.setupFragment((Root)originalValue, xmlRootFragment, marshalRecord);
            }
            String defaultRootElementString = descriptor.getDefaultRootElement();
            if (!wasXMLRoot && defaultRootElementString == null) {
                throw XMLMarshalException.defaultRootElementNotSpecified(descriptor);
            }
            marshalRecord.beforeContainmentMarshal(objectValue);
            if (xmlRootFragment != null) {
                rootFragment = xmlRootFragment;
            } else {
                rootFragment = new XPathFragment(defaultRootElementString);
                if (rootFragment.getNamespaceURI() == null) {
                    if (rootFragment.getPrefix() != null) {
                        String uri = ((NamespaceResolver)descriptor.getNonNullNamespaceResolver()).resolveNamespacePrefix(rootFragment.getPrefix());
                        rootFragment.setNamespaceURI(uri);
                    } else {
                        rootFragment.setNamespaceURI(((NamespaceResolver)descriptor.getNonNullNamespaceResolver()).getDefaultNamespaceURI());
                    }
                }
            }
            if (!wasXMLRoot) {
                marshalRecord.setLeafElementType(descriptor.getDefaultRootElementType());
            }
            this.getXPathNode().startElement(marshalRecord, rootFragment, object, session, (NamespaceResolver)descriptor.getNonNullNamespaceResolver(), objectBuilder, objectValue);
            this.writeExtraNamespaces(extraNamespaces, marshalRecord, session);
            marshalRecord.addXsiTypeAndClassIndicatorIfRequired(descriptor, descriptor, (Field)this.xmlAnyObjectMapping.getField(), originalValue, objectValue, wasXMLRoot, false);
            objectBuilder.buildRow(marshalRecord, objectValue, (CoreAbstractSession)childSession, marshaller, null);
            marshalRecord.afterContainmentMarshal(object, objectValue);
            marshalRecord.endElement(rootFragment, namespaceResolver);
            marshalRecord.removeExtraNamespacesFromNamespaceResolver(extraNamespaces, session);
        }
        return true;
    }

    @Override
    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        block5: {
            try {
                Descriptor workingDescriptor = this.findReferenceDescriptor(xPathFragment, unmarshalRecord, atts, this.xmlAnyObjectMapping, (UnmarshalKeepAsElementPolicy)this.xmlAnyObjectMapping.getKeepAsElementPolicy());
                Object policy = this.xmlAnyObjectMapping.getKeepAsElementPolicy();
                if (policy != null && (workingDescriptor == null && policy.isKeepUnknownAsElement() || policy.isKeepAllAsElement())) {
                    this.setupHandlerForKeepAsElementPolicy(unmarshalRecord, xPathFragment, atts);
                    break block5;
                }
                if (workingDescriptor != null) {
                    this.processChild(xPathFragment, unmarshalRecord, atts, workingDescriptor, this.xmlAnyObjectMapping);
                    break block5;
                }
                AnyMappingContentHandler handler = new AnyMappingContentHandler(unmarshalRecord, this.xmlAnyObjectMapping.usesXMLRoot());
                String qnameString = xPathFragment.getLocalName();
                if (xPathFragment.getPrefix() != null) {
                    qnameString = String.valueOf(xPathFragment.getPrefix()) + ':' + qnameString;
                }
                handler.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), qnameString, atts);
                XMLReader xmlReader = unmarshalRecord.getXMLReader();
                xmlReader.setContentHandler(handler);
                xmlReader.setLexicalHandler(handler);
                return true;
            }
            catch (SAXException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
        }
        return true;
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        UnmarshalRecord childRecord = unmarshalRecord.getChildRecord();
        if (childRecord != null) {
            Descriptor workingDescriptor;
            Object childObject = childRecord.getCurrentObject();
            if (this.xmlAnyObjectMapping.usesXMLRoot() && (workingDescriptor = childRecord.getDescriptor()) != null) {
                String prefix = xPathFragment.getPrefix();
                if (prefix == null && xPathFragment.getNamespaceURI() != null) {
                    prefix = unmarshalRecord.resolveNamespaceUri(xPathFragment.getNamespaceURI());
                }
                childObject = workingDescriptor.wrapObjectInXMLRoot(childObject, xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), prefix, false, unmarshalRecord.isNamespaceAware(), unmarshalRecord.getUnmarshaller());
                workingDescriptor = null;
            }
            childObject = this.xmlAnyObjectMapping.convertDataValueToObjectValue(childObject, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
            unmarshalRecord.setAttributeValue(childObject, this.xmlAnyObjectMapping);
        } else {
            SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
            Object keepAsElementPolicy = this.xmlAnyObjectMapping.getKeepAsElementPolicy();
            if (keepAsElementPolicy != null && (keepAsElementPolicy.isKeepUnknownAsElement() || keepAsElementPolicy.isKeepAllAsElement()) && builder.getNodes().size() > 1) {
                this.setOrAddAttributeValueForKeepAsElement(builder, this.xmlAnyObjectMapping, this.xmlAnyObjectMapping, unmarshalRecord, false, null);
            } else if (this.xmlAnyObjectMapping.isMixedContent()) {
                this.endElementProcessText(unmarshalRecord, this.xmlAnyObjectMapping, xPathFragment, null);
            } else {
                unmarshalRecord.resetStringBuffer();
            }
        }
    }

    @Override
    protected void setOrAddAttributeValue(UnmarshalRecord unmarshalRecord, Object value, XPathFragment xPathFragment, Object collection) {
        if (!this.xmlAnyObjectMapping.usesXMLRoot()) {
            unmarshalRecord.setAttributeValue(value, this.xmlAnyObjectMapping);
        } else {
            Root xmlRoot = unmarshalRecord.createRoot();
            xmlRoot.setNamespaceURI(xPathFragment.getNamespaceURI());
            xmlRoot.setSchemaType(unmarshalRecord.getTypeQName());
            xmlRoot.setLocalName(xPathFragment.getLocalName());
            xmlRoot.setObject(value);
            unmarshalRecord.setAttributeValue(xmlRoot, this.xmlAnyObjectMapping);
        }
    }

    private Namespace setupFragment(Root originalValue, XPathFragment xmlRootFragment, MarshalRecord marshalRecord) {
        Namespace generatedNamespace = null;
        String xpath = originalValue.getLocalName();
        if (originalValue.getNamespaceURI() != null) {
            xmlRootFragment.setNamespaceURI(originalValue.getNamespaceURI());
            String prefix = ((NamespaceResolver)marshalRecord.getNamespaceResolver()).resolveNamespaceURI(originalValue.getNamespaceURI());
            if (prefix == null || prefix.length() == 0) {
                prefix = ((NamespaceResolver)marshalRecord.getNamespaceResolver()).generatePrefix("ns0");
                generatedNamespace = new Namespace(prefix, xmlRootFragment.getNamespaceURI());
                xmlRootFragment.setGeneratedPrefix(true);
            }
            xpath = String.valueOf(prefix) + ':' + xpath;
        }
        xmlRootFragment.setXPath(xpath);
        return generatedNamespace;
    }

    private void marshalSimpleValue(XPathFragment xmlRootFragment, MarshalRecord marshalRecord, Object originalValue, Object object, Object value, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        QName qname = null;
        if (xmlRootFragment != null) {
            qname = ((Root)originalValue).getSchemaType();
            this.setupFragment((Root)originalValue, xmlRootFragment, marshalRecord);
            this.getXPathNode().startElement(marshalRecord, xmlRootFragment, object, session, namespaceResolver, null, null);
            this.updateNamespaces(qname, marshalRecord, null);
        }
        if (value instanceof Node) {
            marshalRecord.node((Node)value, marshalRecord.getNamespaceResolver());
        } else {
            marshalRecord.characters(qname, value, null, false);
        }
        if (xmlRootFragment != null) {
            marshalRecord.endElement(xmlRootFragment, namespaceResolver);
        }
    }

    @Override
    public AnyObjectMapping getMapping() {
        return this.xmlAnyObjectMapping;
    }

    @Override
    public boolean isWhitespaceAware() {
        return false;
    }

    @Override
    public boolean isAnyMappingNodeValue() {
        return true;
    }

    @Override
    public boolean isMixedContentNodeValue() {
        return this.xmlAnyObjectMapping.isMixedContent();
    }

    @Override
    protected Descriptor findReferenceDescriptor(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts, Mapping mapping, UnmarshalKeepAsElementPolicy policy) {
        XPathQName xpathQName;
        Object xmlContext;
        Descriptor referenceDescriptor = super.findReferenceDescriptor(xPathFragment, unmarshalRecord, atts, mapping, policy);
        if (referenceDescriptor == null && (referenceDescriptor = ((Context)(xmlContext = ((Unmarshaller)unmarshalRecord.getUnmarshaller()).getContext())).getDescriptor(xpathQName = new XPathQName(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), unmarshalRecord.isNamespaceAware()))) != null && referenceDescriptor.isWrapper()) {
            referenceDescriptor = null;
        }
        return referenceDescriptor;
    }
}

