/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.credentials.authenticator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.definition.CommonProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinitionAware;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.profile.SAML2Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2Authenticator
extends ProfileDefinitionAware<SAML2Profile>
implements Authenticator<SAML2Credentials> {
    public static final String SAML_CONDITION_NOT_BEFORE_ATTRIBUTE = "notBefore";
    public static final String SAML_CONDITION_NOT_ON_OR_AFTER_ATTRIBUTE = "notOnOrAfter";
    public static final String SESSION_INDEX = "sessionindex";
    public static final String ISSUER_ID = "issuerId";
    public static final String AUTHN_CONTEXT = "authnContext";
    public static final String SAML_NAME_ID_FORMAT = "samlNameIdFormat";
    public static final String SAML_NAME_ID_NAME_QUALIFIER = "samlNameIdNameQualifier";
    public static final String SAML_NAME_ID_SP_NAME_QUALIFIER = "samlNameIdSpNameQualifier";
    public static final String SAML_NAME_ID_SP_PROVIDED_ID = "samlNameIdSpProvidedId";
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String attributeAsId;
    private final Map<String, String> mappedAttributes;

    public SAML2Authenticator(String attributeAsId, Map<String, String> mappedAttributes) {
        this.attributeAsId = attributeAsId;
        this.mappedAttributes = mappedAttributes;
    }

    public SAML2Authenticator(String attributeAsId) {
        this(attributeAsId, new HashMap<String, String>());
    }

    protected void internalInit() {
        this.defaultProfileDefinition((ProfileDefinition)new CommonProfileDefinition(x -> new SAML2Profile()));
    }

    public void validate(SAML2Credentials credentials, WebContext context) {
        this.init();
        SAML2Profile profile = (SAML2Profile)this.getProfileDefinition().newProfile(new Object[0]);
        SAML2Credentials.SAMLNameID nameId = credentials.getNameId();
        profile.setId(nameId.getValue());
        profile.addAuthenticationAttribute(SESSION_INDEX, credentials.getSessionIndex());
        profile.addAuthenticationAttribute(SAML_NAME_ID_FORMAT, nameId.getFormat());
        profile.addAuthenticationAttribute(SAML_NAME_ID_NAME_QUALIFIER, nameId.getNameQualifier());
        profile.addAuthenticationAttribute(SAML_NAME_ID_SP_NAME_QUALIFIER, nameId.getSpNameQualifier());
        profile.addAuthenticationAttribute(SAML_NAME_ID_SP_PROVIDED_ID, nameId.getSpProviderId());
        for (SAML2Credentials.SAMLAttribute attribute : credentials.getAttributes()) {
            this.logger.debug("Processing profile attribute {}", (Object)attribute);
            String name = attribute.getName();
            String friendlyName = attribute.getFriendlyName();
            List<String> values = attribute.getAttributeValues();
            if (!values.isEmpty()) {
                if (CommonHelper.isNotBlank((String)this.attributeAsId) && (this.attributeAsId.equalsIgnoreCase(name) || this.attributeAsId.equalsIgnoreCase(friendlyName))) {
                    if (values.size() == 1) {
                        profile.setId(values.get(0));
                    } else {
                        this.logger.warn("Will not add {} as id because it has multiple values: {}", (Object)this.attributeAsId, values);
                    }
                }
                if (this.mappedAttributes != null && !this.mappedAttributes.isEmpty() && this.mappedAttributes.containsKey(name)) {
                    String newName = this.mappedAttributes.get(name);
                    this.logger.debug("Mapping attribute {} as {} with values {} to profile", new Object[]{name, newName, values});
                    this.getProfileDefinition().convertAndAdd((CommonProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, newName, values);
                } else {
                    this.logger.debug("Adding attribute {} to profile with values {}", (Object)name, values);
                    this.getProfileDefinition().convertAndAdd((CommonProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, name, values);
                }
                if (!CommonHelper.isNotBlank((String)friendlyName)) continue;
                this.logger.debug("Adding attribute {} to profile with values {}", (Object)friendlyName, values);
                this.getProfileDefinition().convertAndAdd((CommonProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, friendlyName, values);
                continue;
            }
            this.logger.debug("No attribute values found for {}", (Object)name);
        }
        profile.addAuthenticationAttribute(ISSUER_ID, credentials.getIssuerId());
        profile.addAuthenticationAttribute(AUTHN_CONTEXT, credentials.getAuthnContexts());
        SAML2Credentials.SAMLConditions conditions = credentials.getConditions();
        if (conditions != null) {
            profile.addAttribute(SAML_CONDITION_NOT_BEFORE_ATTRIBUTE, conditions.getNotBefore());
            profile.addAuthenticationAttribute(SAML_CONDITION_NOT_BEFORE_ATTRIBUTE, conditions.getNotBefore());
            profile.addAttribute(SAML_CONDITION_NOT_ON_OR_AFTER_ATTRIBUTE, conditions.getNotOnOrAfter());
            profile.addAuthenticationAttribute(SAML_CONDITION_NOT_ON_OR_AFTER_ATTRIBUTE, conditions.getNotOnOrAfter());
        }
        credentials.setUserProfile(profile);
    }
}

