/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHostCertInfo;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Arguments to add custom certificates to the Auto-TLS certificate database")
public class ApiAddCustomCertsArguments {
    @SerializedName(value="location")
    private String location = null;
    @SerializedName(value="interpretAsFilenames")
    private Boolean interpretAsFilenames = null;
    @SerializedName(value="hostCerts")
    private List<ApiHostCertInfo> hostCerts = null;

    public ApiAddCustomCertsArguments location(String location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(example="/opt/cloudera/CMCA", value="The location on disk to store the CMCA directory. If there is already a CMCA created there, it will be backed up, and a new one will be created in its place.")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public ApiAddCustomCertsArguments interpretAsFilenames(Boolean interpretAsFilenames) {
        this.interpretAsFilenames = interpretAsFilenames;
        return this;
    }

    @ApiModelProperty(example="true", value="Whether the following arguments are interpreted as filenames local to the Cloudera Manager host (true, default) or as the actual data for that argument: * hostCerts.hostCert * hostCerts.hostKey  If HTTPS has not been enabled on the Cloudera Manager Admin Console and API, we *strongly* recommend that you pass the arguments as filenames local to the Cloudera Manager host (i.e. set to true) to avoid leaking sensitive information over the wire in plaintext.")
    public Boolean getInterpretAsFilenames() {
        return this.interpretAsFilenames;
    }

    public void setInterpretAsFilenames(Boolean interpretAsFilenames) {
        this.interpretAsFilenames = interpretAsFilenames;
    }

    public ApiAddCustomCertsArguments hostCerts(List<ApiHostCertInfo> hostCerts) {
        this.hostCerts = hostCerts;
        return this;
    }

    public ApiAddCustomCertsArguments addHostCertsItem(ApiHostCertInfo hostCertsItem) {
        if (this.hostCerts == null) {
            this.hostCerts = new ArrayList<ApiHostCertInfo>();
        }
        this.hostCerts.add(hostCertsItem);
        return this;
    }

    @ApiModelProperty(value="A list of HostCertInfo objects, which associate a hostname with the corresponding certificate and private key. Only used if customCA == true.")
    public List<ApiHostCertInfo> getHostCerts() {
        return this.hostCerts;
    }

    public void setHostCerts(List<ApiHostCertInfo> hostCerts) {
        this.hostCerts = hostCerts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiAddCustomCertsArguments apiAddCustomCertsArguments = (ApiAddCustomCertsArguments)o;
        return Objects.equals(this.location, apiAddCustomCertsArguments.location) && Objects.equals(this.interpretAsFilenames, apiAddCustomCertsArguments.interpretAsFilenames) && Objects.equals(this.hostCerts, apiAddCustomCertsArguments.hostCerts);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.interpretAsFilenames, this.hostCerts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiAddCustomCertsArguments {\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    interpretAsFilenames: ").append(this.toIndentedString(this.interpretAsFilenames)).append("\n");
        sb.append("    hostCerts: ").append(this.toIndentedString(this.hostCerts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

