/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.api.xml.XmlService;
import org.apache.maven.project.ExtensionDescriptor;

public class ExtensionDescriptorBuilder {
    public String getExtensionDescriptorLocation() {
        return "META-INF/maven/extension.xml";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExtensionDescriptor build(File extensionJar) throws IOException {
        ExtensionDescriptor extensionDescriptor = null;
        if (extensionJar.isFile()) {
            try (JarFile pluginJar = new JarFile(extensionJar, false);){
                ZipEntry pluginDescriptorEntry = pluginJar.getEntry(this.getExtensionDescriptorLocation());
                if (pluginDescriptorEntry == null) return extensionDescriptor;
                try (InputStream is = pluginJar.getInputStream(pluginDescriptorEntry);){
                    extensionDescriptor = this.build(is);
                    return extensionDescriptor;
                }
            }
        }
        File pluginXml = new File(extensionJar, this.getExtensionDescriptorLocation());
        if (!pluginXml.canRead()) return extensionDescriptor;
        try (InputStream is = Files.newInputStream(pluginXml.toPath(), new OpenOption[0]);){
            extensionDescriptor = this.build(is);
            return extensionDescriptor;
        }
    }

    public ExtensionDescriptor build(InputStream is) throws IOException {
        XmlNode dom;
        ExtensionDescriptor extensionDescriptor = new ExtensionDescriptor();
        try {
            XMLStreamReader reader = XMLInputFactory.newFactory().createXMLStreamReader(is);
            dom = XmlService.read((XMLStreamReader)reader);
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage(), e);
        }
        if (!"extension".equals(dom.name())) {
            throw new IOException("Unexpected root element \"" + dom.name() + "\", expected \"extension\"");
        }
        extensionDescriptor.setExportedPackages(this.parseStrings(dom.child("exportedPackages")));
        extensionDescriptor.setExportedArtifacts(this.parseStrings(dom.child("exportedArtifacts")));
        return extensionDescriptor;
    }

    private List<String> parseStrings(XmlNode dom) {
        ArrayList<String> strings = null;
        if (dom != null) {
            strings = new ArrayList<String>();
            for (XmlNode child : dom.children()) {
                String string = child.value();
                if (string == null || (string = string.trim()).isEmpty()) continue;
                strings.add(string);
            }
        }
        return strings;
    }
}

