/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.security.PublicKey;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.SshPublicKey;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.ValidateUtils;

public interface OpenSshCertificate
extends SshPublicKey {
    public static final long MIN_EPOCH = 0L;
    public static final long INFINITY = -1L;

    public String getRawKeyType();

    public byte[] getNonce();

    public PublicKey getCertPubKey();

    public long getSerial();

    public Type getType();

    public String getId();

    public Collection<String> getPrincipals();

    public long getValidAfter();

    public long getValidBefore();

    public SortedMap<String, String> getCriticalOptions();

    public SortedMap<String, String> getExtensions();

    public String getReserved();

    public PublicKey getCaPubKey();

    public byte[] getMessage();

    public byte[] getSignature();

    public String getSignatureAlgorithm();

    public byte[] getRawSignature();

    public static boolean isValidNow(OpenSshCertificate cert) {
        long now = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        return Long.compareUnsigned(cert.getValidAfter(), now) <= 0 && Long.compareUnsigned(now, cert.getValidBefore()) < 0;
    }

    public static boolean isValidAt(OpenSshCertificate cert, Instant time) {
        long at = time.getEpochSecond();
        if (at < 0L) {
            return false;
        }
        return Long.compareUnsigned(cert.getValidAfter(), at) <= 0 && Long.compareUnsigned(at, cert.getValidBefore()) < 0;
    }

    public static boolean verifySignature(OpenSshCertificate cert, List<NamedFactory<Signature>> signatureFactories) throws Exception {
        String sigAlg;
        PublicKey signatureKey = cert.getCaPubKey();
        if (signatureKey instanceof OpenSshCertificate || cert.getCertPubKey() instanceof OpenSshCertificate) {
            return false;
        }
        String keyAlg = KeyUtils.getKeyType(signatureKey);
        if (!keyAlg.equals(KeyUtils.getCanonicalKeyType(sigAlg = cert.getSignatureAlgorithm()))) {
            return false;
        }
        Signature verifier = NamedFactory.create(signatureFactories, sigAlg);
        if (verifier == null) {
            return false;
        }
        verifier.initVerifier(null, signatureKey);
        verifier.update(null, cert.getMessage());
        return verifier.verify(null, cert.getSignature());
    }

    public static enum Type {
        USER,
        HOST;

        public static final List<Type> VALUES;

        public int getCode() {
            return this.ordinal() + 1;
        }

        public static Type fromCode(int code) {
            ValidateUtils.checkTrue(code > 0 && code <= VALUES.size(), "Invalid type code: %d", code);
            return VALUES.get(code - 1);
        }

        static {
            VALUES = Collections.unmodifiableList(Arrays.asList(Type.values()));
        }
    }
}

