/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIColumnNode;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColumnNodeTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnNodeTag.class);
    private ValueExpression tip;
    private ValueExpression disabled;
    private ValueExpression markup;
    private ValueExpression resizable;
    private ValueExpression label;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.ColumnNode";
    }

    public String getRendererType() {
        return "TreeNode";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UIColumnNode component = (UIColumnNode)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.tip != null) {
            component.setValueExpression("tip", this.tip);
        }
        if (this.disabled != null) {
            if (!this.disabled.isLiteralText()) {
                component.setValueExpression("disabled", this.disabled);
            } else {
                component.setDisabled(Boolean.parseBoolean(this.disabled.getExpressionString()));
            }
        }
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.resizable != null) {
            if (!this.resizable.isLiteralText()) {
                component.setValueExpression("resizable", this.resizable);
            } else {
                component.setResizable(Boolean.parseBoolean(this.resizable.getExpressionString()));
            }
        }
        if (this.label != null) {
            component.setValueExpression("label", this.label);
        }
    }

    public ValueExpression getTip() {
        return this.tip;
    }

    public void setTip(ValueExpression tip) {
        this.tip = tip;
    }

    public ValueExpression getDisabled() {
        return this.disabled;
    }

    public void setDisabled(ValueExpression disabled) {
        this.disabled = disabled;
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public ValueExpression getResizable() {
        return this.resizable;
    }

    public void setResizable(ValueExpression resizable) {
        this.resizable = resizable;
    }

    public ValueExpression getLabel() {
        return this.label;
    }

    public void setLabel(ValueExpression label) {
        this.label = label;
    }

    public void release() {
        super.release();
        this.tip = null;
        this.disabled = null;
        this.markup = null;
        this.resizable = null;
        this.label = null;
    }
}

