/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.tree.TreeNode;

public class TreePath
implements Serializable {
    private final int[] path;

    public TreePath(int ... path) {
        this.path = path;
    }

    public TreePath(List<Integer> pathList) {
        this.path = new int[pathList.size()];
        for (int i = 0; i < this.path.length; ++i) {
            this.path[i] = pathList.get(i);
        }
    }

    public TreePath(TreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        TreeNode p = node;
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        int n = 0;
        while (p != null) {
            list.add(p);
            p = p.getParent();
            ++n;
        }
        this.path = new int[n - 1];
        block1: for (int i = n - 2; i >= 0; --i) {
            TreeNode parent = (TreeNode)list.get(i + 1);
            TreeNode child = (TreeNode)list.get(i);
            for (int j = 0; j < parent.getChildCount(); ++j) {
                if (parent.getChildAt(j) != child) continue;
                this.path[n - 2 - i] = j;
                continue block1;
            }
        }
    }

    public int[] getPath() {
        return this.path;
    }

    public TreePath getParent() {
        return new TreePath(Arrays.copyOf(this.path, this.path.length - 1));
    }

    public boolean isRoot() {
        return this.path.length == 0;
    }

    public int getLength() {
        return this.path.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreePath nodeIndex = (TreePath)o;
        return Arrays.equals(this.path, nodeIndex.path);
    }

    public int hashCode() {
        return this.path != null ? Arrays.hashCode(this.path) : 0;
    }

    public String toString() {
        return Arrays.toString(this.path);
    }
}

