/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.context.FacesContext;
import jakarta.faces.context.PartialViewContext;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.myfaces.tobago.internal.component.AbstractUIReload;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.AjaxUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadRenderer<T extends AbstractUIReload>
extends RendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        String sourceId = (String)facesContext.getExternalContext().getRequestParameterMap().get("jakarta.faces.source");
        String clientId = component.getClientId(facesContext);
        if (clientId.equals(sourceId)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("matching = '{}'", (Object)clientId);
            }
            if (AjaxUtils.isAjaxRequest(facesContext) && component.isRendered() && !((AbstractUIReload)((Object)component)).isUpdate()) {
                PartialViewContext partialViewContext = facesContext.getPartialViewContext();
                String parentId = component.getParent().getClientId(facesContext);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("removing '{}' from lists renderIds and executeIds", (Object)clientId);
                }
                partialViewContext.getRenderIds().remove(parentId);
                partialViewContext.getExecuteIds().remove(parentId);
            }
        }
    }

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.TOBAGO_RELOAD);
        writer.writeIdAttribute(component.getClientId(facesContext));
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.FREQUENCY, ((AbstractUIReload)((Object)component)).getFrequency());
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.TOBAGO_RELOAD);
    }
}

