/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.model;

import java.io.Serializable;
import java.util.Date;
import java.util.TimeZone;
import org.apache.myfaces.custom.schedule.util.ScheduleUtil;

public class Interval
implements Serializable,
Comparable {
    private String label;
    private Date startTime;
    private Date endTime;

    public Interval(String label, Date startTime, Date endTime) {
        this.label = label;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public boolean containsDate(Date clickedDate) {
        return !this.getStartTime().after(clickedDate) && clickedDate.before(this.getEndTime());
    }

    public int compareTo(Object o) {
        if (o instanceof Interval) {
            return this.startTime.compareTo(((Interval)o).startTime);
        }
        return 1;
    }

    public boolean after(Interval last) {
        return !this.startTime.before(last.getEndTime());
    }

    public int getStartHours(TimeZone timeZone) {
        return ScheduleUtil.getCalendarInstance(this.getStartTime(), timeZone).get(11);
    }

    public int getStartMinutes(TimeZone timeZone) {
        return ScheduleUtil.getCalendarInstance(this.getStartTime(), timeZone).get(12);
    }

    public long getDuration() {
        return this.getEndTime().getTime() - this.getStartTime().getTime();
    }

    public boolean isEquivalent(Interval other) {
        return this.label.equals(other.label) && ScheduleUtil.isSameTime(this.startTime, other.startTime) && ScheduleUtil.isSameTime(this.endTime, other.endTime);
    }

    public int hashCode() {
        return this.label.hashCode() + this.startTime.hashCode() + this.endTime.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Interval) {
            Interval other = (Interval)obj;
            return this.label.equals(other.label) && this.startTime.equals(other.startTime) && this.endTime.equals(other.endTime);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + " Start:" + this.startTime + " End:" + this.endTime;
    }
}

