/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.sortheader;

import javax.faces.component.UIComponent;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.ext.HtmlCommandLink;
import org.apache.myfaces.component.html.ext.HtmlDataTable;

public abstract class AbstractHtmlCommandSortHeader
extends HtmlCommandLink {
    private static final Log log = LogFactory.getLog((Class)AbstractHtmlCommandSortHeader.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlCommandSortHeader";
    public static final String COMPONENT_FAMILY = "javax.faces.Command";
    public static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.SortHeader";

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof ActionEvent) {
            HtmlDataTable dataTable = this.findParentDataTable();
            if (dataTable == null) {
                log.error((Object)"CommandSortHeader has no MyFacesHtmlDataTable parent");
            } else {
                String colName = this.getColumnName();
                String currentSortColumn = dataTable.getSortColumn();
                boolean currentAscending = dataTable.isSortAscending();
                if (colName.equals(currentSortColumn)) {
                    String propName = this.getPropertyName();
                    if (propName != null) {
                        dataTable.setSortProperty(this.getPropertyName());
                    }
                    dataTable.setSortColumn(this.getColumnName());
                    dataTable.setSortAscending(!currentAscending);
                } else {
                    dataTable.setSortProperty(this.getPropertyName());
                    dataTable.setSortColumn(this.getColumnName());
                    dataTable.setSortAscending(true);
                }
            }
        }
        super.broadcast(event);
    }

    public HtmlDataTable findParentDataTable() {
        for (UIComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof HtmlDataTable)) continue;
            return (HtmlDataTable)parent;
        }
        return null;
    }

    public abstract String getColumnName();

    public abstract String getPropertyName();

    public abstract boolean isArrow();
}

