/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.util;

import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LocaleUtils {
    private static final Logger log = Logger.getLogger(LocaleUtils.class.getName());

    private LocaleUtils() {
    }

    public static Locale toLocale(String localeString) {
        String variant;
        String country;
        String language;
        int separator;
        if (localeString == null || localeString.length() == 0) {
            Locale locale = Locale.getDefault();
            if (log.isLoggable(Level.WARNING)) {
                log.warning("Locale name in faces-config.xml null or empty, setting locale to default locale : " + locale.toString());
            }
            return locale;
        }
        int separatorCountry = localeString.indexOf(95);
        if (separatorCountry >= 0) {
            separator = 95;
        } else {
            separatorCountry = localeString.indexOf(45);
            separator = 45;
        }
        if (separatorCountry < 0) {
            language = localeString;
            country = "";
            variant = "";
        } else {
            language = localeString.substring(0, separatorCountry);
            int separatorVariant = localeString.indexOf(separator, separatorCountry + 1);
            if (separatorVariant < 0) {
                country = localeString.substring(separatorCountry + 1);
                variant = "";
            } else {
                country = localeString.substring(separatorCountry + 1, separatorVariant);
                variant = localeString.substring(separatorVariant + 1);
            }
        }
        return new Locale(language, country, variant);
    }

    public static Locale converterTagLocaleFromString(String name) {
        try {
            Locale locale;
            StringTokenizer st = new StringTokenizer(name, "_");
            String language = st.nextToken();
            if (st.hasMoreTokens()) {
                String country = st.nextToken();
                if (st.hasMoreTokens()) {
                    String variant = st.nextToken();
                    locale = new Locale(language, country, variant);
                } else {
                    locale = new Locale(language, country);
                }
            } else {
                locale = new Locale(language);
            }
            return locale;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Locale parsing exception - invalid string representation '" + name + "'");
        }
    }
}

