/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.laf.browser;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.PainterImageRenderer;
import org.apache.myfaces.trinidadinternal.image.laf.browser.BlafImageUtils;
import org.apache.myfaces.trinidadinternal.image.laf.browser.ButtonPainter;
import org.apache.myfaces.trinidadinternal.image.painter.ImmInsets;
import org.apache.myfaces.trinidadinternal.image.painter.PaintContext;
import org.apache.myfaces.trinidadinternal.image.painter.PaintContextProxy;
import org.apache.myfaces.trinidadinternal.image.painter.Painter;
import org.apache.myfaces.trinidadinternal.style.util.FontProxy;
import org.apache.myfaces.trinidadinternal.style.util.GraphicsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonImageRenderer
extends PainterImageRenderer {
    private static Painter _sDialogButtonPainter;

    public ButtonImageRenderer() {
        super(new ButtonPainter());
    }

    @Override
    protected Painter getPainter(ImageContext imageContext, Map<Object, Object> requestedProperties) {
        if ("dialog".equalsIgnoreCase(this._getFontName(requestedProperties))) {
            ImmInsets insets = BlafImageUtils.__getDialogPadding();
            int topMargin = 3 - insets.top;
            int bottomMargin = 3 - insets.bottom;
            if (_sDialogButtonPainter == null) {
                _sDialogButtonPainter = new ButtonPainter(topMargin, bottomMargin);
            }
            return _sDialogButtonPainter;
        }
        return super.getPainter(imageContext, requestedProperties);
    }

    @Override
    protected boolean isRenderable(ImageContext imageContext, Map<Object, Object> requestedProperties) {
        if (!super.isRenderable(imageContext, requestedProperties)) {
            return false;
        }
        return GraphicsUtils.isFontName(this._getFontName(requestedProperties));
    }

    @Override
    protected PaintContext createPaintContext(ImageContext imageContext, BufferedImage image, Map<Object, Object> requestedProperties, Map<Object, Object> responseProperties) {
        return new ProxyContext(super.createPaintContext(imageContext, image, requestedProperties, responseProperties));
    }

    @Override
    protected Color getPaintForeground(ImageContext context, Map<Object, Object> d) {
        Color foreground = super.getPaintForeground(context, d);
        if (foreground != null) {
            return foreground;
        }
        return ButtonPainter.getDefaultForeground(context, this._isDisabled(d));
    }

    @Override
    protected Color getPaintBackground(ImageContext context, Map<Object, Object> d) {
        Color background = super.getPaintBackground(context, d);
        if (background != null) {
            return background;
        }
        return ButtonPainter.getDefaultBackground(context, this._isDisabled(d));
    }

    @Override
    protected Font getPaintFont(Map<Object, Object> d) {
        Font font = super.getPaintFont(d);
        if (font != null) {
            return font;
        }
        return ButtonPainter.getDefaultFont().getFont();
    }

    private String _getFontName(Map<Object, Object> requestedProperties) {
        Object o = requestedProperties.get(FONT_KEY);
        String name = null;
        if (o instanceof FontProxy) {
            name = ((FontProxy)o).getName();
        } else if (o instanceof Font) {
            name = ((Font)o).getName();
        }
        return name;
    }

    private boolean _isDisabled(Map<Object, Object> properties) {
        Boolean disabled = (Boolean)properties.get(DISABLED_KEY);
        if (disabled == null) {
            return false;
        }
        return disabled;
    }

    private static class ProxyContext
    extends PaintContextProxy {
        private PaintContext _context;

        public ProxyContext(PaintContext context) {
            this._context = context;
        }

        public Object getPaintData(Object key) {
            Object o = super.getPaintData(key);
            if (o != null) {
                if (key.equals(ImageConstants.TEXT_KEY) && "".equals(o)) {
                    o = " ";
                }
                return o;
            }
            if (key.equals(MNEMONIC_INDEX_KEY)) {
                return this._getMnemonicIndex();
            }
            return null;
        }

        protected PaintContext getPaintContext() {
            return this._context;
        }

        private Integer _getMnemonicIndex() {
            Object o = super.getPaintData(ImageConstants.ACCESS_KEY_KEY);
            if (!(o instanceof Character)) {
                return null;
            }
            char c = ((Character)o).charValue();
            String text = (String)super.getPaintData(ImageConstants.TEXT_KEY);
            if (text == null) {
                return null;
            }
            int index = BlafImageUtils.__getMnemonicIndex(text, c);
            if (index < 0) {
                return null;
            }
            return index;
        }
    }
}

