/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.io.ResponseWriterDecorator;

public class DebugHtmlResponseWriter
extends ResponseWriterDecorator {
    private Stack<String> _elementStack = new Stack();
    private static final Map<String, List<String>> _sAllowedParents = new HashMap<String, List<String>>(13);
    private static final Map<String, List<String>> _sAllowedChildren = new HashMap<String, List<String>>(13);
    private static final TrinidadLogger _LOG;

    public DebugHtmlResponseWriter(ResponseWriter decorated) {
        super(decorated);
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        DebugHtmlResponseWriter cloned = new DebugHtmlResponseWriter(this.getResponseWriter().cloneWithWriter(writer));
        cloned._elementStack.addAll(this._elementStack);
        return cloned;
    }

    public void startElement(String name, UIComponent component) throws IOException {
        RenderingContext rc;
        String lowerName = name.toLowerCase();
        if (("form".equals(lowerName) || "body".equals(lowerName) || "html".equals(lowerName)) && this._elementStack.contains(lowerName)) {
            this._errorWithComment("Illegal HTML: Cannot nest <" + lowerName + "> elements");
        }
        if (!((rc = RenderingContext.getCurrentInstance()) != null && rc.getPartialPageContext() != null || this._elementStack.empty())) {
            String parent = this._elementStack.peek();
            Collection allowedParents = _sAllowedParents.get(lowerName);
            Collection allowedChildren = _sAllowedChildren.get(parent);
            if (allowedParents != null && !allowedParents.contains(parent) || allowedChildren != null && !"script".equals(lowerName) && !allowedChildren.contains(lowerName)) {
                this._errorWithComment("Illegal HTML: cannot put a <" + lowerName + "> element in " + "a <" + parent + "> element.");
            }
        }
        this._elementStack.push(lowerName);
        super.startElement(name, component);
    }

    public void endElement(String name) throws IOException {
        if (!this._elementStack.empty()) {
            this._elementStack.pop();
        }
        super.endElement(name);
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        String valueStr;
        if ("name".equals(name)) {
            if (value != null && value.toString().indexOf(32) >= 0) {
                if (!"a".equals(this._elementStack.peek())) {
                    _LOG.warning("Illegal character (space) in \"name\" attribute");
                }
            } else if ("target".equals(value)) {
                _LOG.warning("NAME_ATTRIBUTE_OF_TARGET_WILL_CAUSE_JAVASCRIPT_ERROR");
            }
        } else if (name != null && name.startsWith("on") && value != null && ((valueStr = value.toString()).startsWith("javascript:") || valueStr.startsWith("Javascript:"))) {
            _LOG.info("UNNECESSARY_NAME_ATTRIBUTE_START_WITH_JAVASCRIPT", (Object)name);
        }
        super.writeAttribute(name, value, componentPropertyName);
    }

    private void _errorWithComment(String text) throws IOException {
        _LOG.warning(text);
        this.writeComment("INVALID HTML:");
    }

    static {
        _sAllowedChildren.put("table", Arrays.asList("tr", "caption", "thead", "tfoot", "tbody", "col", "colgroup"));
        _sAllowedChildren.put("tr", Arrays.asList("th", "td"));
        _sAllowedChildren.put("select", Arrays.asList("option", "optgroup"));
        _sAllowedChildren.put("ol", Arrays.asList("li"));
        _sAllowedChildren.put("ul", Arrays.asList("li"));
        _sAllowedChildren.put("input", Arrays.asList(new String[0]));
        _sAllowedChildren.put("hr", Arrays.asList(new String[0]));
        _sAllowedChildren.put("br", Arrays.asList(new String[0]));
        _sAllowedChildren.put("area", Arrays.asList(new String[0]));
        _sAllowedChildren.put("link", Arrays.asList(new String[0]));
        _sAllowedChildren.put("img", Arrays.asList(new String[0]));
        _sAllowedChildren.put("col", Arrays.asList(new String[0]));
        _sAllowedChildren.put("frame", Arrays.asList(new String[0]));
        _sAllowedChildren.put("base", Arrays.asList(new String[0]));
        _sAllowedChildren.put("meta", Arrays.asList(new String[0]));
        _sAllowedParents.put("tr", Arrays.asList("table", "thead", "tfoot", "tbody"));
        _sAllowedParents.put("td", Arrays.asList("tr"));
        _sAllowedParents.put("th", Arrays.asList("tr"));
        _sAllowedParents.put("option", Arrays.asList("select", "optgroup"));
        _LOG = TrinidadLogger.createTrinidadLogger(DebugHtmlResponseWriter.class);
    }
}

