/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.myfaces.trinidad.model.CollectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeModel
extends CollectionModel {
    public abstract boolean isContainer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContainerEmpty() {
        if (!this.isContainer()) {
            return true;
        }
        this.enterContainer();
        try {
            int kids = this.getRowCount();
            if (kids < 0) {
                this.setRowIndex(0);
                boolean bl = !this.isRowAvailable();
                return bl;
            }
            boolean bl = kids == 0;
            return bl;
        }
        finally {
            this.exitContainer();
        }
    }

    public abstract void enterContainer();

    public abstract void exitContainer();

    public final Object getContainerRowKey() {
        Object key = this.getRowKey();
        Object parentKey = this.getContainerRowKey(key);
        return parentKey;
    }

    public List<Object> getAllAncestorContainerRowKeys(Object childRowKey) {
        if (childRowKey == null) {
            return Collections.emptyList();
        }
        int size = this.getDepth(childRowKey);
        if (size <= 0) {
            return Collections.emptyList();
        }
        Object[] keys = new Object[size];
        for (int i = size - 1; i >= 0; --i) {
            childRowKey = this.getContainerRowKey(childRowKey);
            assert (childRowKey != null);
            keys[i] = childRowKey;
        }
        return Collections.unmodifiableList(Arrays.asList(keys));
    }

    public abstract Object getContainerRowKey(Object var1);

    public final int getDepth() {
        Object key = this.getRowKey();
        return this.getDepth(key);
    }

    public int getDepth(Object rowKey) {
        Object key = rowKey;
        int depth = 0;
        while ((key = this.getContainerRowKey(key)) != null) {
            ++depth;
        }
        return depth;
    }
}

