/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.encode;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.myfaces.trinidadinternal.image.encode.AlphaMultiplyFilter;
import org.apache.myfaces.trinidadinternal.image.encode.ImageEncoder;
import org.apache.myfaces.trinidadinternal.image.encode.OctreeFilter;

public class AlphaMultiplyEncoder
implements ImageEncoder {
    private static final int _WHITE = 0xFFFFFF;
    private ImageEncoder _wrappedEncoder;

    public AlphaMultiplyEncoder(ImageEncoder wrappedEncoder) {
        this._wrappedEncoder = wrappedEncoder;
    }

    @Override
    public void encodeImage(Image image, OutputStream out) throws IOException {
        Image alphaFilteredImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), new AlphaMultiplyFilter(0xFFFFFF)));
        Image filteredImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(alphaFilteredImage.getSource(), new OctreeFilter(alphaFilteredImage)));
        this._wrappedEncoder.encodeImage(filteredImage, out);
    }
}

